/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.isc.util;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.common.constant.factory.ConstantFactory;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.shiro.factory.IShiro;
import com.jxdinfo.hussar.core.shiro.factory.ShiroFactroy;
import com.sgcc.isc.service.adapter.utils.PropertyUtil;
import io.buji.pac4j.subject.Pac4jPrincipal;
import io.buji.pac4j.token.Pac4jToken;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import org.apache.shiro.subject.PrincipalCollection;
import org.pac4j.core.profile.CommonProfile;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;

@Configuration
public class IscUtil {
    private static String loginAccount;
    private static String activeType;
    PropertyUtil propertyUtil = PropertyUtil.newInstance((String)"iscservicesadapter");

    @Value(value="${cas.login-account:login-account}")
    public void setLoginAccount(String loginAccount) {
        IscUtil.loginAccount = loginAccount;
    }

    @Value(value="${cas.active-type:active-type}")
    public void setActiveType(String activeType) {
        if ("ISC".equals(activeType)) {
            this.propertyUtil.setMsg("hussar.isc.conf.active", "true");
        }
        IscUtil.activeType = activeType;
    }

    @Value(value="${cas.sm-uri:sm-uri}")
    public void setSmUri(String smUri) {
        if ("ISC".equals(activeType)) {
            this.propertyUtil.setMsg("hussar.isc.conf.sm-uri", smUri);
        }
    }

    @Value(value="${cas.app-id:app-id}")
    public void setAppId(String appId) {
        if ("ISC".equals(activeType)) {
            this.propertyUtil.setMsg("hussar.isc.conf.app-id", appId);
        }
    }

    public static ShiroUser getShiroUserFromPac4jToken(Pac4jToken token) {
        ShiroUser user = new ShiroUser();
        List commonProfileList = token.getProfiles();
        if (commonProfileList.size() > 0) {
            CommonProfile commonProfile = (CommonProfile)commonProfileList.get(0);
            String id = commonProfile.getId();
            try {
                JSONObject json = JSONObject.parseObject((String)URLDecoder.decode(id, "UTF-8"));
                String iscUserId = json.get((Object)"iscUserId").toString();
                String iscUserSourceId = json.get((Object)"iscUserSourceId").toString();
                String iscAdCode = json.get((Object)"iscAdCode").toString();
                String baseOrgId = json.get((Object)"baseOrgId").toString();
                user.setId(iscUserId);
                user.setDeptId(baseOrgId);
                user.setName(iscAdCode);
                user.setAccount(iscUserSourceId);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return user;
    }

    public static ShiroUser getShiroUserFromPrincipalCollection(PrincipalCollection principals) {
        Pac4jPrincipal principal = (Pac4jPrincipal)principals.getPrimaryPrincipal();
        return IscUtil.getShiroUserFromPac4jPrincipal(principal);
    }

    public static String getUserIdFromPrincipalCollection(PrincipalCollection principals) {
        Pac4jPrincipal principal = (Pac4jPrincipal)principals.getPrimaryPrincipal();
        CommonProfile profile = principal.getProfile();
        String id = profile.getAttribute(loginAccount).toString();
        return id;
    }

    public static ShiroUser getShiroUserFromPac4jPrincipal(Pac4jPrincipal principal) {
        ShiroUser user = new ShiroUser();
        CommonProfile profile = principal.getProfile();
        if (activeType.equals("ISC")) {
            String id = profile.getId();
            try {
                JSONObject json = JSONObject.parseObject((String)URLDecoder.decode(id, "UTF-8"));
                String iscUserId = json.get((Object)"iscUserId").toString();
                String iscUserSourceId = json.get((Object)"iscUserSourceId").toString();
                String iscAdCode = json.get((Object)"iscAdCode").toString();
                String baseOrgId = json.get((Object)"baseOrgId").toString();
                user.setId(iscUserId);
                user.setDeptId(baseOrgId);
                user.setName(iscAdCode);
                user.setAccount(iscUserSourceId);
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            return user;
        }
        String userAccount = profile.getAttribute(loginAccount).toString();
        IShiro shiroFactory = ShiroFactroy.me();
        SysUsers sysUsers = shiroFactory.user(userAccount);
        user.setId(sysUsers.getUserId());
        user.setDeptId(sysUsers.getDepartmentId());
        user.setName(sysUsers.getUserName());
        user.setAccount(userAccount);
        user.setEmployeeId(sysUsers.getEmployeeId());
        user.setDeptName(ConstantFactory.me().getDeptName(sysUsers.getDepartmentId()));
        user.setSecurityLevel(sysUsers.getSecurityLevel());
        user.setAccountStatus(sysUsers.getAccountStatus());
        List<String> rolesList = ConstantFactory.me().getRolesIdByUserId(sysUsers.getUserId());
        user.setRolesList(rolesList);
        List<String> IsRepeatAuthenticate2 = ConstantFactory.me().getIsRepeatAuthenticateId(sysUsers.getUserId());
        user.setIsRepeatAuthenticate(IsRepeatAuthenticate2);
        return user;
    }
}

