/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.isc.util;

import com.jxdinfo.hussar.bsp.menu.model.MenuInfo;
import com.sgcc.isc.core.orm.complex.FunctionNode;
import com.sgcc.isc.core.orm.complex.FunctionTree;
import com.sgcc.isc.core.orm.identity.Department;
import com.sgcc.isc.core.orm.identity.User;
import com.sgcc.isc.core.orm.organization.BusinessOrganization;
import com.sgcc.isc.core.orm.resource.Function;
import com.sgcc.isc.core.orm.role.OrganizationalRole;
import com.sgcc.isc.core.orm.role.Role;
import com.sgcc.isc.framework.common.entity.Paging;
import com.sgcc.isc.service.adapter.factory.AdapterFactory;
import com.sgcc.isc.service.adapter.factory.agent.config.ConfigHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ISCTools {
    private static final String appId = ConfigHolder.getAppId();

    public static List<MenuInfo> getMenuListByUserId(String userId) {
        ArrayList<MenuInfo> menuList = new ArrayList<MenuInfo>();
        try {
            FunctionTree funcTree = AdapterFactory.getResourceService().getFuncTree(userId, appId, null);
            if (funcTree != null) {
                List fns = funcTree.getFuncNode();
                for (FunctionNode functionNode : fns) {
                    MenuInfo menu = new MenuInfo();
                    ISCTools.funcToMenu(functionNode, menu);
                    menuList.add(menu);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return menuList;
    }

    private static void funcToMenu(FunctionNode functionNode, MenuInfo menu) {
        Function fun = functionNode.getCurrentNode();
        menu.setMenuId(fun.getId());
        menu.setMenuAlias(fun.getName());
        menu.setTitle(fun.getName());
        menu.setText(fun.getName());
        menu.setParentId(fun.getFuncId());
        menu.setUrl(fun.getUrl());
        menu.setIsLeaf("Y".equals(fun.getIsLeaf()) ? "1" : "0");
        List nextNodes = functionNode.getNextNode();
        ArrayList<MenuInfo> childMenus = new ArrayList<MenuInfo>();
        if (nextNodes.size() > 0) {
            for (FunctionNode functionNode2 : nextNodes) {
                if (!"01".equals(functionNode2.getCurrentNode().getFuncType())) continue;
                MenuInfo menu2 = new MenuInfo();
                ISCTools.funcToMenu(functionNode2, menu2);
                childMenus.add(menu2);
            }
            menu.setChildMenus(childMenus);
        }
    }

    public static List<Department> getSubDepartment(String depId) {
        ArrayList<Department> listDepartment = new ArrayList();
        try {
            listDepartment = AdapterFactory.getIdentityService().getSubDepartment(depId, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return listDepartment;
    }

    public static List<User> getUsersByOrg(String orgId) {
        try {
            List listUser = AdapterFactory.getIdentityService().getUsersByOrg(appId, orgId, null, null);
            return listUser;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<User> getUsersByIds(String[] userIds) {
        try {
            List listUser = AdapterFactory.getIdentityService().getUserByIds(userIds);
            return listUser;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static User getUserByNamePassWord(String userName, String passWord) {
        try {
            User user = AdapterFactory.getIdentityService().userLoginAuth(userName, passWord);
            return user;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<BusinessOrganization> getBusinessOrgByUserId(String userId) {
        try {
            List listOrg = AdapterFactory.getOrganizationService().getBusiOrgByUserId(userId, appId);
            return listOrg;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Paging<?> getSubBussOrgs(String busiOrgId, Map<String, Object> filterStr, String[] orderStr, int pageSize, int pageNo, boolean isCalculate) {
        try {
            return AdapterFactory.getOrganizationService().getSubBussOrgs(busiOrgId, filterStr, orderStr, pageSize, pageNo, isCalculate);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getOrgNameById(String orgId) {
        try {
            return ((BusinessOrganization)AdapterFactory.getOrganizationService().getBusiOrgsByIds(new String[]{orgId}).get(0)).getName();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<BusinessOrganization> getSubOrg(String orgId) {
        try {
            return (List)AdapterFactory.getOrganizationService().getSubBussOrgs(orgId, null, null, Integer.MAX_VALUE, 1, true).getData();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static BusinessOrganization getOwnOrg(String orgId) {
        try {
            List busiLs = AdapterFactory.getOrganizationService().getBusiOrgsByIds(new String[]{orgId});
            if (busiLs.size() > 0) {
                return (BusinessOrganization)busiLs.get(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static List<BusinessOrganization> getOrgPathByOrgId(String orgId) {
        try {
            return AdapterFactory.getOrganizationService().getOrgPathByOrgId(orgId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<BusinessOrganization> getBusiOrgBySystemId(String systemId) {
        List<Object> list = new ArrayList<BusinessOrganization>();
        try {
            list = AdapterFactory.getOrganizationService().getChildOrgsBySystemId(systemId, null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static List<OrganizationalRole> getOrgRolesByBusiOrgId(String systemId, String busiOrgId, Map<String, String> param, String[] orderStr) {
        try {
            return AdapterFactory.getRoleService().getOrgRolesByBusiOrgId(systemId, busiOrgId, param, orderStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<User> getUsersByOrgRole(String orgRoleId, Map<String, String> param, String[] orderStr) {
        try {
            return AdapterFactory.getIdentityService().getUsersByOrgRole(orgRoleId, param, orderStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<OrganizationalRole> getOrgRolesByUserId(String userId, String systemId, Map<String, String> param) {
        try {
            return AdapterFactory.getRoleService().getOrgRolesByUserId(userId, systemId, param);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static FunctionTree getFuncTreeByRoleId(String roleId) {
        try {
            return AdapterFactory.getResourceService().getFuncTreeByRoleId(roleId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<Role> getRoleByRoleId(String roleId) {
        try {
            return AdapterFactory.getRoleService().getRoleByRoleId(roleId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static FunctionTree getFuncTree(String userId, String systemId, String funcCategory) {
        try {
            return AdapterFactory.getResourceService().getFuncTree(userId, systemId, funcCategory);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

