/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.isc.util;

import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.redirect.RedirectAction;
import org.pac4j.core.util.CommonHelper;
import org.springframework.beans.factory.annotation.Value;

public class CasClient
extends org.pac4j.cas.client.CasClient {
    private String localUrl;

    @Value(value="${cas.local-url:local-url}")
    public void setLocalUrl(String localUrl) {
        this.localUrl = localUrl;
    }

    public CasClient() {
    }

    public CasClient(CasConfiguration configuration) {
        super(configuration);
    }

    public RedirectAction getRedirectAction(WebContext context) {
        this.init();
        if (this.getAjaxRequestResolver().isAjax(context)) {
            this.logger.info("AJAX request detected -> returning the appropriate action");
            RedirectAction action = this.getRedirectActionBuilder().redirect(context);
            this.cleanRequestedUrl(context);
            String url = this.localUrl + "/casFrontLogin/addShiroCookie/?loginUrl=" + action.getLocation();
            return this.getAjaxRequestResolver().buildAjaxResponse(url, context);
        }
        String attemptedAuth = (String)context.getSessionStore().get(context, this.getName() + "$attemptedAuthentication");
        if (CommonHelper.isNotBlank((String)attemptedAuth)) {
            this.cleanAttemptedAuthentication(context);
            this.cleanRequestedUrl(context);
            return this.getRedirectActionBuilder().redirect(context);
        }
        return this.getRedirectActionBuilder().redirect(context);
    }

    private void cleanRequestedUrl(WebContext context) {
        SessionStore sessionStore = context.getSessionStore();
        if (sessionStore.get(context, "pac4jRequestedUrl") != null) {
            sessionStore.set(context, "pac4jRequestedUrl", (Object)"");
        }
    }

    private void cleanAttemptedAuthentication(WebContext context) {
        SessionStore sessionStore = context.getSessionStore();
        if (sessionStore.get(context, this.getName() + "$attemptedAuthentication") != null) {
            sessionStore.set(context, this.getName() + "$attemptedAuthentication", (Object)"");
        }
    }
}

