/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.dbencryption.util;

import com.jxdinfo.hussar.core.util.SpringContextHolder;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class AESEncryptUtil {
    private static String charset = "utf-8";
    private static int offset = 16;
    private static String transformation = "AES/CBC/PKCS5Padding";
    private static String algorithm = "AES";
    private static Environment env = (Environment)SpringContextHolder.getBean(Environment.class);

    public static String encrypt(String content) {
        String key = env.getProperty("hussar.storage-encrypt-type.encrypt-key");
        return AESEncryptUtil.encrypt(content, key);
    }

    public static String decrypt(String content) {
        String key = env.getProperty("hussar.storage-encrypt-type.encrypt-key");
        return AESEncryptUtil.decrypt(content, key);
    }

    public static String encrypt(String content, String key) {
        try {
            SecretKeySpec skey = new SecretKeySpec(key.getBytes(), algorithm);
            IvParameterSpec iv = new IvParameterSpec(key.getBytes(), 0, offset);
            Cipher cipher = Cipher.getInstance(transformation);
            byte[] byteContent = content.getBytes(charset);
            cipher.init(1, (Key)skey, iv);
            byte[] result = cipher.doFinal(byteContent);
            return new Base64().encodeToString(result);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String decrypt(String content, String key) {
        try {
            SecretKeySpec skey = new SecretKeySpec(key.getBytes(), algorithm);
            IvParameterSpec iv = new IvParameterSpec(key.getBytes(), 0, offset);
            Cipher cipher = Cipher.getInstance(transformation);
            cipher.init(2, (Key)skey, iv);
            byte[] result = cipher.doFinal(new Base64().decode(content));
            return new String(result);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

