/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.util;

import com.jxdinfo.hussar.core.util.EncryptUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import org.apache.commons.lang3.StringUtils;

public class RSAEncrypUtil {
    public static final String KEY_ALGORITHM = "RSA";
    public static final String PUBLIC_KEY = "RSAPublicKey";
    public static final String PRIVATE_KEY = "RSAPrivateKey";
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int MAX_DECRYPT_BLOCK = 128;

    public static String encrypt(String encryptKey, String content) {
        try {
            return new String(EncryptUtil.Base64Encode((byte[])RSAEncrypUtil.encrypt(encryptKey, content.getBytes("UTF-8"))));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return new String(EncryptUtil.Base64Encode((byte[])RSAEncrypUtil.encrypt(encryptKey, content.getBytes())));
        }
    }

    public static byte[] encrypt(String publicKey, byte[] srcBytes) {
        if (publicKey != null) {
            try {
                byte[] keyBytes = EncryptUtil.Base64Decode((byte[])publicKey.getBytes("UTF-8"));
                X509EncodedKeySpec x509KeySpec = new X509EncodedKeySpec(keyBytes);
                KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
                PublicKey publicK = keyFactory.generatePublic(x509KeySpec);
                Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
                cipher.init(1, publicK);
                int inputLen = srcBytes.length;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                int offSet = 0;
                int i = 0;
                while (inputLen - offSet > 0) {
                    byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(srcBytes, offSet, 117) : cipher.doFinal(srcBytes, offSet, inputLen - offSet);
                    out.write(cache, 0, cache.length);
                    offSet = ++i * 117;
                }
                byte[] encryptedData = out.toByteArray();
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return encryptedData;
            }
            catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String decrypt(String decryptKey, String encryptStr) {
        try {
            return StringUtils.isEmpty((CharSequence)encryptStr) ? null : new String(RSAEncrypUtil.decrypt(decryptKey, EncryptUtil.Base64Decode((byte[])encryptStr.getBytes("UTF-8"))));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return new String(RSAEncrypUtil.decrypt(decryptKey, EncryptUtil.Base64Decode((byte[])encryptStr.getBytes())));
        }
    }

    public static byte[] decrypt(String privateKey, byte[] srcBytes) {
        if (privateKey != null) {
            try {
                byte[] keyBytes = EncryptUtil.Base64Decode((byte[])privateKey.getBytes("UTF-8"));
                PKCS8EncodedKeySpec pkcs8KeySpec = new PKCS8EncodedKeySpec(keyBytes);
                KeyFactory keyFactory = KeyFactory.getInstance(KEY_ALGORITHM);
                RSAPrivateKey privateK = (RSAPrivateKey)keyFactory.generatePrivate(pkcs8KeySpec);
                Cipher cipher = Cipher.getInstance(KEY_ALGORITHM);
                cipher.init(2, privateK);
                int inputLen = srcBytes.length;
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                int offSet = 0;
                int i = 0;
                while (inputLen - offSet > 0) {
                    byte[] cache = inputLen - offSet > 128 ? cipher.doFinal(srcBytes, offSet, 128) : cipher.doFinal(srcBytes, offSet, inputLen - offSet);
                    out.write(cache, 0, cache.length);
                    offSet = ++i * 128;
                }
                byte[] decryptedData = out.toByteArray();
                out.close();
                return decryptedData;
            }
            catch (IOException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static Map<String, Object> genKeyPair() {
        try {
            KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance(KEY_ALGORITHM);
            keyPairGen.initialize(1024);
            KeyPair keyPair = keyPairGen.generateKeyPair();
            RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
            RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
            HashMap<String, Object> keyMap = new HashMap<String, Object>(2);
            keyMap.put(PUBLIC_KEY, new String(EncryptUtil.Base64Encode((byte[])publicKey.getEncoded())));
            keyMap.put(PRIVATE_KEY, new String(EncryptUtil.Base64Encode((byte[])privateKey.getEncoded())));
            return keyMap;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return new HashMap<String, Object>(0);
        }
    }
}

