/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.util;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.commons.codec.binary.Base64;

public class QRCodeUtil {
    private static final int BLACK = -16777216;
    private static final int WHITE = -1;
    private static final List<String> IMAGE_TYPE = new ArrayList<String>();

    public static boolean zxingCodeCreate(String content, String path, Integer size, String logoPath) {
        try {
            String imageType = path.substring(path.lastIndexOf(".") + 1).toLowerCase();
            if (!IMAGE_TYPE.contains(imageType)) {
                return false;
            }
            BufferedImage image = QRCodeUtil.getBufferedImage(content, size);
            File file = new File(path);
            if (!file.exists()) {
                file.mkdirs();
            }
            ImageIO.write((RenderedImage)image, imageType, file);
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static BufferedImage getBufferedImage(String content, Integer size) {
        if (size == null || size <= 0) {
            size = 180;
        }
        BufferedImage image = null;
        try {
            HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
            hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
            hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
            hints.put(EncodeHintType.MARGIN, 1);
            MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
            BitMatrix bitMatrix = multiFormatWriter.encode(content, BarcodeFormat.QR_CODE, size.intValue(), size.intValue(), hints);
            int codeWidth = bitMatrix.getWidth();
            int codeHeight = bitMatrix.getHeight();
            image = new BufferedImage(codeWidth, codeHeight, 1);
            for (int i = 0; i < codeWidth; ++i) {
                for (int j = 0; j < codeHeight; ++j) {
                    image.setRGB(i, j, bitMatrix.get(i, j) ? -16777216 : -1);
                }
            }
            Graphics2D g = image.createGraphics();
            int x = image.getWidth() / 2;
            int y = image.getHeight() / 2;
            g.drawRoundRect(x, y, 0, 0, 15, 15);
            g.setStroke(new BasicStroke(2.0f));
            g.setColor(Color.WHITE);
            g.dispose();
            image.flush();
        }
        catch (WriterException e) {
            e.printStackTrace();
        }
        return image;
    }

    public static BufferedImage getBufferedImage(String content, Integer size, InputStream logoStream) {
        if (size == null || size <= 0) {
            size = 180;
        }
        BufferedImage image = null;
        try {
            HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
            hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
            hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
            hints.put(EncodeHintType.MARGIN, 1);
            MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
            BitMatrix bitMatrix = multiFormatWriter.encode(content, BarcodeFormat.QR_CODE, size.intValue(), size.intValue(), hints);
            int codeWidth = bitMatrix.getWidth();
            int codeHeight = bitMatrix.getHeight();
            image = new BufferedImage(codeWidth, codeHeight, 1);
            for (int i = 0; i < codeWidth; ++i) {
                for (int j = 0; j < codeHeight; ++j) {
                    image.setRGB(i, j, bitMatrix.get(i, j) ? -16777216 : -1);
                }
            }
            Graphics2D g = image.createGraphics();
            BufferedImage logo = ImageIO.read(logoStream);
            int widthLogo = logo.getWidth(null) > image.getWidth() * 2 / 10 ? image.getWidth() * 2 / 10 : logo.getWidth(null);
            int heightLogo = logo.getHeight(null) > image.getHeight() * 2 / 10 ? image.getHeight() * 2 / 10 : logo.getHeight(null);
            int x = (image.getWidth() - widthLogo) / 2;
            int y = (image.getHeight() - heightLogo) / 2;
            g.drawImage((Image)logo, x, y, null);
            g.drawRoundRect(x, y, 0, 0, 15, 15);
            g.setStroke(new BasicStroke(2.0f));
            g.setColor(Color.WHITE);
            g.drawRect(x, y, widthLogo, heightLogo);
            g.dispose();
            logo.flush();
            image.flush();
        }
        catch (WriterException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return image;
    }

    public static boolean zxingCodeCreate(File qrPic, File logoPic, String path) {
        try {
            String imageType = path.substring(path.lastIndexOf(".") + 1).toLowerCase();
            if (!IMAGE_TYPE.contains(imageType)) {
                return false;
            }
            if (!qrPic.isFile() && !logoPic.isFile()) {
                return false;
            }
            BufferedImage image = ImageIO.read(qrPic);
            Graphics2D g = image.createGraphics();
            BufferedImage logo = ImageIO.read(logoPic);
            int widthLogo = logo.getWidth(null) > image.getWidth() * 2 / 10 ? image.getWidth() * 2 / 10 : logo.getWidth(null);
            int heightLogo = logo.getHeight(null) > image.getHeight() * 2 / 10 ? image.getHeight() * 2 / 10 : logo.getHeight(null);
            int x = (image.getWidth() - widthLogo) / 2;
            int y = (image.getHeight() - heightLogo) / 2;
            g.drawImage(logo, x, y, widthLogo, heightLogo, null);
            g.drawRoundRect(x, y, widthLogo, heightLogo, 15, 15);
            g.setStroke(new BasicStroke(2.0f));
            g.setColor(Color.WHITE);
            g.drawRect(x, y, widthLogo, heightLogo);
            g.dispose();
            logo.flush();
            image.flush();
            File newFile = new File(path);
            if (!newFile.exists()) {
                newFile.mkdirs();
            }
            ImageIO.write((RenderedImage)image, imageType, newFile);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static Result zxingCodeAnalyze(String path) {
        try {
            MultiFormatReader formatReader = new MultiFormatReader();
            File file = new File(path);
            if (file.exists()) {
                BufferedImage image = ImageIO.read(file);
                BufferedImageLuminanceSource source = new BufferedImageLuminanceSource(image);
                HybridBinarizer binarizer = new HybridBinarizer((LuminanceSource)source);
                BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)binarizer);
                HashMap<EncodeHintType, String> hints = new HashMap<EncodeHintType, String>();
                hints.put(EncodeHintType.CHARACTER_SET, "UTF-8");
                Result result = formatReader.decode(binaryBitmap, hints);
                return result;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String GetImageStr(String imgFilePath) {
        byte[] data = null;
        try {
            FileInputStream in = new FileInputStream(imgFilePath);
            data = new byte[((InputStream)in).available()];
            ((InputStream)in).read(data);
            ((InputStream)in).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return Base64.encodeBase64String(data);
    }

    public static InputStream BaseToInputStream(String base64string) {
        ByteArrayInputStream stream = null;
        try {
            byte[] bytes1 = Base64.decodeBase64((String)base64string);
            stream = new ByteArrayInputStream(bytes1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return stream;
    }

    static {
        IMAGE_TYPE.add("jpg");
        IMAGE_TYPE.add("png");
    }
}

