/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.sys.service.impl;

import com.baomidou.mybatisplus.core.exceptions.MybatisPlusException;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bsp.constant.Constants;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.SuccessTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.sys.dao.SysDicSingleMapper;
import com.jxdinfo.hussar.core.sys.dao.SysDicTypeMapper;
import com.jxdinfo.hussar.core.sys.model.DicType;
import com.jxdinfo.hussar.core.sys.service.ISysDicGroupService;
import com.jxdinfo.hussar.core.sys.service.ISysDicSingleService;
import com.jxdinfo.hussar.core.sys.service.ISysDicTypeService;
import com.jxdinfo.hussar.core.util.DataExportUtils;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.SerializeUtils;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.ibatis.session.SqlSession;
import org.springframework.stereotype.Service;

@Service
public class SysDicTypeServiceImpl
extends ServiceImpl<SysDicTypeMapper, DicType>
implements ISysDicTypeService {
    @Resource
    private HussarCacheManager hussarCacheManager;
    @Resource
    private SysDicTypeMapper sysDicTypeMapper;
    @Resource
    private SysDicSingleMapper singleMapper;
    @Resource
    private ISysDicSingleService dicSingleService;
    @Resource
    private ISysDicGroupService dicGroupService;

    @Override
    public void evictTypeCacheById(String id) {
        DicType type = (DicType)((Object)this.getById((Serializable)((Object)id)));
        if (ToolUtil.isNotEmpty((Object)((Object)type))) {
            this.hussarCacheManager.deleteMore("hussar_dict_of_type_cache", "dict_of_type:" + type.getTypeName() + ":*");
        }
    }

    @Override
    public List<JSTreeModel> dicExportTreeData() {
        return this.sysDicTypeMapper.dicExportTreeData();
    }

    @Override
    public void exportDict(List<String> idList, HttpServletResponse response) {
        List group = this.dicGroupService.listByIds(idList);
        List type = this.listByIds(idList);
        List<String> singleIdList = this.getSingleIdByTypeId(idList, new ArrayList<String>());
        List single = new ArrayList();
        if (singleIdList.size() > 0) {
            single = this.dicSingleService.listByIds(singleIdList);
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("type", type);
        data.put("single", single);
        data.put("group", group);
        data.put("export_type", "dictionary");
        byte[] serializeData = SerializeUtils.serialize(data);
        String fileName = "dict_" + DateUtil.format((Date)new Date(), (String)"yyyyMMdd_HHmmss") + ".hussar";
        DataExportUtils.byteToFile(serializeData, fileName, response);
    }

    private List<String> getSingleIdByTypeId(List<String> typeIdList, List<String> resultList) {
        List<String> singleIdList = this.singleMapper.getSingleIdByTypeId(typeIdList);
        if (ToolUtil.isNotEmpty(singleIdList)) {
            resultList.addAll(singleIdList);
            this.getSingleIdByTypeId(singleIdList, resultList);
        }
        return resultList;
    }

    @Override
    public Tip importDict(byte[] content) {
        Map data = (Map)SerializeUtils.deserialize(content);
        String export_type = (String)data.get("export_type");
        if (!"dictionary".equals(export_type)) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u60a8\u5bfc\u5165\u7684\u662f" + Constants.EXPORT_MAP.get(export_type) + ",\u8bf7\u5bfc\u5165" + Constants.EXPORT_MAP.get("dictionary"));
        }
        List group = (List)data.get("group");
        List type = (List)data.get("type");
        List single = (List)data.get("single");
        if (group.size() > 0) {
            this.dicGroupService.saveOrUpdateBatch(group, group.size());
        }
        Map<String, Integer> count = this.insertOrUpdateList(type);
        if (single.size() > 0) {
            this.dicSingleService.saveOrUpdateBatch(single, single.size());
        }
        SuccessTip success = new SuccessTip();
        success.setMessage("\u5bfc\u5165\u6210\u529f\uff0c\u65b0\u589e\u6570\u636e" + count.get("insert") + "\u6761\uff0c\u66f4\u65b0\u6570\u636e" + count.get("update") + "\u6761\u3002");
        return success;
    }

    @Override
    public Map<String, Integer> insertOrUpdateList(List<DicType> dicTypeList) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        Integer update = 0;
        Integer insert = 0;
        try (SqlSession batchSqlSession = this.sqlSessionBatch();){
            int size = dicTypeList.size();
            for (int i = 0; i < size; ++i) {
                Integer n;
                Integer n2;
                if (super.updateById((Object)dicTypeList.get(i))) {
                    n2 = update;
                    n = update = Integer.valueOf(update + 1);
                } else {
                    super.save((Object)dicTypeList.get(i));
                    n2 = insert;
                    n = insert = Integer.valueOf(insert + 1);
                }
                if (i < 1 || i % size != 0) continue;
                batchSqlSession.flushStatements();
            }
            batchSqlSession.flushStatements();
        }
        catch (Throwable e) {
            throw new MybatisPlusException("Error: Cannot execute insertOrUpdateBatch Method. Cause", e);
        }
        result.put("update", update);
        result.put("insert", insert);
        return result;
    }
}

