/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.sys.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.sys.model.DicGroup;
import com.jxdinfo.hussar.core.sys.model.DicSingle;
import com.jxdinfo.hussar.core.sys.model.DicType;
import com.jxdinfo.hussar.core.sys.service.ISysDicGroupService;
import com.jxdinfo.hussar.core.sys.service.ISysDicService;
import com.jxdinfo.hussar.core.sys.service.ISysDicSingleService;
import com.jxdinfo.hussar.core.sys.service.ISysDicTypeService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysDicServiceImpl
implements ISysDicService {
    @Autowired
    private ISysDicGroupService dicGroupService;
    @Autowired
    private ISysDicSingleService dicSingleService;
    @Autowired
    private ISysDicTypeService dicTypeService;
    @Autowired
    private HussarCacheManager hussarCacheManager;
    private String pseudoRootSys = "sys";
    private String pseudoRootBiz = "biz";
    private String pseudoRootDic = "dict";
    private String flagOfExecuteType = "haveType";

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean addDicGroup(String groupParentId, String groupName) {
        this.hussarCacheManager.deleteMore("hussar_dict_of_type_cache", "dict_of_type:");
        this.checkDicGroupDuplicated(groupParentId, groupName);
        DicGroup lastOne = (DicGroup)((Object)this.dicGroupService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PARENT_ID", (Object)groupParentId)).orderByDesc((Object)"SORT"), false));
        String newId = UUID.randomUUID().toString().replace("-", "");
        DicGroup dicGroup = new DicGroup();
        dicGroup.setId(newId);
        dicGroup.setParentId(groupParentId);
        dicGroup.setGroupDescription(groupName);
        dicGroup.setRangeType(this.pseudoRootDic);
        if (ToolUtil.isEmpty((Object)((Object)lastOne))) {
            dicGroup.setSort(3);
        } else {
            dicGroup.setSort(lastOne.getSort() + 1);
        }
        this.setTimeAndEditor(dicGroup, true);
        return this.dicGroupService.save((Object)dicGroup);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean editDictGroup(String groupId, String groupName) {
        DicGroup dicGroup = new DicGroup();
        dicGroup.setId(groupId);
        dicGroup.setGroupDescription(groupName);
        dicGroup.setLastTime(new Date());
        dicGroup.setLastEditor(ShiroKit.getUser().getId());
        return this.dicGroupService.updateById((Object)dicGroup);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean addDictType(String parentId, String dictName, String dictTypeCode, String dictValues) {
        this.hussarCacheManager.deleteMore("hussar_dict_of_type_cache", "dict_of_type:");
        this.checkDicTypeDuplicated(null, dictName, dictTypeCode);
        DicType lastOne = (DicType)((Object)this.dicTypeService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PARENT_ID", (Object)parentId)).orderByDesc((Object)"SORT"), false));
        String newId = UUID.randomUUID().toString().replace("-", "");
        DicType dict = new DicType();
        dict.setId(newId);
        dict.setParentId(parentId);
        dict.setTypeName(dictTypeCode);
        dict.setTypeDescription(dictName);
        dict.setRangeType(parentId);
        if (ToolUtil.isEmpty((Object)((Object)lastOne))) {
            dict.setSort(1);
        } else {
            dict.setSort(lastOne.getSort() + 1);
        }
        this.setTimeAndEditor(dict, true);
        return this.dicTypeService.save((Object)dict) && this.addDictTypeChildren(dict.getId(), dictValues);
    }

    private boolean addDictTypeChildren(String typeId, String dictValues) {
        if (ToolUtil.isNotEmpty((Object)dictValues)) {
            JSONArray jsonArray = JSON.parseArray((String)dictValues);
            ArrayList<DicSingle> addList = new ArrayList<DicSingle>();
            for (int i = 0; i < jsonArray.size(); ++i) {
                Map map = (Map)JSON.parse((String)jsonArray.getString(i));
                String value = (String)map.get("num");
                String label = (String)map.get("name");
                if (ToolUtil.isOneEmpty((Object[])new Object[]{value, label})) continue;
                DicSingle itemDict = new DicSingle();
                itemDict.setValue(value);
                itemDict.setLabel(label);
                itemDict.setTypeId(typeId);
                itemDict.setSort(i + 1);
                this.setTimeAndEditor(itemDict, true);
                addList.add(itemDict);
            }
            if (ToolUtil.isNotEmpty(addList)) {
                return this.dicSingleService.saveBatch(addList);
            }
        }
        return false;
    }

    @Override
    public void editDict(String dictTypeId, String dictName, String dictTypeCode, String dictValues) {
        this.hussarCacheManager.deleteMore("hussar_dict_of_type_cache", "dict_of_type:");
        this.checkDicTypeRange(dictTypeId);
        this.checkDicTypeDuplicated(dictTypeId, dictName, dictTypeCode);
        DicSingle finder = new DicSingle();
        finder.setTypeId(dictTypeId);
        this.dicSingleService.remove((Wrapper)new QueryWrapper((Object)finder));
        this.addDictTypeChildren(dictTypeId, dictValues);
        DicType type = (DicType)((Object)this.dicTypeService.getById((Serializable)((Object)dictTypeId)));
        type.setTypeName(dictTypeCode);
        type.setTypeDescription(dictName);
        this.dicTypeService.updateById((Object)type);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void editDictNew(String info, String dictValues, String delIdString) {
        this.hussarCacheManager.deleteMore("hussar_dict_of_type_cache", "dict_of_type:");
        Map mapOfType = (Map)JSON.parse((String)info);
        String dictId = (String)mapOfType.get("dictId");
        String dictName = (String)mapOfType.get("dictName");
        String dictTypeCode = (String)mapOfType.get("dictTypeCode");
        String flag = (String)mapOfType.get("flag");
        List list = (List)JSON.parse((String)delIdString);
        if (ToolUtil.isNotEmpty((Object)list)) {
            this.dicSingleService.removeByIds(list);
        }
        if (this.flagOfExecuteType.equals(flag)) {
            this.checkDicTypeDuplicated(dictId, dictName, dictTypeCode);
            DicType dicType = new DicType();
            dicType.setTypeName(dictTypeCode);
            dicType.setTypeDescription(dictName);
            this.setTimeAndEditor(dicType, false);
            this.dicTypeService.update((Object)dicType, (Wrapper)new QueryWrapper().eq((Object)"ID", (Object)dictId));
        } else {
            DicSingle dicSingle = new DicSingle();
            dicSingle.setValue(dictTypeCode);
            dicSingle.setLabel(dictName);
            this.setTimeAndEditor(dicSingle, false);
            DicSingle single = (DicSingle)((Object)this.dicSingleService.getOne((Wrapper)new QueryWrapper().eq((Object)"ID", (Object)dictId), false));
            String typeId = single.getTypeId();
            this.checkDicSingleDuplicated(dictId, typeId, dictName, dictTypeCode);
            this.dicSingleService.update((Object)dicSingle, (Wrapper)new QueryWrapper().eq((Object)"ID", (Object)dictId));
        }
        JSONArray jsonArray = JSON.parseArray((String)dictValues);
        ArrayList<DicSingle> addList = new ArrayList<DicSingle>();
        ArrayList<DicSingle> updateList = new ArrayList<DicSingle>();
        if (ToolUtil.isNotEmpty((Object)jsonArray)) {
            int arr = 1;
            DicSingle lastOne = new DicSingle();
            lastOne = this.flagOfExecuteType.equals(flag) ? (DicSingle)((Object)this.dicSingleService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"TYPE_ID", (Object)dictId)).orderByDesc((Object)"SORT"), false)) : (DicSingle)((Object)this.dicSingleService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PARENT_ID", (Object)dictId)).orderByDesc((Object)"SORT"), false));
            if (ToolUtil.isNotEmpty((Object)((Object)lastOne))) {
                arr = lastOne.getSort() + 1;
            }
            for (int i = 0; i < jsonArray.size(); ++i) {
                Map map = (Map)JSON.parse((String)jsonArray.getString(i));
                DicSingle dicSingle = new DicSingle();
                dicSingle.setValue((String)map.get("num"));
                dicSingle.setLabel((String)map.get("name"));
                dicSingle.setTypeId(dictId);
                if (!this.flagOfExecuteType.equals(flag)) {
                    dicSingle.setParentId(dictId);
                }
                if (ToolUtil.isEmpty(map.get("id"))) {
                    this.setTimeAndEditor(dicSingle, true);
                    dicSingle.setSort(arr++);
                } else {
                    this.setTimeAndEditor(dicSingle, false);
                }
                if (ToolUtil.isEmpty(map.get("id"))) {
                    addList.add(dicSingle);
                    continue;
                }
                dicSingle.setId((String)map.get("id"));
                updateList.add(dicSingle);
            }
            if (ToolUtil.isNotEmpty(addList)) {
                this.dicSingleService.saveBatch(addList);
            }
            if (ToolUtil.isNotEmpty(updateList)) {
                this.dicSingleService.updateBatchById(updateList);
            }
        }
    }

    @Override
    public List<Map<String, Object>> dicTypeTreeData() {
        List dicChilds;
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        List types = this.dicTypeService.list((Wrapper)new QueryWrapper().orderByAsc((Object)"SORT"));
        if (types != null && types.size() > 0) {
            for (DicType type : types) {
                String rangeType = type.getRangeType();
                String typeName = type.getTypeName();
                HashMap<String, String> tempObject = new HashMap<String, String>(10);
                tempObject.put("id", type.getId());
                tempObject.put("parent", type.getParentId());
                tempObject.put("text", type.getTypeDescription());
                tempObject.put("type", "type");
                tempObject.put("rangeType", rangeType);
                tempObject.put("typeName", typeName);
                mapList.add(tempObject);
                List dics = this.dicSingleService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"TYPE_ID", (Object)type.getId())).orderByAsc((Object)"SORT"));
                if (dics == null || dics.size() <= 0) continue;
                for (DicSingle dic : dics) {
                    tempObject = new HashMap(10);
                    tempObject.put("id", dic.getId());
                    tempObject.put("parent", dic.getTypeId());
                    tempObject.put("text", dic.getLabel());
                    tempObject.put("type", "dic");
                    tempObject.put("rangeType", rangeType);
                    tempObject.put("typeName", typeName);
                    mapList.add(tempObject);
                }
            }
        }
        if ((dicChilds = this.dicSingleService.list((Wrapper)((QueryWrapper)new QueryWrapper().isNotNull((Object)"PARENT_ID")).orderByAsc((Object)"SORT"))) != null && dicChilds.size() > 0) {
            for (DicSingle dicChild : dicChilds) {
                HashMap<String, String> tempObject = new HashMap<String, String>(10);
                tempObject = new HashMap(10);
                tempObject.put("id", dicChild.getId());
                tempObject.put("parent", dicChild.getParentId());
                tempObject.put("text", dicChild.getLabel());
                tempObject.put("type", "dic");
                tempObject.put("rangeType", "child");
                tempObject.put("typeName", "child");
                mapList.add(tempObject);
            }
        }
        return mapList;
    }

    @Override
    public List<Map<String, Object>> dicOrderTreeData(String typeId) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>();
        DicType pDic = (DicType)((Object)this.dicTypeService.getById((Serializable)((Object)typeId)));
        if (pDic != null) {
            HashMap<String, String> parent = new HashMap<String, String>(10);
            parent.put("id", pDic.getId());
            parent.put("parent", "#");
            parent.put("text", pDic.getTypeDescription());
            parent.put("type", "type");
            mapList.add(parent);
            DicSingle finder = new DicSingle();
            finder.setTypeId(typeId);
            List subDict = this.dicSingleService.list((Wrapper)new QueryWrapper((Object)finder).orderByAsc((Object)"SORT"));
            if (subDict != null && subDict.size() > 0) {
                for (DicSingle dic : subDict) {
                    HashMap<String, String> tempObject = new HashMap<String, String>(10);
                    tempObject.put("id", dic.getId());
                    tempObject.put("parent", dic.getTypeId());
                    tempObject.put("text", dic.getLabel());
                    tempObject.put("type", "dic");
                    mapList.add(tempObject);
                }
            }
        }
        return mapList;
    }

    @Override
    public boolean saveDicOrder(String orderInfo) {
        JSONArray arr = JSON.parseArray((String)orderInfo);
        String[] orderInfoArr = (String[])arr.toArray((Object[])new String[arr.size()]);
        DicSingle dic = null;
        ArrayList<DicSingle> listOfSingle = new ArrayList<DicSingle>();
        for (int i = 0; i < orderInfoArr.length; ++i) {
            String id = orderInfoArr[i];
            dic = (DicSingle)((Object)this.dicSingleService.getById((Serializable)((Object)id)));
            dic.setSort(i + 1);
            this.setTimeAndEditor(dic, false);
            listOfSingle.add(dic);
        }
        if (ToolUtil.isNotEmpty(dic)) {
            this.dicTypeService.evictTypeCacheById(dic.getTypeId());
        }
        return ToolUtil.isNotEmpty(listOfSingle) && this.dicSingleService.updateBatchById(listOfSingle);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateMoveNode(String dictId, boolean isUp) {
        DicSingle thisDic = (DicSingle)((Object)this.dicSingleService.getById((Serializable)((Object)dictId)));
        QueryWrapper ew = (QueryWrapper)new QueryWrapper().eq((Object)"TYPE_ID", (Object)thisDic.getTypeId());
        if (isUp) {
            ((QueryWrapper)ew.lt((Object)"SORT", (Object)thisDic.getSort())).orderByDesc((Object)"SORT");
        } else {
            ((QueryWrapper)ew.gt((Object)"SORT", (Object)thisDic.getSort())).orderByAsc((Object)"SORT");
        }
        DicSingle thatDic = (DicSingle)((Object)this.dicSingleService.getOne((Wrapper)ew, false));
        if (thatDic == null) {
            HussarException e = new HussarException((ServiceExceptionEnum)BizExceptionEnum.DB_RESOURCE_NULL);
            e.setMessage("\u6b64\u6761\u76ee\u5df2\u7ecf\u4e3a" + (isUp ? "\u7b2c\u4e00\u6761\uff01" : "\u6700\u540e\u4e00\u6761\uff01"));
            throw e;
        }
        int temp = thisDic.getSort();
        thisDic.setSort(thatDic.getSort());
        this.setTimeAndEditor(thisDic, false);
        thatDic.setSort(temp);
        this.setTimeAndEditor(thatDic, false);
        if (!this.dicSingleService.updateById((Object)thisDic) || !this.dicSingleService.updateById((Object)thatDic)) {
            HussarException e = new HussarException((ServiceExceptionEnum)BizExceptionEnum.ERROR_WRAPPER_FIELD);
            e.setMessage("\u4fdd\u5b58\u5b57\u5178\u987a\u5e8f\u5931\u8d25\uff01");
            throw e;
        }
        this.dicTypeService.evictTypeCacheById(thisDic.getTypeId());
    }

    @Override
    public boolean saveOrUpdateSingle(String dictId, String dictTypeId, String dictName, String dictValue) {
        DicSingle dic;
        this.hussarCacheManager.deleteMore("hussar_dict_of_type_cache", "dict_of_type:");
        this.checkDicTypeRange(dictTypeId);
        this.checkDicSingleDuplicated(dictId, dictTypeId, dictName, dictValue);
        if (ToolUtil.isEmpty((Object)dictId)) {
            DicSingle lastOne = (DicSingle)((Object)this.dicSingleService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"TYPE_ID", (Object)dictTypeId)).orderByDesc((Object)"SORT"), false));
            dic = new DicSingle();
            dic.setTypeId(dictTypeId);
            dic.setLabel(dictName);
            dic.setValue(dictValue);
            this.setTimeAndEditor(dic, true);
            if (ToolUtil.isEmpty((Object)((Object)lastOne))) {
                dic.setSort(1);
            } else {
                dic.setSort(lastOne.getSort() + 1);
            }
        } else {
            dic = (DicSingle)((Object)this.dicSingleService.getById((Serializable)((Object)dictId)));
            dic.setLabel(dictName);
            dic.setValue(dictValue);
            this.setTimeAndEditor(dic, false);
        }
        boolean flag = this.dicSingleService.saveOrUpdate((Object)dic);
        if (flag) {
            this.dicTypeService.evictTypeCacheById(dic.getTypeId());
        }
        return flag;
    }

    @Override
    public void deleteType(String id) {
        this.hussarCacheManager.deleteMore("hussar_dict_of_type_cache", "dict_of_type:");
        if (id != null && this.dicTypeService.list((Wrapper)new QueryWrapper().eq((Object)"ID", (Object)id)).size() > 0 && this.dicTypeService.removeById((Serializable)((Object)id))) {
            this.dicTypeService.evictTypeCacheById(id);
        }
        if (id != null && this.dicSingleService.list((Wrapper)new QueryWrapper().eq((Object)"ID", (Object)id)).size() > 0) {
            this.dicSingleService.removeById((Serializable)((Object)id));
        }
    }

    @Override
    public boolean deleteCascadeDict(String[] ids) {
        this.hussarCacheManager.deleteMore("hussar_dict_of_type_cache", "dict_of_type:");
        ArrayList<String> listOfGroup = new ArrayList<String>();
        ArrayList<String> listOfType = new ArrayList<String>();
        ArrayList<String> listOfSingle = new ArrayList<String>();
        for (String id : ids) {
            DicGroup dicGroup = (DicGroup)((Object)this.dicGroupService.getOne((Wrapper)new QueryWrapper().eq((Object)"ID", (Object)id), false));
            DicType dicType = (DicType)((Object)this.dicTypeService.getOne((Wrapper)new QueryWrapper().eq((Object)"ID", (Object)id), false));
            DicSingle dicSingle = (DicSingle)((Object)this.dicSingleService.getOne((Wrapper)new QueryWrapper().eq((Object)"ID", (Object)id), false));
            if (id != null && dicGroup != null) {
                listOfGroup.add(id);
            }
            if (id != null && dicType != null) {
                listOfType.add(id);
                this.dicTypeService.evictTypeCacheById(id);
            }
            if (id == null || dicSingle == null) continue;
            listOfSingle.add(id);
        }
        if (ToolUtil.isNotEmpty(listOfGroup)) {
            this.dicGroupService.removeByIds(listOfGroup);
        }
        if (ToolUtil.isNotEmpty(listOfType)) {
            this.dicTypeService.removeByIds(listOfType);
        }
        if (ToolUtil.isNotEmpty(listOfSingle)) {
            this.dicSingleService.removeByIds(listOfSingle);
        }
        return true;
    }

    @Override
    public boolean saveSingleChild(String dictId, String dictTypeId, String dictName, String dictValue) {
        DicSingle dicSingle;
        this.hussarCacheManager.deleteMore("hussar_dict_of_type_cache", "dict_of_type:");
        this.checkDicSingleDuplicated(dictId, dictTypeId, dictName, dictValue);
        if (ToolUtil.isEmpty((Object)dictId)) {
            DicSingle lastOne = (DicSingle)((Object)this.dicSingleService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PARENT_ID", (Object)dictTypeId)).orderByDesc((Object)"SORT"), false));
            dicSingle = new DicSingle();
            dicSingle.setTypeId(dictTypeId);
            dicSingle.setParentId(dictTypeId);
            dicSingle.setLabel(dictName);
            dicSingle.setValue(dictValue);
            this.setTimeAndEditor(dicSingle, true);
            if (ToolUtil.isEmpty((Object)((Object)lastOne))) {
                dicSingle.setSort(1);
            } else {
                dicSingle.setSort(lastOne.getSort() + 1);
            }
        } else {
            dicSingle = (DicSingle)((Object)this.dicSingleService.getById((Serializable)((Object)dictId)));
            dicSingle.setLabel(dictName);
            dicSingle.setValue(dictValue);
            this.setTimeAndEditor(dicSingle, false);
        }
        boolean flag = this.dicSingleService.saveOrUpdate((Object)dicSingle);
        if (flag) {
            this.dicTypeService.evictTypeCacheById(dicSingle.getTypeId());
        }
        return flag;
    }

    private void checkDicTypeRange(String typeId) {
        DicType parent = (DicType)((Object)this.dicTypeService.getById((Serializable)((Object)typeId)));
        if (!ToolUtil.isNotEmpty((Object)((Object)parent))) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.NO_PERMITION);
        }
        this.checkRangeType(parent.getRangeType());
    }

    private void checkRangeType(String rangeType) {
        if (this.pseudoRootSys.equals(rangeType)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.NO_PERMITION);
        }
    }

    private void checkDicTypeDuplicated(String id, String dictName, String dictTypeCode) {
        HussarException e = new HussarException((ServiceExceptionEnum)BizExceptionEnum.DICT_EXISTED);
        Wrapper finderCode = (Wrapper)new QueryWrapper().eq((Object)"TYPE_NAME", (Object)dictTypeCode);
        List resCode = this.dicTypeService.list(finderCode);
        e.setMessage("\u8be5\u5b57\u5178\u7c7b\u578b\u5df2\u5b58\u5728");
        if (resCode.size() > 1) {
            throw e;
        }
        if (resCode.size() == 1 && !((DicType)((Object)resCode.get(0))).getId().equals(id)) {
            throw e;
        }
        Wrapper finderDescription = (Wrapper)new QueryWrapper().eq((Object)"TYPE_DESCRIPTION", (Object)dictName);
        List resDescription = this.dicTypeService.list(finderDescription);
        e.setMessage("\u8be5\u7c7b\u578b\u63cf\u8ff0\u5df2\u5b58\u5728");
        if (resDescription.size() > 1) {
            throw e;
        }
        if (resDescription.size() == 1 && !((DicType)((Object)resDescription.get(0))).getId().equals(id)) {
            throw e;
        }
    }

    private void checkDicSingleDuplicated(String dictId, String dictTypeId, String dictName, String dictValue) {
        HussarException e = new HussarException((ServiceExceptionEnum)BizExceptionEnum.DICT_EXISTED);
        Wrapper finderL = (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"TYPE_ID", (Object)dictTypeId)).eq((Object)"LABEL", (Object)dictName);
        List resL = this.dicSingleService.list(finderL);
        e.setMessage("\u5b57\u6bb5\u540d\u79f0\u5df2\u5b58\u5728");
        if (resL.size() > 1) {
            throw e;
        }
        if (resL.size() == 1 && !((DicSingle)((Object)resL.get(0))).getId().equals(dictId)) {
            throw e;
        }
        Wrapper finderV = (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"TYPE_ID", (Object)dictTypeId)).eq((Object)"VALUE", (Object)dictValue);
        List resV = this.dicSingleService.list(finderV);
        e.setMessage("\u5b57\u6bb5\u503c\u5df2\u5b58\u5728");
        if (resV.size() > 1) {
            throw e;
        }
        if (resV.size() == 1 && !((DicSingle)((Object)resV.get(0))).getId().equals(dictId)) {
            throw e;
        }
    }

    private void checkDicGroupDuplicated(String groupParentId, String groupName) {
        HussarException e = new HussarException((ServiceExceptionEnum)BizExceptionEnum.DICT_EXISTED);
        Wrapper finderL = (Wrapper)new QueryWrapper().eq((Object)"group_description", (Object)groupName);
        List resL = this.dicGroupService.list(finderL);
        e.setMessage("\u8be5\u5b57\u5178\u540d\u79f0\u5df2\u5b58\u5728");
        if (resL.size() > 1) {
            throw e;
        }
        if (resL.size() == 1 && !((DicGroup)((Object)resL.get(0))).getId().equals(groupParentId)) {
            throw e;
        }
    }

    private void setTimeAndEditor(DicGroup dicGroup, boolean isCreate) {
        Date now = new Date();
        ShiroUser editor = ShiroKit.getUser();
        if (isCreate) {
            dicGroup.setCreateTime(now);
        }
        dicGroup.setLastTime(now);
        if (ToolUtil.isNotEmpty((Object)editor)) {
            if (isCreate) {
                dicGroup.setCreator(editor.getId());
            }
            dicGroup.setLastEditor(editor.getId());
        }
    }

    private void setTimeAndEditor(DicType dicType, boolean isCreate) {
        Date now = new Date();
        ShiroUser editor = ShiroKit.getUser();
        if (isCreate) {
            dicType.setCreateTime(now);
        }
        dicType.setLastTime(now);
        if (ToolUtil.isNotEmpty((Object)editor)) {
            if (isCreate) {
                dicType.setCreator(editor.getId());
            }
            dicType.setLastEditor(editor.getId());
        }
    }

    private void setTimeAndEditor(DicSingle dicSingle, boolean isCreate) {
        Date now = new Date();
        ShiroUser editor = ShiroKit.getUser();
        if (isCreate) {
            dicSingle.setCreateTime(now);
        }
        dicSingle.setLastTime(now);
        if (ToolUtil.isNotEmpty((Object)editor)) {
            if (isCreate) {
                dicSingle.setCreator(editor.getId());
            }
            dicSingle.setLastEditor(editor.getId());
        }
    }
}

