/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.sys.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.core.sys.model.DicSingle;
import com.jxdinfo.hussar.core.sys.model.DicType;
import com.jxdinfo.hussar.core.sys.service.ISysDicRefService;
import com.jxdinfo.hussar.core.sys.service.ISysDicSingleService;
import com.jxdinfo.hussar.core.sys.service.ISysDicTypeService;
import com.jxdinfo.hussar.core.sys.vo.DicVo;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class SysDicRefServiceImpl
implements ISysDicRefService {
    @Autowired
    private ISysDicSingleService dicSingleService;
    @Autowired
    private ISysDicTypeService dicTypeService;

    @Override
    @Cacheable(value={"hussar_dict_of_type_cache"}, key="'dict_of_type:'+#typeName+':list'")
    public List<DicSingle> getDictByType(String typeName) {
        List<DicSingle> result = new ArrayList<DicSingle>();
        DicType type = this.getTypeInfo(typeName);
        if (ToolUtil.isNotEmpty((Object)((Object)type))) {
            Wrapper wp = (Wrapper)new QueryWrapper().eq((Object)"type_id", (Object)type.getId());
            result = this.dicSingleService.list(wp);
        }
        return result;
    }

    @Override
    @Cacheable(value={"hussar_dict_of_type_cache"}, key="'dict_of_type:'+#typeName+':map'")
    public LinkedHashMap<String, Object> getDictMapByType(String typeName) {
        LinkedHashMap<String, Object> linkedHashMap = new LinkedHashMap<String, Object>();
        List<DicSingle> list = this.getDictByType(typeName);
        for (DicSingle dicSingle : list) {
            linkedHashMap.put(dicSingle.getValue(), dicSingle.getLabel());
        }
        return linkedHashMap;
    }

    @Override
    @Cacheable(value={"hussar_dict_of_type_cache"}, key="'dict_of_type:'+#typeName+':allShow'")
    public List<DicVo> getDicListByType(String typeName) {
        List<DicVo> result = new ArrayList<DicVo>();
        DicType type = this.getTypeInfo(typeName);
        if (ToolUtil.isNotEmpty((Object)((Object)type))) {
            result = this.dicSingleService.getDicListByType(type.getId());
        }
        return result;
    }

    @Override
    @Cacheable(value={"hussar_dict_of_type_cache"}, key="'dict_of_type:'+#typeName+':onlyShow'")
    public List<DicVo> getCertainDictOptions(String typeName, String[] optionValues) {
        List<DicVo> result = new ArrayList<DicVo>();
        DicType type = this.getTypeInfo(typeName);
        if (ToolUtil.isNotEmpty((Object)((Object)type))) {
            result = this.dicSingleService.getCertainDictOptions(type.getId(), optionValues);
        }
        return result;
    }

    @Override
    @Cacheable(value={"hussar_dict_of_type_cache"}, key="'dict_of_type:'+#typeName+':notShow'")
    public List<DicVo> getDictOptionsWithoutNotShows(String typeName, String[] notShows) {
        List<DicVo> result = new ArrayList<DicVo>();
        DicType type = this.getTypeInfo(typeName);
        if (ToolUtil.isNotEmpty((Object)((Object)type))) {
            result = this.dicSingleService.getDictOptionsWithoutNotShows(type.getId(), notShows);
        }
        return result;
    }

    @Override
    public String getDictLabel(String typeName, String value) {
        String result = "";
        DicType type = this.getTypeInfo(typeName);
        if (!ToolUtil.isOneEmpty((Object[])new Object[]{type, value})) {
            result = this.dicSingleService.getDictLabel(type.getId(), value);
        }
        return result;
    }

    @Override
    public String getDictValue(String typeName, String label) {
        String result = "";
        DicType type = this.getTypeInfo(typeName);
        if (ToolUtil.isNotEmpty((Object)((Object)type))) {
            result = this.dicSingleService.getDictValue(type.getId(), label);
        }
        return result;
    }

    @Override
    public String getDictOptionsInJson(String typeName) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        List<DicSingle> list = this.getDictByType(typeName);
        for (DicSingle dicSingle : list) {
            linkedHashMap.put(dicSingle.getLabel(), dicSingle.getValue());
        }
        return JSON.toJSONString(linkedHashMap);
    }

    private DicType getTypeInfo(String typeName) {
        return (DicType)((Object)this.dicTypeService.getOne((Wrapper)new QueryWrapper().eq((Object)"type_name", (Object)typeName), false));
    }
}

