/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.sys.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.common.dicutil.DictionaryUtil;
import com.jxdinfo.hussar.common.exception.BizExceptionEnum;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.exception.HussarException;
import com.jxdinfo.hussar.core.exception.ServiceExceptionEnum;
import com.jxdinfo.hussar.core.sys.model.DicSingle;
import com.jxdinfo.hussar.core.sys.model.DicType;
import com.jxdinfo.hussar.core.sys.service.ISysDicService;
import com.jxdinfo.hussar.core.sys.service.ISysDicSingleService;
import com.jxdinfo.hussar.core.sys.service.ISysDicTypeService;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"sys/dic"})
public class SysDicController
extends BaseController {
    private String prefix = "/core/sys/dict/";
    private String flagOfEdit = "haveType";
    private String flagOfAdd = "0";
    @Autowired
    private ISysDicService dictService;
    @Autowired
    private ISysDicSingleService dicSingleService;
    @Autowired
    private ISysDicTypeService dicTypeService;
    @Autowired
    private HussarCacheManager hussarCacheManager;
    @Autowired
    private DictionaryUtil dictionaryUtil;

    @RequestMapping(value={""})
    @BussinessLog(key="/sys/dic/", type="04", value="\u5b57\u5178\u7ba1\u7406\u9875\u9762")
    @RequiresPermissions(value={"dict:dic"})
    public String index() {
        return this.prefix + "dict.html";
    }

    @RequestMapping(value={"/dict_add/{parentId}"})
    @RequiresPermissions(value={"dict:add"})
    public String openDictTypeAdd(@PathVariable String parentId, Model model) {
        model.addAttribute("parentId", (Object)parentId);
        return this.prefix + "dict_add.html";
    }

    @RequestMapping(value={"/dict_add_single/{dictTypeId}/{flag}"})
    @RequiresPermissions(value={"dict:add"})
    public String openSingleAdd(@PathVariable(value="dictTypeId") String dictTypeId, @PathVariable(value="flag") String flag, Model model) {
        model.addAttribute("dictTypeId", (Object)dictTypeId);
        model.addAttribute("flag", (Object)flag);
        return this.prefix + "dict_single.html";
    }

    @RequestMapping(value={"/dict_edit/{dictTypeId}/{str}"})
    @RequiresPermissions(value={"dict:edit"})
    public String openDictTypeUpdate(@PathVariable String dictTypeId, @PathVariable String str, Model model) {
        DicSingle finder = new DicSingle();
        List subDicts = null;
        if (this.flagOfEdit.equals(str)) {
            finder.setTypeId(dictTypeId);
            model.addAttribute("dict", this.dicTypeService.getById((Serializable)((Object)dictTypeId)));
            subDicts = this.dicSingleService.list((Wrapper)new QueryWrapper((Object)finder).orderByAsc((Object)"SORT"));
        } else {
            finder.setParentId(dictTypeId);
            model.addAttribute("dict", this.dicSingleService.getById((Serializable)((Object)dictTypeId)));
            subDicts = this.dicSingleService.list((Wrapper)new QueryWrapper((Object)finder).orderByAsc((Object)"SORT"));
        }
        model.addAttribute("str", (Object)str);
        model.addAttribute("subDicts", (Object)subDicts);
        return this.prefix + "dict_edit.html";
    }

    @RequestMapping(value={"/dict_edit_single/{dictId}"})
    @RequiresPermissions(value={"dict:edit"})
    public String openSingleUpdate(@PathVariable String dictId, Model model) {
        DicSingle dict = (DicSingle)((Object)this.dicSingleService.getById((Serializable)((Object)dictId)));
        model.addAttribute("dictId", (Object)dictId);
        model.addAttribute("dictTypeId", (Object)dict.getTypeId());
        model.addAttribute("dictName", (Object)dict.getLabel());
        model.addAttribute("dictValue", (Object)dict.getValue());
        return this.prefix + "dict_single.html";
    }

    @RequestMapping(value={"/add"})
    @RequiresPermissions(value={"dict:add"})
    @ResponseBody
    @BussinessLog(key="/sys/dic/add", type="01", value="\u5b57\u5178\u7c7b\u522b\u65b0\u589e")
    public Tip add(String parentId, String dictName, String dictTypeCode, String dictValues) {
        if (ToolUtil.isOneEmpty((Object[])new Object[]{parentId, dictName, dictTypeCode})) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        this.dictService.addDictType(parentId, dictName, dictTypeCode, dictValues);
        return SUCCESS_TIP;
    }

    @RequestMapping(value={"/add_single"})
    @RequiresPermissions(value={"dict:add_single"})
    @ResponseBody
    @BussinessLog(key="/sys/dic/add_single", type="01", value="\u5b57\u5178\u5b57\u6bb5\u6dfb\u52a0")
    public Tip addSingle(String dictId, String dictTypeId, String dictName, String dictValue, String flag) {
        this.hussarCacheManager.deleteMore("hussar_dict_of_type_cache", "dict_of_type:");
        if (ToolUtil.isOneEmpty((Object[])new Object[]{dictTypeId, dictName, dictValue})) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        if (this.flagOfAdd.equals(flag) ? this.dictService.saveOrUpdateSingle(dictId, dictTypeId, dictName, dictValue) : this.dictService.saveSingleChild(dictId, dictTypeId, dictName, dictValue)) {
            return SUCCESS_TIP;
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u65b0\u589e\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/update_single"})
    @RequiresPermissions(value={"dict:update_single"})
    @ResponseBody
    @BussinessLog(key="/sys/dic/update_single", type="03", value="\u5b57\u5178\u5b57\u6bb5\u4fee\u6539")
    public Tip editSingle(String dictId, String dictTypeId, String dictName, String dictValue, String flag) {
        if (ToolUtil.isEmpty((Object)dictId)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        if (this.dictService.saveOrUpdateSingle(dictId, dictTypeId, dictName, dictValue)) {
            return SUCCESS_TIP;
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u4fee\u6539\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/list/{rangeType}"})
    @ResponseBody
    public Object list(@PathVariable(value="rangeType") String rangeType, String condition, @RequestParam(value="page", defaultValue="1") int pageNo, @RequestParam(value="limit", defaultValue="20") int limit) {
        String rootRange = "root";
        Page page = new Page((long)pageNo, (long)limit);
        QueryWrapper ew = new QueryWrapper();
        HashMap<String, Serializable> result = new HashMap<String, Serializable>(5);
        if (ToolUtil.isNotEmpty((Object)condition)) {
            ew.like((Object)"TYPE_DESCRIPTION", (Object)condition);
        }
        if (ToolUtil.isNotEmpty((Object)rangeType) && !rootRange.equals(rangeType)) {
            ew.eq((Object)"RANGE_TYPE", (Object)rangeType);
        }
        ew.orderByAsc((Object)"SORT");
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        List list2 = ((Page)this.dicTypeService.page((IPage)page, (Wrapper)ew)).getRecords();
        for (DicType dt : list2) {
            this.warpTheObjectToMap(dt, list);
        }
        result.put("code", Integer.valueOf(0));
        result.put("count", Long.valueOf(page.getTotal()));
        result.put("data", list);
        return result;
    }

    private void warpTheObjectToMap(DicType dt, List<Map<String, Object>> list) {
        StringBuilder detail = new StringBuilder();
        String typeId = dt.getId();
        HashMap<String, String> map = new HashMap<String, String>(5);
        map.put("id", typeId);
        map.put("parentId", dt.getParentId());
        map.put("typeName", dt.getTypeName());
        map.put("typeDescription", dt.getTypeDescription());
        map.put("rangeType", dt.getRangeType());
        List dicts = this.dicSingleService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"TYPE_ID", (Object)typeId)).orderByAsc((Object)"SORT"));
        if (dicts != null) {
            for (DicSingle dict : dicts) {
                detail.append(dict.getValue()).append(":").append(dict.getLabel()).append(", ");
            }
            map.put("detail", ToolUtil.removeSuffix((String)detail.toString(), (String)", "));
        }
        list.add(map);
    }

    @RequestMapping(value={"/list_single/{dictTypeId}"})
    @ResponseBody
    public Object listSingle(@PathVariable(value="dictTypeId") String dictTypeId, String condition, @RequestParam(value="page", defaultValue="1") int pageNo, @RequestParam(value="limit", defaultValue="20") int limit) {
        if (ToolUtil.isEmpty((Object)dictTypeId)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        Page page = new Page((long)pageNo, (long)limit);
        QueryWrapper ew = (QueryWrapper)new QueryWrapper().eq((Object)"TYPE_ID", (Object)dictTypeId);
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        if (ToolUtil.isNotEmpty((Object)condition)) {
            ew.like((Object)"LABEL", (Object)condition);
        }
        ew.orderByAsc((Object)"SORT");
        List list = ((Page)this.dicSingleService.page((IPage)page, (Wrapper)ew)).getRecords();
        result.put("code", 0);
        result.put("count", page.getTotal());
        result.put("data", list);
        return result;
    }

    @RequestMapping(value={"/detail/{dictId}"})
    @ResponseBody
    public Object openSingleDetail(@PathVariable(value="dictId") String dictId) {
        return this.dicSingleService.getById((Serializable)((Object)dictId));
    }

    @RequestMapping(value={"/update"})
    @RequiresPermissions(value={"dict:edit"})
    @ResponseBody
    @BussinessLog(key="/sys/dic/update", type="03", value="\u5b57\u5178\u7c7b\u522b\u4fee\u6539")
    public Tip update(String info, String dictValues, String delIdString) {
        Map map = (Map)JSON.parse((String)info);
        if (ToolUtil.isOneEmpty((Object[])new Object[]{map.get("dictId"), map.get("dictName"), map.get("dictTypeCode")})) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        this.dictService.editDictNew(info, dictValues, delIdString);
        return SUCCESS_TIP;
    }

    @RequestMapping(value={"/delete"})
    @RequiresPermissions(value={"dict:delete"})
    @ResponseBody
    @BussinessLog(key="/sys/dic/delete", type="02", value="\u5b57\u5178\u7c7b\u522b\u5220\u9664")
    public Tip delete(@RequestParam String dictId) {
        this.hussarCacheManager.deleteMore("hussar_dict_of_type_cache", "dict_of_type:");
        String[] strArr = dictId.split(",");
        this.dictService.deleteCascadeDict(strArr);
        return SUCCESS_TIP;
    }

    @RequestMapping(value={"/delete_single"})
    @RequiresPermissions(value={"dict:delete_single"})
    @ResponseBody
    @BussinessLog(key="/sys/dic/delete_single", type="02", value="\u5b57\u5178\u5b57\u6bb5\u5220\u9664")
    public Tip deleteSingle(@RequestParam String dictId) {
        this.hussarCacheManager.deleteMore("hussar_dict_of_type_cache", "dict_of_type:");
        String[] strarr = dictId.split(",");
        List<String> list = Arrays.asList(strarr);
        if (this.dicSingleService.removeByIds(list)) {
            return SUCCESS_TIP;
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u5220\u9664\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/dicTypeTree"})
    @ResponseBody
    public List<Map<String, Object>> dicTypeTreeData() {
        return this.dictService.dicTypeTreeData();
    }

    @RequestMapping(value={"/dicOrderTree"})
    @ResponseBody
    public List<Map<String, Object>> dicOrderTreeData(String typeId) {
        if (ToolUtil.isEmpty((Object)typeId)) {
            return new ArrayList<Map<String, Object>>();
        }
        return this.dictService.dicOrderTreeData(typeId);
    }

    @RequestMapping(value={"/saveDicOrder"})
    @RequiresPermissions(value={"dict:sort"})
    @ResponseBody
    @BussinessLog(key="/sys/dic/saveDicOrder", type="03", value="\u5b57\u5178\u4e0b\u7ea7\u6392\u5e8f")
    public Tip saveDicOrder(String orderInfo) {
        if (ToolUtil.isEmpty((Object)orderInfo)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        if (this.dictService.saveDicOrder(orderInfo)) {
            return SUCCESS_TIP;
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/singleMove"})
    @RequiresPermissions(value={"dict:sort"})
    @ResponseBody
    @BussinessLog(key="/sys/dic/singleMove", type="03", value="\u5b57\u5178\u4e0a\u79fb/\u4e0b\u79fb")
    public Tip updateMoveNode(String dictId, boolean isUp) {
        this.dicSingleService.evictTypeCacheBySingleId(dictId);
        if (ToolUtil.isEmpty((Object)dictId)) {
            throw new HussarException((ServiceExceptionEnum)BizExceptionEnum.REQUEST_NULL);
        }
        this.dictService.updateMoveNode(dictId, isUp);
        return BaseController.SUCCESS_TIP;
    }

    @RequestMapping(value={"/selectListByParentId"})
    @ResponseBody
    public Object selectListByParentId() {
        return this.dicTypeService.list((Wrapper)new QueryWrapper().orderByAsc((Object)"SORT"));
    }

    @RequestMapping(value={"/selectListByTypeName"})
    @ResponseBody
    public Object selectListByTypeName() {
        return this.dictionaryUtil.getDictByType(super.getPara("typeName"));
    }

    @RequestMapping(value={"/selectChildsById"})
    @ResponseBody
    public Object selectChildsById() {
        String id = super.getPara("id");
        List object = null;
        List list = this.dicTypeService.list((Wrapper)new QueryWrapper().eq(id != null, (Object)"ID", (Object)id));
        object = list.size() > 0 ? this.dicSingleService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"TYPE_ID", (Object)id)).orderByAsc((Object)"SORT")) : this.dicSingleService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"PARENT_ID", (Object)id)).orderByAsc((Object)"SORT"));
        return object;
    }

    @RequestMapping(value={"/dicExportTree"})
    @ResponseBody
    public List<JSTreeModel> dicExportTreeData() {
        return this.dicTypeService.dicExportTreeData();
    }

    @RequestMapping(value={"/exportDict"})
    @RequiresPermissions(value={"dict:exportDict"})
    @BussinessLog(key="/sys/dic/exportDict", type="03", value="\u5b57\u5178\u5bfc\u51fa")
    public void exportData(HttpServletResponse response) {
        String typeIds = super.getPara("typeIds");
        List<String> typeIdList = Arrays.asList(typeIds.split(","));
        this.dicTypeService.exportDict(typeIdList, response);
    }

    @RequestMapping(method={RequestMethod.POST}, path={"/importData"})
    @ResponseBody
    @RequiresPermissions(value={"dict:importData"})
    @BussinessLog(key="/sys/dic/importData", type="03", value="\u5b57\u5178\u5bfc\u5165")
    public Tip importData(@RequestParam(value="file") MultipartFile hussarFile) throws Exception {
        byte[] content = hussarFile.getBytes();
        return this.dicTypeService.importDict(content);
    }
}

