/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.shiro.sessionlimit;

import com.jxdinfo.hussar.core.redis.service.RedisService;
import com.jxdinfo.hussar.core.shiro.sessionlimit.SessionLimit;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import java.io.Serializable;
import java.util.Deque;
import java.util.LinkedList;
import org.springframework.context.annotation.DependsOn;

@DependsOn(value={"springContextHolder"})
public class RedisSessionLimit
implements SessionLimit {
    RedisService redisService = (RedisService)SpringContextHolder.getBean(RedisService.class);

    @Override
    public Deque<Serializable> getUserSession(String userId) {
        LinkedList deque = (LinkedList)this.redisService.getObject("same_user_sessions:" + userId);
        if (deque == null) {
            deque = new LinkedList();
        }
        return deque;
    }

    @Override
    public void addUserSession(String userId, Deque<Serializable> deque) {
        this.redisService.setObject("same_user_sessions:" + userId, deque);
    }
}

