/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.shiro.lock;

import com.jxdinfo.hussar.bsp.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.bsp.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.redis.service.RedisService;
import com.jxdinfo.hussar.core.shiro.lock.LoginLock;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.concurrent.TimeUnit;
import org.springframework.context.annotation.DependsOn;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;

@DependsOn(value={"springContextHolder"})
public class RedisLoginLock
implements LoginLock {
    private RedisService redisService = (RedisService)SpringContextHolder.getBean(RedisService.class);
    private GlobalProperties globalProperties = (GlobalProperties)SpringContextHolder.getBean(GlobalProperties.class);
    RedisTemplate<String, Object> redisTemplate = this.redisService.getRedisTemplate();
    ValueOperations<String, Object> opsForValue = this.redisTemplate.opsForValue();
    int tryLoginTime = this.globalProperties.getTryLoginTime();
    int lockTime = this.globalProperties.getLockTime();

    @Override
    public boolean userIsLock(String userid) {
        boolean flag = false;
        if ("LOCK".equals(this.opsForValue.get((Object)("shiro_is_lock:" + userid)))) {
            flag = true;
        }
        return flag;
    }

    @Override
    public int userLockNum(String userid) {
        long count = this.opsForValue.increment((Object)("shiro_login_count:" + userid), 0L);
        return (int)count;
    }

    @Override
    public boolean exisUser(String userid) {
        boolean flag = false;
        Object num = this.opsForValue.get((Object)("shiro_login_count:" + userid));
        if (ToolUtil.isNotEmpty((Object)num)) {
            flag = true;
        }
        return flag;
    }

    @Override
    public void addUserCache(String userid) {
        long count = this.opsForValue.increment((Object)("shiro_login_count:" + userid), 1L);
        if (count >= (long)this.tryLoginTime) {
            this.opsForValue.set((Object)("shiro_is_lock:" + userid), (Object)"LOCK");
            this.redisTemplate.expire((Object)("shiro_is_lock:" + userid), (long)this.lockTime, TimeUnit.HOURS);
        }
    }

    @Override
    public void removeUserCache(String userid) {
        this.redisTemplate.delete((Object)("shiro_login_count:" + userid));
    }

    @Override
    public void addUserCache(String userid, int tryLogin) {
        long count = this.opsForValue.increment((Object)("shiro_login_count:" + userid), 1L);
        if (count >= (long)tryLogin) {
            ISysBaseConfigService iSysBaseConfigService = (ISysBaseConfigService)SpringContextHolder.getBean(ISysBaseConfigService.class);
            SysBaseConfig sysBaseConfig = iSysBaseConfigService.getSysBaseConfig("fail_lock_time");
            String failLockTime = sysBaseConfig.getConfigValue();
            int failTime = Integer.parseInt(failLockTime);
            this.opsForValue.set((Object)("shiro_is_lock:" + userid), (Object)"LOCK");
            this.redisTemplate.expire((Object)("shiro_is_lock:" + userid), (long)failTime, TimeUnit.HOURS);
        }
    }
}

