/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.shiro.factory;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.bsp.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.bsp.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.bsp.constant.Constants;
import com.jxdinfo.hussar.bsp.permit.dao.SysResourcesMapper;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.bsp.permit.service.ISysUsersService;
import com.jxdinfo.hussar.bsp.sysuserip.service.ISysUserIpService;
import com.jxdinfo.hussar.common.constant.factory.ConstantFactory;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.common.exception.CancelException;
import com.jxdinfo.hussar.common.exception.DormancyException;
import com.jxdinfo.hussar.common.exception.HussarLockedAccountException;
import com.jxdinfo.hussar.common.exception.LoginIpRefuseException;
import com.jxdinfo.hussar.common.exception.LoginTimeRefuseException;
import com.jxdinfo.hussar.common.exception.TemporaryException;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.config.properties.HussarProperties;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.shiro.factory.IShiro;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.CredentialsException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@DependsOn(value={"springContextHolder"})
@Transactional(noRollbackFor={DormancyException.class, HussarLockedAccountException.class})
public class ShiroFactroy
implements IShiro {
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private SysResourcesMapper resourcesMapper;
    @Resource
    private ISysBaseConfigService iSysBaseConfigService;
    @Resource
    private HussarProperties hussarProperties;
    @Resource
    private GlobalProperties globalProperties;
    @Resource
    private ISysUserIpService iSysUserIpService;

    public static IShiro me() {
        return (IShiro)SpringContextHolder.getBean(IShiro.class);
    }

    @Override
    public SysUsers user(String account) {
        SysUsers user;
        if (!this.hussarProperties.getLoginUpperOpen().booleanValue()) {
            account = account.toUpperCase();
        }
        if (null == (user = (SysUsers)((Object)this.sysUsersService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"USER_ACCOUNT", (Object)account)).ne((Object)"ACCOUNT_STATUS", (Object)UserStatus.DELETE.getCode()), false)))) {
            throw new CredentialsException();
        }
        if (UserStatus.LOCKED.getCode().equals(user.getAccountStatus())) {
            throw new HussarLockedAccountException(user.getUserName(), "\u8d26\u53f7\u88ab\u9501\u5b9a");
        }
        if (UserStatus.CANCEL.getCode().equals(user.getAccountStatus())) {
            throw new CancelException(user.getUserName(), "\u8d26\u53f7\u88ab\u6ce8\u9500");
        }
        if (UserStatus.DORMANCY.getCode().equals(user.getAccountStatus())) {
            throw new DormancyException(user.getUserName(), "\u8d26\u53f7\u5df2\u4f11\u7720");
        }
        if (Arrays.asList(Constants.MANAGE_USER).contains(user.getUserAccount())) {
            return user;
        }
        if (user.getLastLoginTime() != null) {
            Date lastLoginDate = user.getLastLoginTime();
            SysBaseConfig noLogin = this.iSysBaseConfigService.getSysBaseConfig("nologin_day");
            SysBaseConfig userAccountStatus = this.iSysBaseConfigService.getSysBaseConfig("user_account_status");
            String days = noLogin.getConfigValue();
            String status = userAccountStatus.getConfigValue();
            Date date = DateUtil.addDay((Date)lastLoginDate, (int)Integer.parseInt(days));
            if (date.getTime() < System.currentTimeMillis()) {
                SysUsers sysUsers = new SysUsers();
                sysUsers.setUserId(user.getUserId());
                sysUsers.setAccountStatus(UserStatus.LOCKED.getCode());
                this.sysUsersService.updateById((Object)sysUsers);
                if (UserStatus.DORMANCY.getCode().equals(status)) {
                    throw new DormancyException(user.getUserName(), "\u8d26\u53f7\u5df2\u4f11\u7720");
                }
                throw new HussarLockedAccountException(user.getUserName(), "\u8d85\u8fc7" + days + "\u5929\u672a\u767b\u5f55\uff0c\u8d26\u53f7\u5df2\u88ab\u9501\u5b9a");
            }
        }
        if (UserStatus.TEMPORARY.getCode().equals(user.getTypeProperty())) {
            String beginTime = user.getStartTime();
            String endTime = user.getExpiredTime();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date begin = sdf.parse(beginTime);
                Date end = sdf.parse(endTime);
                Date now = sdf.parse(sdf.format(new Date()));
                if (begin.getTime() > now.getTime() || end.getTime() < now.getTime()) {
                    throw new TemporaryException(user.getUserName(), "\u4e34\u65f6\u8d26\u53f7\u672a\u5728\u6709\u6548\u671f");
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        if (this.globalProperties.getLoginTimeLimit().booleanValue() && "1".equals(user.getLoginTimeLimit())) {
            boolean flag = false;
            Date date = new Date();
            SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
            String startTime = user.getAccessLoginStartTime();
            String endTime = user.getAccessLoginEndTime();
            try {
                Date dt1 = df.parse(startTime);
                Date dt2 = df.parse(endTime);
                Date now = df.parse(df.format(date));
                if (dt1.getTime() <= now.getTime() && now.getTime() <= dt2.getTime()) {
                    flag = true;
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            if (!flag) {
                throw new LoginTimeRefuseException(user.getUserName(), "\u5f53\u524d\u65f6\u95f4\u7981\u6b62\u767b\u5f55");
            }
        }
        if (this.globalProperties.getLoginIpLimit().booleanValue() && "1".equals(user.getLoginIpLimit())) {
            boolean canLogin = false;
            String loginIp = HttpKit.getIp();
            List<String> list = this.iSysUserIpService.selectUserIp(user.getUserId());
            for (String ip : list) {
                if (!StringUtils.equals((CharSequence)loginIp, (CharSequence)ip)) continue;
                canLogin = true;
                break;
            }
            if (!canLogin) {
                throw new LoginIpRefuseException(user.getUserName(), "\u5f53\u524dIP\u7981\u6b62\u767b\u5f55");
            }
        }
        return user;
    }

    @Override
    public ShiroUser shiroUser(SysUsers user) {
        ShiroUser shiroUser = new ShiroUser();
        shiroUser.setId(user.getUserId());
        shiroUser.setAccount(user.getUserAccount());
        shiroUser.setDeptId(user.getDepartmentId());
        shiroUser.setEmployeeId(user.getEmployeeId());
        shiroUser.setDeptName(ConstantFactory.me().getDeptName(user.getDepartmentId()));
        shiroUser.setName(user.getUserName());
        shiroUser.setSecurityLevel(user.getSecurityLevel());
        shiroUser.setAccountStatus(user.getAccountStatus());
        List<String> rolesList = ConstantFactory.me().getRolesIdByUserId(user.getUserId());
        if (user.getEmployeeId() != null && user.getEmployeeId() != "") {
            List<String> roleList = ConstantFactory.me().getRolesIdByStruId(user.getDepartmentId());
            rolesList.addAll(roleList);
        }
        shiroUser.setRolesList(rolesList);
        List<String> IsRepeatAuthenticate2 = ConstantFactory.me().getIsRepeatAuthenticateId(user.getUserId());
        shiroUser.setIsRepeatAuthenticate(IsRepeatAuthenticate2);
        return shiroUser;
    }

    @Override
    public List<String> getAuthInfo(ShiroUser shiroUser) {
        return ConstantFactory.me().getAuthInfo(shiroUser).get("userPermission");
    }

    @Override
    public List<String> findPermissionsByRoleId(String roleId) {
        List<String> resUrls = this.resourcesMapper.getResUrlsByRoleId(roleId);
        return resUrls;
    }

    @Override
    public String findRoleNameByRoleId(String roleId) {
        return ConstantFactory.me().getSingleRoleTip(roleId);
    }

    @Override
    public SimpleAuthenticationInfo info(ShiroUser shiroUser, SysUsers user, String realmName) {
        String credentials = user.getPassword();
        return new SimpleAuthenticationInfo((Object)shiroUser, (Object)credentials, realmName);
    }
}

