/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.shiro.encrypt;

import com.jxdinfo.hussar.bsp.baseconfig.model.SysBaseConfig;
import com.jxdinfo.hussar.bsp.baseconfig.service.ISysBaseConfigService;
import com.jxdinfo.hussar.common.exception.HussarCredentialsException;
import com.jxdinfo.hussar.common.exception.HussarDisabledAccountException;
import com.jxdinfo.hussar.config.properties.EncryptTypeProperties;
import com.jxdinfo.hussar.core.shiro.lock.LoginLock;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authc.credential.SimpleCredentialsMatcher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;

@DependsOn(value={"springContextHolder"})
public abstract class AbstractCredentialsMatcher
extends SimpleCredentialsMatcher {
    @Autowired
    private EncryptTypeProperties etp;

    public boolean doCredentialsMatch(AuthenticationToken authcToken, AuthenticationInfo info) {
        ISysBaseConfigService iSysBaseConfigService = (ISysBaseConfigService)SpringContextHolder.getBean(ISysBaseConfigService.class);
        LoginLock loginLock = (LoginLock)SpringContextHolder.getBean(LoginLock.class);
        String localhost = this.etp.getSecretFreeIp();
        UsernamePasswordToken token = (UsernamePasswordToken)authcToken;
        String userName = token.getUsername();
        String password = String.valueOf(token.getPassword());
        String host = token.getHost();
        if (loginLock.userIsLock(userName)) {
            throw new HussarDisabledAccountException(userName, "\u5bc6\u7801\u8f93\u5165\u9519\u8bef\u6b21\u6570\u8d85\u8fc7\u9650\u5236\uff0c\u5e10\u53f7\u5df2\u7981\u6b62\u767b\u5f55\uff01");
        }
        boolean flag = false;
        if (StringUtils.isNotEmpty((CharSequence)host) && StringUtils.isNotEmpty((CharSequence)localhost) && this.equals(host, localhost)) {
            flag = this.equals(this.passwordEncode(userName.getBytes()), password);
        } else {
            String tokenCredentials = this.passwordEncode(password.getBytes());
            Object accountCredentials = this.getCredentials(info);
            flag = this.equals(tokenCredentials.toUpperCase(), ((String)accountCredentials).toUpperCase());
        }
        if (!flag) {
            int loginChanceTime;
            SysBaseConfig sysBaseConfig = iSysBaseConfigService.getSysBaseConfig("fail_number");
            String tryLoginTime = sysBaseConfig.getConfigValue();
            loginLock.addUserCache(userName, Integer.parseInt(tryLoginTime));
            int loginChance = Integer.parseInt(tryLoginTime) - loginLock.userLockNum(userName);
            int n = loginChanceTime = loginChance < 0 ? 0 : loginChance;
            if (loginChanceTime == 0) {
                throw new HussarCredentialsException(userName, "\u5f53\u524d\u7528\u6237\u5df2\u88ab\u9501\u5b9a\uff01");
            }
            throw new HussarCredentialsException(userName, "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef\uff0c\u8fd8\u6709" + loginChanceTime + "\u6b21\u673a\u4f1a");
        }
        loginLock.removeUserCache(userName);
        return flag;
    }

    public abstract String passwordEncode(byte[] var1);
}

