/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.shiro;

import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.shiro.factory.IShiro;
import com.jxdinfo.hussar.core.shiro.factory.ShiroFactroy;
import com.jxdinfo.hussar.isc.util.IscUtil;
import com.sgcc.isc.core.orm.complex.FunctionNode;
import com.sgcc.isc.core.orm.complex.FunctionTree;
import com.sgcc.isc.core.orm.resource.Function;
import com.sgcc.isc.service.adapter.factory.AdapterFactory;
import com.sgcc.isc.service.adapter.factory.agent.config.ConfigHolder;
import io.buji.pac4j.realm.Pac4jRealm;
import io.buji.pac4j.subject.Pac4jPrincipal;
import io.buji.pac4j.token.Pac4jToken;
import java.util.List;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.springframework.beans.factory.annotation.Value;

public class ShiroPac4jRealm
extends Pac4jRealm {
    private String clientName;
    private String activeType;

    @Value(value="${cas.active-type:active-type}")
    public void setActiveType(String activeType) {
        this.activeType = activeType;
    }

    public String getClientName() {
        return this.clientName;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        Pac4jToken pac4jToken = (Pac4jToken)authenticationToken;
        List commonProfileList = pac4jToken.getProfiles();
        Pac4jPrincipal principal = new Pac4jPrincipal(commonProfileList, this.getPrincipalNameAttribute());
        SimplePrincipalCollection principalCollection = new SimplePrincipalCollection((Object)principal, this.getName());
        return new SimpleAuthenticationInfo((PrincipalCollection)principalCollection, (Object)commonProfileList.hashCode());
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        if ("CASServer".equals(this.activeType) || "CASClient".equals(this.activeType)) {
            IShiro shiroFactory = ShiroFactroy.me();
            String userId = IscUtil.getUserIdFromPrincipalCollection(principals);
            SysUsers user = shiroFactory.user(userId);
            ShiroUser shiroUser = shiroFactory.shiroUser(user);
            List<String> permissionList = shiroFactory.getAuthInfo(shiroUser);
            SimpleAuthorizationInfo info = new SimpleAuthorizationInfo();
            info.addStringPermissions(permissionList);
            return info;
        }
        ShiroUser user = IscUtil.getShiroUserFromPrincipalCollection(principals);
        String userId = user.getId();
        SimpleAuthorizationInfo authInfo = new SimpleAuthorizationInfo();
        String appId = ConfigHolder.getAppId();
        try {
            FunctionTree funcTree = AdapterFactory.getResourceService().getFuncTree(userId, appId, null);
            List fn = funcTree.getFuncNode();
            for (FunctionNode functionNode : fn) {
                this.assemblingAuthInfo(authInfo, functionNode);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return authInfo;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    private void assemblingAuthInfo(SimpleAuthorizationInfo authInfo, FunctionNode functionNode) {
        Function currentNode = functionNode.getCurrentNode();
        String busiCode = currentNode.getBusiCode();
        authInfo.addStringPermission(busiCode);
        List nextNodes = functionNode.getNextNode();
        if (nextNodes.size() > 0) {
            nextNodes.forEach(node -> this.assemblingAuthInfo(authInfo, (FunctionNode)node));
        }
    }

    public boolean supports(AuthenticationToken token) {
        return super.supports(token) || token instanceof Pac4jToken;
    }
}

