/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.shiro;

import com.jxdinfo.hussar.bsp.permit.service.impl.SysStruAssistOrganImpl;
import com.jxdinfo.hussar.common.constant.factory.ConstantFactory;
import com.jxdinfo.hussar.common.exception.HussarUndeclaredThrowableException;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import com.jxdinfo.hussar.isc.util.IscUtil;
import io.buji.pac4j.subject.Pac4jPrincipal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.crypto.hash.Md5Hash;
import org.apache.shiro.crypto.hash.SimpleHash;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.springframework.context.ApplicationContext;

public class ShiroKit {
    private static ApplicationContext env = SpringContextHolder.getApplicationContext();
    static SysStruAssistOrganImpl sysStruAssistOrganImpl = (SysStruAssistOrganImpl)SpringContextHolder.getBean(SysStruAssistOrganImpl.class);
    private static final String NAMES_DELIMETER = ",";
    public static final String hashAlgorithmName = "MD5";
    public static final int hashIterations = 1024;

    public static String md5(String credentials, String saltSource) {
        Md5Hash salt = new Md5Hash((Object)saltSource);
        return new SimpleHash(hashAlgorithmName, (Object)credentials, (Object)salt, 1024).toString();
    }

    public static String getRandomSalt(int length) {
        return ToolUtil.getRandomString((int)length);
    }

    public static Subject getSubject() {
        return SecurityUtils.getSubject();
    }

    public static ShiroUser getUser() {
        if (ShiroKit.isGuest()) {
            String profile = env.getEnvironment().getProperty("spring.profiles.active");
            if ("dev".equals(profile)) {
                throw new HussarUndeclaredThrowableException();
            }
            return null;
        }
        Object principal = ShiroKit.getSubject().getPrincipals().getPrimaryPrincipal();
        if (principal instanceof ShiroUser) {
            return (ShiroUser)principal;
        }
        return IscUtil.getShiroUserFromPac4jPrincipal((Pac4jPrincipal)principal);
    }

    public static Session getSession() {
        return ShiroKit.getSubject().getSession();
    }

    public static <T> T getSessionAttr(String key) {
        Session session = ShiroKit.getSession();
        return (T)(session != null ? session.getAttribute((Object)key) : null);
    }

    public static void setSessionAttr(String key, Object value) {
        Session session = ShiroKit.getSession();
        session.setAttribute((Object)key, value);
    }

    public static void removeSessionAttr(String key) {
        Session session = ShiroKit.getSession();
        if (session != null) {
            session.removeAttribute((Object)key);
        }
    }

    public static boolean hasRole(String roleName) {
        return ShiroKit.getSubject() != null && roleName != null && roleName.length() > 0 && ShiroKit.getSubject().hasRole(roleName);
    }

    public static boolean lacksRole(String roleName) {
        return !ShiroKit.hasRole(roleName);
    }

    public static boolean hasAnyRoles(String roleNames) {
        boolean hasAnyRole = false;
        Subject subject = ShiroKit.getSubject();
        if (subject != null && roleNames != null && roleNames.length() > 0) {
            for (String role : roleNames.split(NAMES_DELIMETER)) {
                if (!subject.hasRole(role.trim())) continue;
                hasAnyRole = true;
                break;
            }
        }
        return hasAnyRole;
    }

    public static boolean hasAllRoles(String roleNames) {
        boolean hasAllRole = true;
        Subject subject = ShiroKit.getSubject();
        if (subject != null && roleNames != null && roleNames.length() > 0) {
            for (String role : roleNames.split(NAMES_DELIMETER)) {
                if (subject.hasRole(role.trim())) continue;
                hasAllRole = false;
                break;
            }
        }
        return hasAllRole;
    }

    public static boolean hasPermission(String permission) {
        return ShiroKit.getSubject() != null && permission != null && permission.length() > 0 && ShiroKit.getSubject().isPermitted(permission);
    }

    public static boolean lacksPermission(String permission) {
        return !ShiroKit.hasPermission(permission);
    }

    public static boolean isAuthenticated() {
        return ShiroKit.getSubject() != null && ShiroKit.getSubject().isAuthenticated();
    }

    public static boolean notAuthenticated() {
        return !ShiroKit.isAuthenticated();
    }

    public static boolean isUser() {
        return ShiroKit.getSubject() != null && ShiroKit.getSubject().getPrincipal() != null;
    }

    public static boolean isGuest() {
        return !ShiroKit.isUser();
    }

    public static String principal() {
        if (ShiroKit.getSubject() != null) {
            Object principal = ShiroKit.getSubject().getPrincipal();
            return principal.toString();
        }
        return "";
    }

    public static boolean isAdmin() {
        ShiroUser shiroUser = ShiroKit.getUser();
        if (null != shiroUser) {
            List<String> roleList = shiroUser.getRolesList();
            for (String roleId : roleList) {
                String singleRoleTip = ConstantFactory.me().getSingleRoleTip(roleId);
                if (!singleRoleTip.equals("\u8d85\u7ea7\u7ba1\u7406\u5458")) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isGradeadmin() {
        ShiroUser shiroUser = ShiroKit.getUser();
        return shiroUser.isGradeadmin();
    }

    public static List<Map<String, Object>> getAllOrgan() {
        ShiroUser shiroUser = ShiroKit.getUser();
        List<Map<String, Object>> allAssistOrgan = sysStruAssistOrganImpl.getAllAssistOrgan(shiroUser.getEmployeeId());
        HashMap<String, String> addMap = new HashMap<String, String>();
        addMap.put("assistDepIds", shiroUser.getDeptId());
        addMap.put("assistDeptName", shiroUser.getDeptName());
        allAssistOrgan.add(addMap);
        return allAssistOrgan;
    }

    public static List<String> getAllAssistOrganName() {
        ShiroUser shiroUser = ShiroKit.getUser();
        List<Map<String, Object>> allAssistOrgan = sysStruAssistOrganImpl.getAllAssistOrgan(shiroUser.getEmployeeId());
        ArrayList<String> allAssistOrganName = new ArrayList<String>();
        for (Map<String, Object> objectMap : allAssistOrgan) {
            String str = String.valueOf(objectMap.get("assistDeptName"));
            allAssistOrganName.add(str);
        }
        return allAssistOrganName;
    }
}

