/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.shiro;

import com.jxdinfo.hussar.bsp.permit.service.ISysOnlineHistService;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import com.jxdinfo.hussar.core.log.HussarLogManager;
import com.jxdinfo.hussar.core.log.factory.LogTaskFactory;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.shiro.sessionlimit.SessionLimit;
import com.jxdinfo.hussar.core.support.HttpKit;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.Deque;
import java.util.HashMap;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.SessionListener;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;

@DependsOn(value={"springContextHolder"})
@Component
public class HussarSessionListener
implements SessionListener {
    @Autowired
    SessionDAO sessionDAO;
    @Autowired
    GlobalProperties globalProperties;

    public void onStart(Session session) {
    }

    public void onStop(Session session) {
        String userId;
        SessionLimit sessionLimit;
        Deque<Serializable> deque;
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("sessionId", (String)((Object)ShiroKit.getSession().getId()));
        info.put("ip", HttpKit.getIp());
        info.put("port", HttpKit.getPort());
        info.put("host", HttpKit.getHost());
        info.put("localIp", HttpKit.getLocalIp());
        info.put("localPort", HttpKit.getLocalPort());
        info.put("localHost", HttpKit.getLocalHost());
        ShiroUser shiroUser = (ShiroUser)session.getAttribute((Object)"shiroUser");
        Object cause = session.getAttribute((Object)"cause");
        Object kickout = session.getAttribute((Object)"kickout");
        Object loginNewSessionId = session.getAttribute((Object)"loginNewSessionId");
        Object loginNewIp = session.getAttribute((Object)"loginNewIp");
        if (kickout != null) {
            info.put("kickout", Boolean.toString((Boolean)kickout));
        }
        if (cause != null) {
            info.put("cause", (String)cause);
        }
        if (loginNewSessionId != null) {
            info.put("loginNewSessionId", (String)loginNewSessionId);
        }
        if (loginNewIp != null) {
            info.put("loginNewIp", (String)loginNewIp);
        }
        if (ToolUtil.isNotEmpty((Object)shiroUser)) {
            HussarLogManager.me().executeLog(LogTaskFactory.exitLog(shiroUser, "06", info));
        }
        ISysOnlineHistService iOnlineHistService = (ISysOnlineHistService)SpringContextHolder.getBean(ISysOnlineHistService.class);
        iOnlineHistService.updateLogoffTime();
        GlobalProperties gp = (GlobalProperties)SpringContextHolder.getBean(GlobalProperties.class);
        if (gp.isSessionLimit() && ToolUtil.isNotEmpty(deque = (sessionLimit = (SessionLimit)SpringContextHolder.getBean(SessionLimit.class)).getUserSession(userId = (String)session.getAttribute((Object)"userId")))) {
            deque.remove(session.getId());
            sessionLimit.addUserSession(userId, deque);
        }
        if (ToolUtil.isNotEmpty((Object)shiroUser)) {
            HussarCacheManager hussarCacheManager = (HussarCacheManager)SpringContextHolder.getBean(HussarCacheManager.class);
            hussarCacheManager.delete("authorization_info", "shiro_authInfo:" + shiroUser.getId());
            hussarCacheManager.delete("menu_info", "shiro_menus:" + shiroUser.getId());
        }
        this.sessionDAO.delete(session);
    }

    public void onExpiration(Session session) {
        String userId;
        SessionLimit sessionLimit;
        Deque<Serializable> deque;
        HashMap<String, String> info = new HashMap<String, String>();
        ShiroUser shiroUser = (ShiroUser)session.getAttribute((Object)"shiroUser");
        info.put("sessionId", (String)((Object)session.getId()));
        if (RequestContextHolder.getRequestAttributes() != null) {
            info.put("ip", HttpKit.getIp());
            info.put("port", HttpKit.getPort());
            info.put("host", HttpKit.getHost());
            info.put("localIp", HttpKit.getLocalIp());
            info.put("localPort", HttpKit.getLocalPort());
            info.put("localHost", HttpKit.getLocalHost());
            if (ToolUtil.isNotEmpty((Object)shiroUser)) {
                HussarLogManager.me().executeLog(LogTaskFactory.exitLog(shiroUser, "06", info));
            }
        }
        ISysOnlineHistService iOnlineHistService = (ISysOnlineHistService)SpringContextHolder.getBean(ISysOnlineHistService.class);
        iOnlineHistService.updateLogoffTime();
        GlobalProperties gp = (GlobalProperties)SpringContextHolder.getBean(GlobalProperties.class);
        if (gp.isSessionLimit() && ToolUtil.isNotEmpty(deque = (sessionLimit = (SessionLimit)SpringContextHolder.getBean(SessionLimit.class)).getUserSession(userId = (String)session.getAttribute((Object)"userId")))) {
            deque.remove(session.getId());
            sessionLimit.addUserSession(userId, deque);
        }
        if (ToolUtil.isNotEmpty((Object)shiroUser)) {
            HussarCacheManager hussarCacheManager = (HussarCacheManager)SpringContextHolder.getBean(HussarCacheManager.class);
            hussarCacheManager.delete("authorization_info", "shiro_authInfo:" + shiroUser.getId());
            hussarCacheManager.delete("menu_info", "shiro_menus:" + shiroUser.getId());
        }
        this.sessionDAO.delete(session);
    }
}

