/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.redis.util;

import com.alibaba.fastjson.JSON;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.crazycake.shiro.serializer.ObjectSerializer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.stereotype.Component;
import redis.clients.jedis.Client;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisCluster;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Tuple;
import redis.clients.util.Pool;
import redis.clients.util.Slowlog;

@Component
@ConditionalOnProperty(prefix="hussar", name={"stand-alone"}, havingValue="false", matchIfMissing=false)
public class RedisUtil {
    private static Logger logger = LogManager.getLogger(RedisUtil.class);
    Pool<Jedis> jedisPool;
    JedisCluster jedisCluster;

    public RedisUtil(Pool<Jedis> jedisPool, JedisCluster jedisCluster) {
        this.jedisCluster = jedisCluster;
        this.jedisPool = jedisPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRedisInfo() {
        if (this.jedisCluster != null && this.jedisCluster.getClusterNodes().size() > 0) {
            StringBuffer infos = new StringBuffer();
            Jedis jedis = null;
            try {
                Map clusterNodes = this.jedisCluster.getClusterNodes();
                for (Map.Entry entry : clusterNodes.entrySet()) {
                    jedis = ((JedisPool)entry.getValue()).getResource();
                    Client client = jedis.getClient();
                    client.info();
                    infos.append(client.getBulkReply());
                    jedis.close();
                    jedis = null;
                }
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                    jedis = null;
                }
            }
            return infos.toString();
        }
        Jedis jedis = null;
        try {
            jedis = (Jedis)this.jedisPool.getResource();
            Client client = jedis.getClient();
            client.info();
            String string = client.getBulkReply();
            return string;
        }
        finally {
            if (jedis != null) {
                jedis.close();
                jedis = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Slowlog> getLogs(long entries) {
        if (this.jedisCluster != null && this.jedisCluster.getClusterNodes().size() > 0) {
            ArrayList<Slowlog> slowLog = new ArrayList<Slowlog>();
            Jedis jedis = null;
            try {
                Map clusterNodes = this.jedisCluster.getClusterNodes();
                for (Map.Entry entry : clusterNodes.entrySet()) {
                    jedis = ((JedisPool)entry.getValue()).getResource();
                    slowLog.addAll(jedis.slowlogGet(entries));
                    jedis.close();
                    jedis = null;
                }
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                    jedis = null;
                }
            }
            return slowLog;
        }
        Jedis jedis = null;
        try {
            jedis = (Jedis)this.jedisPool.getResource();
            List list = jedis.slowlogGet(entries);
            return list;
        }
        finally {
            if (jedis != null) {
                jedis.close();
                jedis = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getLogsLen() {
        if (this.jedisCluster != null && this.jedisCluster.getClusterNodes().size() > 0) {
            Long slowlogLen = 0L;
            Jedis jedis = null;
            try {
                Map clusterNodes = this.jedisCluster.getClusterNodes();
                for (Map.Entry entry : clusterNodes.entrySet()) {
                    jedis = ((JedisPool)entry.getValue()).getResource();
                    slowlogLen = slowlogLen + jedis.slowlogLen();
                    jedis.close();
                    jedis = null;
                }
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                    jedis = null;
                }
            }
            return slowlogLen;
        }
        Jedis jedis = null;
        try {
            jedis = (Jedis)this.jedisPool.getResource();
            Long l = jedis.slowlogLen();
            return l;
        }
        finally {
            if (jedis != null) {
                jedis.close();
                jedis = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String logEmpty() {
        if (this.jedisCluster != null && this.jedisCluster.getClusterNodes().size() > 0) {
            Jedis jedis = null;
            StringBuffer slowlogResetResult = new StringBuffer();
            try {
                Map clusterNodes = this.jedisCluster.getClusterNodes();
                for (Map.Entry entry : clusterNodes.entrySet()) {
                    jedis = ((JedisPool)entry.getValue()).getResource();
                    slowlogResetResult.append(jedis.slowlogReset());
                    jedis.close();
                    jedis = null;
                }
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                    jedis = null;
                }
            }
            return slowlogResetResult.toString();
        }
        Jedis jedis = null;
        try {
            jedis = (Jedis)this.jedisPool.getResource();
            String string = jedis.slowlogReset();
            return string;
        }
        finally {
            if (jedis != null) {
                jedis.close();
                jedis = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long dbSize() {
        if (this.jedisCluster != null && this.jedisCluster.getClusterNodes().size() > 0) {
            Jedis jedis = null;
            Long size = 0L;
            try {
                Map clusterNodes = this.jedisCluster.getClusterNodes();
                for (Map.Entry entry : clusterNodes.entrySet()) {
                    jedis = ((JedisPool)entry.getValue()).getResource();
                    Client client = jedis.getClient();
                    client.dbSize();
                    size = size + client.getIntegerReply();
                    jedis.close();
                    jedis = null;
                }
            }
            finally {
                if (jedis != null) {
                    jedis.close();
                    jedis = null;
                }
            }
            return size;
        }
        Jedis jedis = null;
        try {
            jedis = (Jedis)this.jedisPool.getResource();
            Client client = jedis.getClient();
            client.dbSize();
            Long l = client.getIntegerReply();
            return l;
        }
        finally {
            if (jedis != null) {
                jedis.close();
                jedis = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDbAmountForRedis() {
        if (this.jedisCluster != null && this.jedisCluster.getClusterNodes().size() > 0) {
            return 1;
        }
        Jedis jedis = null;
        try {
            jedis = (Jedis)this.jedisPool.getResource();
            List e = jedis.configGet("databases");
            int dbAmount1 = e.size() > 0 ? Integer.parseInt((String)e.get(1)) : 15;
            int n = dbAmount1;
            return n;
        }
        catch (Exception e) {
            System.out.println("\u53d6\u5f97reids\u4e2d\u6570\u636e\u5e93\u7684\u6570\u91cf\u51fa\u9519\uff01 " + e.getMessage());
            e.printStackTrace();
            int n = 1;
            return n;
        }
        finally {
            if (jedis != null) {
                jedis.close();
                jedis = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> getNoSQLDBForRedis(int pageSize, int limitFrom, String noSQLDbName, String selectKey) {
        String currentDBindex = noSQLDbName.substring(2, noSQLDbName.length());
        HashMap<String, Object> tempMap = new HashMap<String, Object>(4);
        Jedis jedis = null;
        ArrayList list = new ArrayList();
        try {
            if (this.jedisCluster != null && this.jedisCluster.getClusterNodes().size() > 0) {
                String nokeyString = "nokey";
                Long dbSize = 0L;
                int count = 0;
                Map clusterNodes = this.jedisCluster.getClusterNodes();
                for (Map.Entry entry : clusterNodes.entrySet()) {
                    jedis = ((JedisPool)entry.getValue()).getResource();
                    Client client = jedis.getClient();
                    client.dbSize();
                    dbSize = dbSize + client.getIntegerReply();
                    if (!jedis.info("replication").contains("role:slave")) {
                        Set nodekeys = new HashSet();
                        nodekeys = nokeyString.equals(selectKey) ? jedis.keys("*") : jedis.keys("*" + selectKey + "*");
                        for (String key : nodekeys) {
                            Long lon;
                            HashMap<String, Object> map = new HashMap<String, Object>(4);
                            String type = jedis.type(key);
                            map.put("key", key);
                            map.put("type", type);
                            if ("string".equals(type)) {
                                String value = jedis.get(key);
                                if (value.length() > 1000) {
                                    map.put("value", value.substring(0, 999) + "......");
                                } else {
                                    map.put("value", value);
                                }
                            }
                            if ("list".equals(type)) {
                                lon = jedis.llen(key);
                                if (lon > 20L) {
                                    lon = 20L;
                                }
                                map.put("value", jedis.lrange(key, 0L, lon.longValue()));
                            }
                            if ("set".equals(type)) {
                                map.put("value", jedis.smembers(key).toString());
                            }
                            if ("zset".equals(type)) {
                                lon = jedis.zcard(key);
                                if (lon > 20L) {
                                    lon = 20L;
                                }
                                Set set = jedis.zrangeWithScores(key, 0L, lon.longValue());
                                Iterator itt = set.iterator();
                                String ss = "";
                                while (itt.hasNext()) {
                                    Tuple str = (Tuple)itt.next();
                                    StringBuilder ssBuilder = new StringBuilder(100);
                                    ss = ssBuilder.append(ss).append("[").append(str.getScore()).append(",").append(str.getElement()).append("],").toString();
                                }
                                ss = ss.substring(0, ss.length() - 1);
                                map.put("value", "[" + ss + "]");
                            }
                            if ("hash".equals(type)) {
                                map.put("value", jedis.hgetAll(key).toString());
                            }
                            list.add(map);
                        }
                    }
                    jedis.close();
                    jedis = null;
                }
                if (nokeyString.equals(selectKey)) {
                    tempMap.put("rowCount", Integer.parseInt(dbSize.toString()));
                } else {
                    tempMap.put("rowCount", count - 1);
                }
                tempMap.put("dataList", list);
            } else {
                int i;
                jedis = (Jedis)this.jedisPool.getResource();
                jedis.select(Integer.parseInt(currentDBindex));
                Long dbSize = jedis.dbSize();
                Set nodekeys = new HashSet();
                String nokeyString = "nokey";
                long dbSizeLimit = 1000L;
                if (nokeyString.equals(selectKey)) {
                    if (dbSize > dbSizeLimit) {
                        limitFrom = 0;
                        for (int it = 0; it < pageSize; ++it) {
                            ((Set)nodekeys).add(jedis.randomKey());
                        }
                    } else {
                        nodekeys = jedis.keys("*");
                    }
                } else {
                    nodekeys = jedis.keys("*" + selectKey + "*");
                }
                Iterator it = ((Set)nodekeys).iterator();
                String value = "";
                for (i = 1; it.hasNext() && i < limitFrom + pageSize; ++i) {
                    if (i >= limitFrom) {
                        Long lon;
                        HashMap<String, Object> map = new HashMap<String, Object>(4);
                        String key = (String)it.next();
                        new StringRedisSerializer().deserialize(key.getBytes());
                        String type = jedis.type(key);
                        map.put("key", key);
                        map.put("type", type);
                        if ("string".equals(type)) {
                            if (key.startsWith("shiro:")) {
                                Jedis bj = jedis;
                                byte[] v = bj.get(key.getBytes());
                                ObjectSerializer os = new ObjectSerializer();
                                Object o = os.deserialize(v);
                                value = JSON.toJSONString((Object)o);
                            } else {
                                value = jedis.get(key);
                            }
                            if (value.length() > 1000) {
                                map.put("value", value.substring(0, 999) + "......");
                            } else {
                                map.put("value", value);
                            }
                        }
                        if ("list".equals(type)) {
                            lon = jedis.llen(key);
                            if (lon > 20L) {
                                lon = 20L;
                            }
                            map.put("value", jedis.lrange(key, 0L, lon.longValue()));
                        }
                        if ("set".equals(type)) {
                            map.put("value", jedis.smembers(key).toString());
                        }
                        if ("zset".equals(type)) {
                            lon = jedis.zcard(key);
                            if (lon > 20L) {
                                lon = 20L;
                            }
                            Set set = jedis.zrangeWithScores(key, 0L, lon.longValue());
                            Iterator itt = set.iterator();
                            String ss = "";
                            while (itt.hasNext()) {
                                Tuple str = (Tuple)itt.next();
                                StringBuilder ssBuilder = new StringBuilder(100);
                                ss = ssBuilder.append(ss).append("[").append(str.getScore()).append(",").append(str.getElement()).append("],").toString();
                            }
                            ss = ss.substring(0, ss.length() - 1);
                            map.put("value", "[" + ss + "]");
                        }
                        if ("hash".equals(type)) {
                            map.put("value", jedis.hgetAll(key).toString());
                        }
                        list.add(map);
                        continue;
                    }
                    it.next();
                }
                if (nokeyString.equals(selectKey)) {
                    tempMap.put("rowCount", Integer.parseInt(dbSize.toString()));
                } else {
                    tempMap.put("rowCount", i - 1);
                }
                tempMap.put("dataList", list);
            }
        }
        catch (Exception e) {
            String info = "\u53d6\u5f97 NoSQL\u6570\u636e\u51fa\u9519\uff1a" + e.getMessage();
            logger.error(info);
            System.out.println(info);
            e.printStackTrace();
        }
        finally {
            if (jedis != null) {
                jedis.disconnect();
                jedis.close();
                jedis = null;
            }
        }
        return tempMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteKeys(String noSQLDbName, String[] ids) {
        if (this.jedisCluster != null && this.jedisCluster.getClusterNodes().size() > 0) {
            for (String id : ids) {
                this.jedisCluster.del(new String[]{id});
            }
            return true;
        }
        Jedis jedis = null;
        String currentDBindex = noSQLDbName.substring(2, noSQLDbName.length());
        try {
            jedis = (Jedis)this.jedisPool.getResource();
            jedis.select(Integer.parseInt(currentDBindex));
            for (String id : ids) {
                jedis.del(new String[]{id});
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (jedis != null) {
                jedis.disconnect();
                jedis.close();
                jedis = null;
            }
        }
    }

    public String getDateStr(long timeStmp) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return dateFormat.format(new Date(timeStmp));
    }
}

