/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.redis.controller;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.core.redis.model.RedisInfoDetail;
import com.jxdinfo.hussar.core.redis.service.RedisService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/redis1"})
@ConditionalOnProperty(prefix="hussar", name={"stand-alone"}, havingValue="false", matchIfMissing=false)
public class RedisMonitorController {
    private static Logger logger = LogManager.getLogger(RedisMonitorController.class);
    @Autowired
    RedisService redisService;
    @Value(value="${hussar.stand-alone}")
    private boolean stand_alone;

    @RequestMapping(value={"/getAllRedisDatabaseList"})
    @ResponseBody
    public ApiResponse<Object> getAllRedisDatabaseList1() {
        List<Map<String, Object>> list = this.redisService.getAllDataBaseForRedis();
        return ApiResponse.data(list);
    }

    @RequiresPermissions(value={"redis:getKeysSize"})
    @RequestMapping(value={"/getKeysSize"})
    @ResponseBody
    public ApiResponse<String> getKeysSize() {
        String result = JSON.toJSONString(this.redisService.getKeysSize());
        return ApiResponse.data(result);
    }

    @RequiresPermissions(value={"redis:getMemeryInfo"})
    @RequestMapping(value={"/getMemeryInfo"})
    @ResponseBody
    public ApiResponse<String> getMemeryInfo() {
        String result = JSON.toJSONString(this.redisService.getMemeryInfo());
        return ApiResponse.data(result);
    }

    @RequiresPermissions(value={"redis:redisMonitor"})
    @RequestMapping(value={"/ridList"})
    @ResponseBody
    public ApiResponse<List<RedisInfoDetail>> redisMonitor() {
        List<RedisInfoDetail> ridList = this.redisService.getRedisInfo();
        HashMap map = new HashMap();
        return ApiResponse.data(ridList);
    }
}

