/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.redis.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.jxdinfo.hussar.core.redis.model.RedisInfoDetail;
import com.jxdinfo.hussar.core.redis.service.RedisService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"redis"})
@ConditionalOnProperty(prefix="hussar", name={"stand-alone"}, havingValue="false", matchIfMissing=false)
public class RedisController {
    private static Logger logger = LogManager.getLogger(RedisController.class);
    @Autowired
    RedisService redisService;
    @Value(value="${hussar.stand-alone}")
    private boolean stand_alone;

    @RequiresPermissions(value={"redis:redisMonitor"})
    @RequestMapping(value={"redisMonitor"})
    public String redisMonitor(Model model) {
        List<RedisInfoDetail> ridList = this.redisService.getRedisInfo();
        model.addAttribute("infoList", ridList);
        return "/core/redis/redisMonitor.html";
    }

    @RequiresPermissions(value={"redis:logEmpty"})
    @RequestMapping(value={"logEmpty"})
    @ResponseBody
    public String logEmpty() {
        return this.redisService.logEmpty();
    }

    @RequiresPermissions(value={"redis:getKeysSize"})
    @RequestMapping(value={"getKeysSize"})
    @ResponseBody
    public String getKeysSize() {
        return JSON.toJSONString(this.redisService.getKeysSize());
    }

    @RequiresPermissions(value={"redis:getMemeryInfo"})
    @RequestMapping(value={"getMemeryInfo"})
    @ResponseBody
    public String getMemeryInfo() {
        return JSON.toJSONString(this.redisService.getMemeryInfo());
    }

    @RequiresPermissions(value={"redis:manageView"})
    @RequestMapping(value={"/manageView"})
    public String index() {
        return "/core/redis/redisManage.html";
    }

    @RequiresPermissions(value={"redis:getAllRedisDatabaseList"})
    @RequestMapping(value={"getAllRedisDatabaseList"})
    @ResponseBody
    public Object getAllRedisDatabaseList() {
        return this.redisService.getAllDataBaseForRedis();
    }

    @RequiresPermissions(value={"redis:showRedisDBValue"})
    @RequestMapping(value={"/showRedisDBValue"})
    @ResponseBody
    public Object showNoSQLDBValue(@RequestParam(value="NoSQLDbName", required=false) String noSQLDbName, @RequestParam(value="selectKey", required=false) String selectKey, @RequestParam(value="page", defaultValue="1") int pageNo, @RequestParam(value="limit", defaultValue="20") int limit) {
        Page page = new Page((long)pageNo, (long)limit);
        HashMap<String, Object> result = new HashMap<String, Object>(10);
        if (StringUtils.isBlank((CharSequence)noSQLDbName)) {
            result.put("code", 0);
            result.put("count", 0);
            result.put("data", null);
            return result;
        }
        if (selectKey == null) {
            selectKey = "nokey";
        }
        List list = this.redisService.getNoSQLDBForRedis((Page<Map<String, Object>>)page, noSQLDbName, selectKey).getRecords();
        result.put("code", 0);
        result.put("count", page.getTotal());
        result.put("data", list);
        return result;
    }

    @RequiresPermissions(value={"redis:deleteNoSQLKeys"})
    @RequestMapping(value={"/deleteNoSQLKeys"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, Object> deleteNoSQLKeys(@RequestParam(value="NoSQLDbName") String noSQLDbName, @RequestParam(value="keys") String keys) {
        String message = "";
        String status = "";
        try {
            JSONArray arr = JSON.parseArray((String)keys);
            String[] strarr = (String[])arr.toArray((Object[])new String[arr.size()]);
            this.redisService.deleteNoSQLKeyForRedis(noSQLDbName, strarr);
            message = "\u5220\u9664\u6210\u529f";
            status = "success";
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            e.printStackTrace();
            message = e.getMessage();
            status = "fail";
        }
        HashMap<String, Object> map = new HashMap<String, Object>(10);
        map.put("message", message);
        map.put("status", status);
        return map;
    }
}

