/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.log.mongodb.service.impl;

import com.jxdinfo.hussar.core.log.mongodb.model.LogMongo;
import com.jxdinfo.hussar.core.log.mongodb.service.ILogMongoService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.stereotype.Component;

@ConditionalOnClass(value={MongoTemplate.class})
@Component(value="ILogMongoService")
public class LogMongoServiceImpl
implements ILogMongoService {
    @Autowired
    private MongoTemplate mongoTemplate;

    @Override
    public List<LogMongo> findByChoose(LogMongo logMongo, Pageable pageable) {
        Query query = this.findQuery(logMongo);
        query.with(new Sort(new Sort.Order[]{new Sort.Order(Sort.Direction.DESC, "date")}));
        return this.findByPage(query, pageable);
    }

    @Override
    public List<LogMongo> findByChooseNoPager(LogMongo logMongo) {
        Query query = this.findQuery(logMongo);
        query.with(new Sort(new Sort.Order[]{new Sort.Order(Sort.Direction.DESC, "date")}));
        return this.findNoPage(query);
    }

    @Override
    public Long findCount(LogMongo logMongo) {
        Query query = this.findQuery(logMongo);
        return this.mongoTemplate.count(query, LogMongo.class, "logs");
    }

    public List<LogMongo> findByPage(Query query, Pageable pageable) {
        return this.mongoTemplate.find(query.with(pageable), LogMongo.class, "logs");
    }

    public List<LogMongo> findNoPage(Query query) {
        return this.mongoTemplate.find(query, LogMongo.class, "logs");
    }

    public Query findQuery(LogMongo logMongo) {
        Criteria criatira = new Criteria();
        criatira.andOperator(new Criteria[]{Criteria.where((String)"message").regex(".*?" + logMongo.getMessage() + ".*", "i"), Criteria.where((String)"source.methodName").regex(".*?" + logMongo.getMethodName() + ".*", "i"), Criteria.where((String)"source.fileName").regex(".*?" + logMongo.getFileName() + ".*", "i"), Criteria.where((String)"date").gte((Object)logMongo.getDateSelectStrat()).lte((Object)logMongo.getDateSelectEnd())});
        Query query = new Query((CriteriaDefinition)criatira);
        return query;
    }
}

