/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.log.mongodb.controller;

import com.jxdinfo.hussar.config.properties.HussarProperties;
import com.jxdinfo.hussar.core.log.mongodb.model.LogMongo;
import com.jxdinfo.hussar.core.log.mongodb.service.ILogMongoService;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@ConditionalOnClass(value={MongoTemplate.class})
@RequestMapping(value={"/logMongo"})
public class LogMongoController {
    private static Logger log = LogManager.getLogger(LogMongoController.class);
    @Autowired
    private HussarProperties hussarProperties;
    @Resource
    private ILogMongoService logMongoService;

    @RequiresPermissions(value={"logMongo:index"})
    @RequestMapping(value={""})
    public String index() {
        return "/core/log/mongodb/logMongo.html";
    }

    @RequiresPermissions(value={"logMongo:find"})
    @RequestMapping(value={"/find"})
    @ResponseBody
    public Map find(HttpServletRequest request, @RequestParam(value="page") int page, @RequestParam(value="limit") int limit) {
        LogMongo logMongo = new LogMongo();
        try {
            String endTime;
            logMongo.setMessage(request.getParameter("message") == null ? "" : request.getParameter("message"));
            logMongo.setMethodName(request.getParameter("methodName") == null ? "" : request.getParameter("methodName"));
            logMongo.setFileName(request.getParameter("fileName") == null ? "" : request.getParameter("fileName"));
            String startTime = request.getParameter("dateSelectStrat") == null ? "" : request.getParameter("dateSelectStrat");
            String string = endTime = request.getParameter("dateSelectEnd") == null ? "" : request.getParameter("dateSelectEnd");
            if ("".equals(startTime)) {
                startTime = "1990-01-01 00:00:00";
            }
            logMongo.setDateSelectStrat(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(startTime));
            if ("".equals(endTime)) {
                logMongo.setDateSelectEnd(new Date());
            } else {
                logMongo.setDateSelectEnd(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(endTime));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
        }
        PageRequest pageable = new PageRequest(page - 1, limit);
        List<LogMongo> data = this.logMongoService.findByChoose(logMongo, (Pageable)pageable);
        HashMap<String, Object> datas = new HashMap<String, Object>();
        datas.put("code", 0);
        datas.put("message", "");
        datas.put("count", this.logMongoService.findCount(logMongo));
        datas.put("data", data);
        return datas;
    }

    @RequiresPermissions(value={"logMongo:dowlond"})
    @RequestMapping(value={"/dowlond"})
    public void dowlond(HttpServletRequest request, HttpServletResponse response) {
        response.setCharacterEncoding("UTF-8");
        LogMongo logMongo = new LogMongo();
        String message = request.getParameter("download_message");
        String methodName = request.getParameter("download_methodName");
        String fileName = request.getParameter("download_fileName");
        String dateSelectStrat = request.getParameter("download_dateSelectStrat");
        String startTime = dateSelectStrat == null ? "" : dateSelectStrat;
        String dateSelectEnd = request.getParameter("download_dateSelectEnd");
        String endTime = dateSelectEnd == null ? "" : dateSelectEnd;
        logMongo.setFileName(fileName == null ? "" : fileName);
        logMongo.setMethodName(methodName == null ? "" : methodName);
        logMongo.setMessage(message == null ? "" : message);
        try {
            if ("".equals(startTime)) {
                startTime = "1990-01-01 00:00:00";
            }
            logMongo.setDateSelectStrat(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(startTime));
            if ("".equals(endTime)) {
                logMongo.setDateSelectEnd(new Date());
            } else {
                logMongo.setDateSelectEnd(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(endTime));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
        }
        List<LogMongo> data = this.logMongoService.findByChooseNoPager(logMongo);
        if (data.size() > this.hussarProperties.getDownloadLogLimit()) {
            try {
                PrintWriter printWriter = response.getWriter();
                printWriter.write("<script>alert(\"\u65e5\u5fd7\u8fc7\u5927\uff0c\u8bf7\u7f29\u51cf\u65e5\u5fd7\u8303\u56f4\");</script>");
                printWriter.flush();
                printWriter.close();
            }
            catch (IOException e) {
                log.error(e.getMessage());
                e.printStackTrace();
            }
        } else {
            StringBuilder sbf = new StringBuilder();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            String template = "[date] [level] - [className] (fileName:lineNumber) - messgae";
            for (LogMongo logMongo1 : data) {
                sbf.append(template.replace("date", sdf.format(logMongo1.getDate())).replace("level", logMongo1.getLevel()).replace("className", logMongo1.getClassName()).replace("fileName", logMongo1.getFileName()).replace("lineNumber", String.valueOf(logMongo1.getLineNumber())).replace("messgae", logMongo1.getMessage())).append(" \r\n");
            }
            try {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(sbf.toString().getBytes());
                byte[] by = new byte[((InputStream)inputStream).available()];
                inputStream.read(by);
                ((InputStream)inputStream).close();
                SimpleDateFormat fileDate = new SimpleDateFormat("yyyyMMdd");
                String fileNames = new String("\u65e5\u5fd7\u4e0b\u8f7d".getBytes("GBK"), "ISO8859-1");
                response.addHeader("content-type", "application/x-msdownload");
                response.addHeader("Content-Disposition", "attachment;filename=" + fileDate.format(new Date()) + fileNames + ".log");
                ServletOutputStream outputStream = response.getOutputStream();
                outputStream.write(by);
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException e) {
                log.error(e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

