/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.log.factory;

import com.jxdinfo.hussar.bsp.permit.dao.SysResourcesMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysSecurityLogMapper;
import com.jxdinfo.hussar.bsp.permit.model.SysSecurityLog;
import com.jxdinfo.hussar.bsp.permit.vo.SysResourcesVo;
import com.jxdinfo.hussar.common.constant.state.LogSucceed;
import com.jxdinfo.hussar.common.constant.state.LogType;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import com.jxdinfo.hussar.core.constant.LevelEvent;
import com.jxdinfo.hussar.core.db.Db;
import com.jxdinfo.hussar.core.log.factory.LogFactory;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.SysSecurityLogMailUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.Map;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.DependsOn;

@DependsOn(value={"springContextHolder"})
public class LogTaskFactory {
    private static Logger logger = LoggerFactory.getLogger(LogTaskFactory.class);
    private static SysSecurityLogMapper securityLogMapper = Db.getMapper(SysSecurityLogMapper.class);
    private static SysResourcesMapper resourcesMapper = Db.getMapper(SysResourcesMapper.class);
    private static HussarCacheManager hussarCacheManager = (HussarCacheManager)SpringContextHolder.getBean(HussarCacheManager.class);
    private static GlobalProperties globalProperties = (GlobalProperties)SpringContextHolder.getBean(GlobalProperties.class);

    public static TimerTask loginLog(final ShiroUser user, final String type, final Map<String, String> info) {
        return new TimerTask(){

            @Override
            public void run() {
                try {
                    SysSecurityLog sysSecurityLog = LogFactory.createLoginLog(LogType.LOGIN, user, "\u767b\u5165", info, type);
                    LogTaskFactory.insertSecurityLog(sysSecurityLog);
                }
                catch (Exception e) {
                    logger.error("\u521b\u5efa\u767b\u5f55\u65e5\u5fd7\u5f02\u5e38!", (Throwable)e);
                }
            }
        };
    }

    public static TimerTask loginLog(final String username, final String msg, final String type, final Map<String, String> info) {
        return new TimerTask(){

            @Override
            public void run() {
                SysSecurityLog sysSecurityLog = LogFactory.createLoginExceptionLog(LogType.LOGIN_FAIL, username, "\u8d26\u53f7:" + username + "," + msg, info, type);
                try {
                    LogTaskFactory.insertSecurityLog(sysSecurityLog);
                }
                catch (Exception e) {
                    logger.error("\u521b\u5efa\u767b\u5f55\u5931\u8d25\u5f02\u5e38!", (Throwable)e);
                }
            }
        };
    }

    public static TimerTask exitLog(final ShiroUser user, final String type, final Map<String, String> info) {
        return new TimerTask(){

            @Override
            public void run() {
                String msg = "\u767b\u51fa";
                String kickout = (String)info.get("kickout");
                String cause = (String)info.get("cause");
                if (kickout != null && Boolean.valueOf(kickout).booleanValue()) {
                    msg = "\u60a8\u5df2\u7ecf\u5728\u522b\u5904\u767b\u5f55\uff01 ; \u65b0\u4f1a\u8bddIP\u4e3a\uff1a" + (String)info.get("loginNewIp") + " ; \u65b0\u4f1a\u8bddID\u4e3a\uff1a" + (String)info.get("loginNewSessionId");
                }
                if (cause != null && "maxSession".equals(cause)) {
                    msg = "\u8d85\u8fc7\u7cfb\u7edf\u6700\u5927\u4f1a\u8bdd\u6570\u9650\u5236\uff01";
                }
                SysSecurityLog sysSecurityLog = LogFactory.createLoginLog(LogType.EXIT, user, msg, info, type);
                try {
                    LogTaskFactory.insertSecurityLog(sysSecurityLog);
                }
                catch (Exception e) {
                    logger.error("\u521b\u5efa\u9000\u51fa\u65e5\u5fd7\u5f02\u5e38!", (Throwable)e);
                }
            }
        };
    }

    public static TimerTask bussinessLog(final ShiroUser user, final String bussinessName, final String className, final String methodName, final String msg, final Map<String, String> info, final String key, final String type, final String levelEvent) {
        return new TimerTask(){

            @Override
            public void run() {
                SysSecurityLog sysSecurityLog = LogFactory.createSysSecurityLog(LogType.BUSSINESS, user, bussinessName, className, methodName, msg, LogSucceed.SUCCESS.value(), info, type, levelEvent);
                try {
                    SysResourcesVo result = resourcesMapper.getResourceInfoByUrl(key);
                    if (ToolUtil.isNotEmpty((Object)result)) {
                        sysSecurityLog.setResourceId(result.getResourceId());
                        sysSecurityLog.setResourceAlias(result.getResourceAlias());
                        if ("1".equals(result.getIsAudit())) {
                            LogTaskFactory.insertSecurityLog(sysSecurityLog);
                        }
                    }
                }
                catch (Exception e) {
                    logger.error("\u521b\u5efa\u4e1a\u52a1\u65e5\u5fd7\u5f02\u5e38!", (Throwable)e);
                }
            }
        };
    }

    public static TimerTask exceptionLog(final ShiroUser user, final Exception exception, final Map<String, String> info) {
        return new TimerTask(){

            @Override
            public void run() {
                String msg = exception.getMessage();
                SysSecurityLog sysSecurityLog = LogFactory.createSysSecurityLog(LogType.EXCEPTION, user, "", (String)info.get("className"), (String)info.get("methodName"), msg, LogSucceed.FAIL.value(), info, "08", LevelEvent.SYSTEM.value());
                try {
                    LogTaskFactory.insertSecurityLog(sysSecurityLog);
                }
                catch (Exception e) {
                    logger.error("\u521b\u5efa\u5f02\u5e38\u65e5\u5fd7\u5f02\u5e38!", (Throwable)e);
                }
            }
        };
    }

    private static void insertSecurityLog(SysSecurityLog sysSecurityLog) {
        int old = hussarCacheManager.getObject("securitylog_count", "securitylog_count") == null ? 0 : (Integer)hussarCacheManager.getObject("securitylog_count", "securitylog_count");
        int now = old + 1;
        if (globalProperties.getSecuritylogCountAlert() != -1 && now >= globalProperties.getSecuritylogCountAlert()) {
            SysSecurityLogMailUtil.sendMail(now);
        }
        hussarCacheManager.setObject("securitylog_count", "securitylog_count", now);
        securityLogMapper.insert((Object)sysSecurityLog);
    }
}

