/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.intercept;

import com.jxdinfo.hussar.config.properties.GlobalProperties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
public class WebHandlerInterceptor
implements HandlerInterceptor {
    @Autowired
    private GlobalProperties global;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        String policy;
        String options = this.global.getxFrameOptions();
        if (options != null && ("SAMEORIGIN".equalsIgnoreCase(options.trim()) || "DENY".equalsIgnoreCase(options.trim()) || options.startsWith("ALLOW-FROM"))) {
            response.addHeader("X-Frame-Options", options);
        }
        if ((policy = this.global.getContentSecurityPolicy()) != null) {
            response.addHeader("Content-Security-Policy", policy);
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }
}

