/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.intercept;

import com.jxdinfo.hussar.core.shiro.ShiroKit;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.AccessControlFilter;
import org.apache.shiro.web.util.WebUtils;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@DependsOn(value={"springContextHolder"})
@Component
public class HussarUserFilter
extends AccessControlFilter {
    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        if (this.isLoginRequest(request, response)) {
            return true;
        }
        Subject subject = this.getSubject(request, response);
        return subject.getPrincipal() != null;
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        HttpServletRequest httpServletRequest = WebUtils.toHttp((ServletRequest)request);
        HttpServletResponse httpServletResponse = WebUtils.toHttp((ServletResponse)response);
        if (httpServletRequest.getHeader("x-requested-with") != null && "XMLHttpRequest".equalsIgnoreCase(httpServletRequest.getHeader("x-requested-with"))) {
            httpServletResponse.setHeader("sessionstatus", "timeout");
            return false;
        }
        String referer = httpServletRequest.getHeader("Referer");
        if (referer == null) {
            this.saveRequestAndRedirectToLogin(request, response);
            return false;
        }
        if (ShiroKit.getSession().getAttribute((Object)"sessionFlag") == null) {
            httpServletRequest.setAttribute("tips", (Object)"");
            httpServletRequest.getRequestDispatcher("/login.html").forward(request, response);
            return false;
        }
        this.saveRequestAndRedirectToLogin(request, response);
        return false;
    }
}

