/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.encrypt;

import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import com.jxdinfo.hussar.core.encrypt.AbstractCryptoProvider;
import com.jxdinfo.hussar.core.encrypt.condition.AESCondition;
import com.jxdinfo.hussar.core.util.AESEncrypUtil;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.HashMap;
import java.util.Map;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Repository;

@Repository
@Conditional(value={AESCondition.class})
@DependsOn(value={"springContextHolder"})
public class AESCryptoProvider
extends AbstractCryptoProvider {
    private final Integer RANDOM_SIZE = 16;
    private static HussarCacheManager hussarCacheManager = (HussarCacheManager)SpringContextHolder.getBean(HussarCacheManager.class);

    @Override
    public String encode(Map<String, String> dataMap) {
        if (!this.check(dataMap)) {
            return null;
        }
        String key = dataMap.get("key");
        String data = dataMap.get("data");
        return AESEncrypUtil.encrypt(key, data);
    }

    @Override
    public String decode(Map<String, String> dataMap) {
        if (!this.check(dataMap)) {
            return null;
        }
        String key = dataMap.get("key");
        String data = dataMap.get("data");
        return AESEncrypUtil.decrypt(key, data);
    }

    @Override
    public Map<String, String> getKeyMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        Object aesKey = hussarCacheManager.getObject("AES", "AES");
        if (aesKey == null) {
            aesKey = ToolUtil.getRandomString((int)this.RANDOM_SIZE);
            hussarCacheManager.setObject("AES", "AES", aesKey);
        }
        map.put("publicKey", (String)aesKey);
        map.put("privateKey", (String)aesKey);
        return map;
    }
}

