/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.cache;

import com.jxdinfo.hussar.core.cache.HussarCacheItem;
import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import com.jxdinfo.hussar.core.cache.condition.RedisCondition;
import com.jxdinfo.hussar.core.redis.service.RedisService;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Repository;

@Repository
@Conditional(value={RedisCondition.class})
public class HussarRedisCacheManager
implements HussarCacheManager {
    @Autowired
    private RedisService redisService;

    @Override
    public void setObject(String name, String key, Object obj) {
        this.redisService.setObject(key, obj);
    }

    @Override
    public Object getObject(String name, String key) {
        return this.redisService.getObject(key);
    }

    @Override
    public void delete(String name, String key) {
        this.redisService.delete(key);
    }

    @Override
    public void deleteMore(String name, String key) {
        this.redisService.deleteMoreByKeys(key);
    }

    @Override
    public List<Object> getKeys(String name, String key) {
        return this.redisService.getKeys(key);
    }

    @Override
    public List<Map<Object, Object>> getKeyAndValues(String name, String key) {
        return this.redisService.getKeyAndValues(key);
    }

    @Override
    public void refresh() {
        List<Map<Object, Object>> cache = this.getKeyAndValues("Anti-replay", "Anti-replay");
        if (cache == null) {
            return;
        }
        for (Map<Object, Object> map : cache) {
            if (map == null) continue;
            Object key = map.get("key");
            Object obj = map.get("value");
            if (!(obj instanceof HussarCacheItem)) continue;
            HussarCacheItem item = (HussarCacheItem)obj;
            long currentTime = System.currentTimeMillis();
            if (item.getCacheTime() <= 0L || currentTime - item.getCreateTime() <= item.getCacheTime()) continue;
            cache.remove(key);
        }
    }

    @Override
    public void setObject(String name, String key, Object obj, long cacheTime, TimeUnit unit) {
        HussarCacheItem cacheItem = new HussarCacheItem(unit.toMillis(cacheTime), System.currentTimeMillis(), obj);
        this.setObject("Anti-replay", key, cacheItem);
    }
}

