/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.cache;

import com.jxdinfo.hussar.core.cache.HussarCacheItem;
import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import com.jxdinfo.hussar.core.cache.condition.EhcacheCondition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.search.Attribute;
import net.sf.ehcache.search.Query;
import net.sf.ehcache.search.Result;
import net.sf.ehcache.search.Results;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.ehcache.EhCacheCacheManager;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Repository;

@Repository
@Conditional(value={EhcacheCondition.class})
public class HussarEhcacheManager
implements HussarCacheManager {
    @Autowired
    private org.springframework.cache.CacheManager ehCacheCacheManager;

    @Override
    public void setObject(String name, String key, Object obj) {
        CacheManager manager = this.getCacheManager();
        Ehcache cache = manager.getEhcache(name);
        if (cache == null) {
            manager.addCache(name);
        }
        manager.getEhcache(name).put(new Element((Object)key, obj));
    }

    @Override
    public Object getObject(String name, String key) {
        CacheManager manager = this.getCacheManager();
        Ehcache cache = manager.getEhcache(name);
        if (cache == null) {
            return null;
        }
        Element element = cache.get((Serializable)((Object)key));
        if (element == null) {
            return null;
        }
        return element.getObjectValue();
    }

    @Override
    public void delete(String name, String key) {
        CacheManager manager = this.getCacheManager();
        Ehcache cache = manager.getEhcache(name);
        if (cache != null) {
            cache.remove((Serializable)((Object)key));
        }
    }

    @Override
    public void deleteMore(String name, String key) {
        Ehcache cache = ((EhCacheCacheManager)this.ehCacheCacheManager).getCacheManager().getEhcache(name);
        Query query = cache.createQuery();
        query.includeKeys();
        query.includeValues();
        Attribute attribute = cache.getSearchAttribute("key");
        query.addCriteria(attribute.ilike("*" + key + "*"));
        Results results = query.execute();
        for (Result r : results.all()) {
            cache.remove(r.getKey());
        }
    }

    @Override
    public List<Object> getKeys(String name, String key) {
        ArrayList<Object> list = new ArrayList<Object>();
        Ehcache cache = ((EhCacheCacheManager)this.ehCacheCacheManager).getCacheManager().getEhcache(name);
        Query query = cache.createQuery();
        query.includeKeys();
        query.includeValues();
        Attribute attribute = cache.getSearchAttribute("key");
        query.addCriteria(attribute.ilike("*" + key + "*"));
        Results results = query.execute();
        for (Result r : results.all()) {
            list.add(r.getKey());
        }
        return list;
    }

    @Override
    public List<Map<Object, Object>> getKeyAndValues(String name, String key) {
        ArrayList<Map<Object, Object>> returnValue = new ArrayList<Map<Object, Object>>();
        Ehcache cache = ((EhCacheCacheManager)this.ehCacheCacheManager).getCacheManager().getEhcache(name);
        Query query = cache.createQuery();
        query.includeKeys();
        query.includeValues();
        Attribute attribute = cache.getSearchAttribute("key");
        query.addCriteria(attribute.ilike("*" + key + "*"));
        Results results = query.execute();
        HashMap<String, Object> tmp = null;
        for (Result r : results.all()) {
            tmp = new HashMap<String, Object>(2);
            tmp.put("value", r.getValue());
            tmp.put("key", r.getKey());
            returnValue.add(tmp);
        }
        return returnValue;
    }

    public Collection<String> getCacheNames() {
        return this.ehCacheCacheManager.getCacheNames();
    }

    public List<Result> getEhCaches(String cacheName, String key) {
        Ehcache cache = ((EhCacheCacheManager)this.ehCacheCacheManager).getCacheManager().getEhcache(cacheName);
        Query query = cache.createQuery();
        query.includeKeys();
        query.includeValues();
        Attribute attribute = cache.getSearchAttribute("key");
        query.addCriteria(attribute.ilike("*" + key + "*"));
        Results results = query.execute();
        List r = results.all();
        List list = ((EhCacheCacheManager)this.ehCacheCacheManager).getCacheManager().getEhcache(cacheName).getKeys();
        return results.all();
    }

    public void delcache(String cacheName, List keys) {
        Ehcache cache = ((EhCacheCacheManager)this.ehCacheCacheManager).getCacheManager().getEhcache(cacheName);
        if (cache != null) {
            cache.removeAll((Collection)keys);
        }
    }

    private CacheManager getCacheManager() {
        return ((EhCacheCacheManager)this.ehCacheCacheManager).getCacheManager();
    }

    @Override
    public void refresh() {
        CacheManager manager = this.getCacheManager();
        Ehcache cache = manager.getEhcache("Anti-replay");
        if (cache == null) {
            return;
        }
        for (Object key : cache.getKeys()) {
            Object obj;
            Element element = cache.get(key);
            if (element == null || !((obj = element.getObjectValue()) instanceof HussarCacheItem)) continue;
            HussarCacheItem item = (HussarCacheItem)obj;
            long currentTime = System.currentTimeMillis();
            if (item.getCacheTime() <= 0L || currentTime - item.getCreateTime() <= item.getCacheTime()) continue;
            cache.remove(key);
        }
    }

    @Override
    public void setObject(String name, String key, Object obj, long cacheTime, TimeUnit unit) {
        HussarCacheItem cacheItem = new HussarCacheItem(unit.toMillis(cacheTime), System.currentTimeMillis(), obj);
        this.setObject("Anti-replay", key, cacheItem);
    }
}

