/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.cache;

import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.cache.HussarCache;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Component
public class HussarCacheRunner
implements CommandLineRunner {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private List<HussarCache> hussarCaches;
    @Autowired
    private GlobalProperties global;

    public void run(String ... args) throws Exception {
        if (this.global.getAntiReplayTimeout() > 0L) {
            Timer timer = new Timer();
            timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    if (HussarCacheRunner.this.hussarCaches != null && !HussarCacheRunner.this.hussarCaches.isEmpty()) {
                        for (HussarCache cache : HussarCacheRunner.this.hussarCaches) {
                            try {
                                cache.refresh();
                            }
                            catch (Exception e) {
                                HussarCacheRunner.this.logger.error("\u672c\u5730\u7f13\u5b58\u66f4\u65b0\u5f02\u5e38", (Throwable)e);
                            }
                        }
                    }
                }
            }, 0L, (long)this.global.getAntiReplayTimeout());
        }
    }
}

