/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.beetl;

import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.isc.util.IscUtil;
import io.buji.pac4j.subject.Pac4jPrincipal;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;

public class ShiroExt {
    private static final String NAMES_DELIMETER = ",";

    protected static Subject getSubject() {
        return SecurityUtils.getSubject();
    }

    public ShiroUser getUser() {
        if (this.isGuest()) {
            return null;
        }
        Object principal = ShiroExt.getSubject().getPrincipals().getPrimaryPrincipal();
        if (principal instanceof ShiroUser) {
            return (ShiroUser)principal;
        }
        return IscUtil.getShiroUserFromPac4jPrincipal((Pac4jPrincipal)principal);
    }

    public boolean hasRole(String roleName) {
        return ShiroExt.getSubject() != null && roleName != null && roleName.length() > 0 && ShiroExt.getSubject().hasRole(roleName);
    }

    public boolean lacksRole(String roleName) {
        return !this.hasRole(roleName);
    }

    public boolean hasAnyRoles(String roleNames) {
        boolean hasAnyRole = false;
        Subject subject = ShiroExt.getSubject();
        if (subject != null && roleNames != null && roleNames.length() > 0) {
            for (String role : roleNames.split(NAMES_DELIMETER)) {
                if (!subject.hasRole(role.trim())) continue;
                hasAnyRole = true;
                break;
            }
        }
        return hasAnyRole;
    }

    public boolean hasAllRoles(String roleNames) {
        boolean hasAllRole = true;
        Subject subject = ShiroExt.getSubject();
        if (subject != null && roleNames != null && roleNames.length() > 0) {
            for (String role : roleNames.split(NAMES_DELIMETER)) {
                if (subject.hasRole(role.trim())) continue;
                hasAllRole = false;
                break;
            }
        }
        return hasAllRole;
    }

    public boolean hasPermission(String permission) {
        return ShiroExt.getSubject() != null && permission != null && permission.length() > 0 && ShiroExt.getSubject().isPermitted(permission);
    }

    public boolean lacksPermission(String permission) {
        return !this.hasPermission(permission);
    }

    public boolean authenticated() {
        return ShiroExt.getSubject() != null && ShiroExt.getSubject().isAuthenticated();
    }

    public boolean notAuthenticated() {
        return !this.authenticated();
    }

    public boolean isUser() {
        return ShiroExt.getSubject() != null && ShiroExt.getSubject().getPrincipal() != null;
    }

    public boolean isGuest() {
        return !this.isUser();
    }

    public String principal() {
        if (ShiroExt.getSubject() != null) {
            Object principal = ShiroExt.getSubject().getPrincipal();
            return principal.toString();
        }
        return "";
    }

    public static boolean isGradeadmin() {
        ShiroUser shiroUser = ShiroKit.getUser();
        return shiroUser.isGradeadmin();
    }
}

