/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.core.beetl;

import com.jxdinfo.hussar.common.dicutil.DictionaryUtil;
import com.jxdinfo.hussar.core.sys.vo.DicVo;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.beetl.core.GeneralVarTagBinding;
import org.springframework.context.annotation.DependsOn;

@DependsOn(value={"springContextHolder"})
public class CheckboxTag
extends GeneralVarTagBinding {
    private String name;
    private String clas;
    private String style;
    private String dicType;
    private String[] disabled;
    private String[] checked;
    private String onlyShow;
    private String notShow;
    private List<DicVo> option = new ArrayList<DicVo>();
    DictionaryUtil dictionaryUtil = (DictionaryUtil)SpringContextHolder.getBean(DictionaryUtil.class);
    private String laySkin;
    private String layText;
    private boolean layIgnore;
    private String layFilter;
    private String layVerify;
    private String layVerType;
    private boolean laySubmit;

    public void init() {
        this.name = (String)this.getAttributeValue("name");
        this.clas = (String)this.getAttributeValue("class");
        this.style = (String)this.getAttributeValue("style");
        this.dicType = (String)this.getAttributeValue("dicType");
        if (ToolUtil.isNotEmpty((Object)this.getAttributeValue("disabled"))) {
            this.disabled = ((String)this.getAttributeValue("disabled")).split("-");
        }
        if (ToolUtil.isNotEmpty((Object)this.getAttributeValue("checked"))) {
            this.checked = ((String)this.getAttributeValue("checked")).split("-");
        }
        this.onlyShow = (String)this.getAttributeValue("onlyShow");
        this.notShow = (String)this.getAttributeValue("notShow");
        this.option = ToolUtil.isNotEmpty((Object)this.onlyShow) ? this.dictionaryUtil.getCertainDictOptions(this.dicType, this.onlyShow.split("-")) : (ToolUtil.isNotEmpty((Object)this.notShow) ? this.dictionaryUtil.getDictOptionsWithoutNotShows(this.dicType, this.notShow.split("-")) : this.dictionaryUtil.getDictListByType(this.dicType));
        this.laySkin = (String)this.getAttributeValue("laySkin");
        this.layText = (String)this.getAttributeValue("layText");
        this.layFilter = (String)this.getAttributeValue("layFilter");
        this.layVerify = (String)this.getAttributeValue("layVerify");
        this.layVerType = (String)this.getAttributeValue("layVerType");
        this.laySubmit = Boolean.parseBoolean((String)this.getAttributeValue("laySubmit"));
        this.layIgnore = Boolean.parseBoolean((String)this.getAttributeValue("layIgnore"));
    }

    public void render() {
        this.init();
        StringBuilder checkbox = new StringBuilder("");
        for (DicVo dicVo : this.option) {
            checkbox.append("<input type=\"checkbox\"");
            checkbox.append(" value=\"").append(dicVo.getValue()).append("\"");
            checkbox.append(" title=\"").append(dicVo.getLabel()).append("\"");
            if (ToolUtil.isNotEmpty((Object)this.name)) {
                checkbox.append(" name=\"").append(this.name).append("\"");
            }
            if (ToolUtil.isNotEmpty((Object)this.clas)) {
                checkbox.append(" class=\"").append(this.clas).append("\"");
            }
            if (ToolUtil.isNotEmpty((Object)this.style)) {
                checkbox.append(" style=\"").append(this.style).append("\"");
            }
            if (this.arrayContain(this.disabled, dicVo.getValue())) {
                checkbox.append(" disabled");
            }
            if (this.arrayContain(this.checked, dicVo.getValue())) {
                checkbox.append(" checked");
            }
            if (ToolUtil.isNotEmpty((Object)this.laySkin)) {
                checkbox.append(" lay-skin=\"").append(this.laySkin).append("\"");
            }
            if (ToolUtil.isNotEmpty((Object)this.layText)) {
                checkbox.append(" lay-text=\"").append(this.layText).append("\"");
            }
            if (ToolUtil.isNotEmpty((Object)this.layFilter)) {
                checkbox.append(" lay-filter=\"").append(this.layFilter).append("\"");
            }
            if (ToolUtil.isNotEmpty((Object)this.layVerify)) {
                checkbox.append(" lay-verify=\"").append(this.layVerify).append("\"");
            }
            if (ToolUtil.isNotEmpty((Object)this.layVerType)) {
                checkbox.append(" lay-verType=\"").append(this.layVerType).append("\"");
            }
            if (this.laySubmit) {
                checkbox.append(" lay-submit");
            }
            if (this.layIgnore) {
                checkbox.append(" lay-ignore");
            }
            checkbox.append(">");
        }
        try {
            this.doBodyRender();
            this.ctx.byteWriter.writeString(checkbox.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean arrayContain(String[] array, String param) {
        boolean flag = false;
        if (ToolUtil.isEmpty((Object)array)) {
            return flag;
        }
        for (String s : array) {
            if (!param.equals(s)) continue;
            flag = true;
            break;
        }
        return flag;
    }
}

