/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.config.web;

import com.jxdinfo.hussar.config.cas.ShiroCasConfiguration;
import com.jxdinfo.hussar.config.cas.ShiroCasLogoutHandler;
import com.jxdinfo.hussar.config.cas.util.CasShiroSessionStore;
import com.jxdinfo.hussar.config.front.config.CustomAjaxRequestResolver;
import com.jxdinfo.hussar.isc.conf.ShiroIscConfiguration;
import com.jxdinfo.hussar.isc.listener.AdapterFactoryListener;
import com.jxdinfo.hussar.isc.session.SingleSignOutFilter;
import com.jxdinfo.hussar.isc.util.CasClient;
import io.buji.pac4j.context.ShiroSessionStore;
import java.util.EventListener;
import javax.servlet.Filter;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.cas.config.CasProtocol;
import org.pac4j.core.client.Client;
import org.pac4j.core.config.Config;
import org.pac4j.core.context.session.SessionStore;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletListenerRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class ShiroPac4jConfig {
    @Autowired
    private ShiroIscConfiguration iscConf;
    @Autowired
    private ShiroCasConfiguration casConf;

    @Bean(value={"authcConfig2"})
    @ConditionalOnProperty(prefix="cas", name={"active-type"}, havingValue="ISC", matchIfMissing=true)
    public Config config2(CasClient casClient, ShiroSessionStore shiroSessionStore) {
        Config config = new Config((Client)casClient);
        config.setSessionStore((SessionStore)shiroSessionStore);
        return config;
    }

    @Bean(value={"authcConfig"})
    @ConditionalOnProperty(prefix="cas", name={"active-type"}, havingValue="CASClient", matchIfMissing=false)
    public Config config(CasClient casClient, CasShiroSessionStore casShiroSessionStore) {
        Config config = new Config((Client)casClient);
        config.setSessionStore((SessionStore)casShiroSessionStore);
        return config;
    }

    @Bean(value={"authcConfig3"})
    @ConditionalOnProperty(prefix="cas", name={"active-type"}, havingValue="CASServer", matchIfMissing=false)
    public Config config3(CasClient casClient, CasShiroSessionStore casShiroSessionStore) {
        Config config = new Config((Client)casClient);
        config.setSessionStore((SessionStore)casShiroSessionStore);
        return config;
    }

    @Bean
    public ShiroSessionStore shiroSessionStore() {
        return new ShiroSessionStore();
    }

    @Bean
    public CasShiroSessionStore casShiroSessionStore() {
        return new CasShiroSessionStore();
    }

    @Bean
    public CasShiroSessionStore shiroSessionStoreCas() {
        return new CasShiroSessionStore();
    }

    @Bean
    public CasClient casClient(CasConfiguration casConfig) {
        CasClient casClient = new CasClient(casConfig);
        if (this.casConf.isActive()) {
            casClient.setCallbackUrl(this.casConf.getLocalUrl() + "/callback?client_name=" + this.casConf.getClientName());
            casClient.setName(this.casConf.getClientName());
            casClient.setAjaxRequestResolver(new CustomAjaxRequestResolver());
        } else {
            casClient.setCallbackUrl(this.iscConf.getLocalUrl() + "/callback?client_name=" + this.iscConf.getClientName());
            casClient.setName(this.iscConf.getClientName());
        }
        return casClient;
    }

    @Bean
    public CasConfiguration casConfig() {
        CasConfiguration configuration = new CasConfiguration();
        if (this.casConf.isActive()) {
            configuration.setLoginUrl(this.casConf.getServerLoginUrl());
            configuration.setProtocol(CasProtocol.CAS30);
            configuration.setAcceptAnyProxy(true);
            configuration.setPrefixUrl(this.casConf.getServerUrlPrefix());
            ShiroCasLogoutHandler shiroCasLogoutHandler = new ShiroCasLogoutHandler();
            shiroCasLogoutHandler.setDestroySession(true);
            configuration.setLogoutHandler(shiroCasLogoutHandler);
        } else {
            configuration.setLoginUrl(this.iscConf.getServerLoginUrl());
            configuration.setProtocol(CasProtocol.CAS20);
            configuration.setAcceptAnyProxy(true);
            configuration.setPrefixUrl(this.iscConf.getServerUrlPrefix());
        }
        return configuration;
    }

    @Bean
    public ServletListenerRegistrationBean<AdapterFactoryListener> adapterFactoryListenerRegistration() {
        return new ServletListenerRegistrationBean((EventListener)((Object)new AdapterFactoryListener()));
    }

    @Bean
    @ConditionalOnProperty(prefix="cas", name={"active-type"}, havingValue="ISC", matchIfMissing=false)
    public FilterRegistrationBean<SingleSignOutFilter> SingleSignOutFilter() {
        SingleSignOutFilter singleSignOutFilter = new SingleSignOutFilter();
        FilterRegistrationBean registration = new FilterRegistrationBean((Filter)singleSignOutFilter, new ServletRegistrationBean[0]);
        registration.addUrlPatterns(new String[]{"/*"});
        return registration;
    }
}

