/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.config.web;

import com.jxdinfo.hussar.config.properties.HussarProperties;
import javax.annotation.Resource;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.cache.ehcache.EhCacheCacheManager;
import org.springframework.cache.ehcache.EhCacheManagerFactoryBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@Configuration
@EnableCaching
public class HussarCacheConfig {
    @Resource
    private HussarProperties hussarProperties;

    @Bean
    @ConditionalOnProperty(prefix="hussar", name={"stand-alone"}, havingValue="false", matchIfMissing=false)
    public CacheManager redisCacheManager(RedisConnectionFactory factory, RedisCacheConfiguration redisCacheConfiguration) {
        RedisCacheManager cacheManager = null;
        cacheManager = RedisCacheManager.builder((RedisConnectionFactory)factory).cacheDefaults(redisCacheConfiguration).build();
        return cacheManager;
    }

    @Bean
    @ConditionalOnProperty(prefix="hussar", name={"stand-alone"}, havingValue="true", matchIfMissing=true)
    public CacheManager ehCacheManager(EhCacheManagerFactoryBean ehCacheManagerFactoryBean) {
        EhCacheCacheManager cacheManager = null;
        cacheManager = new EhCacheCacheManager(ehCacheManagerFactoryBean.getObject());
        return cacheManager;
    }
}

