/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.config.properties;

import org.apache.commons.lang.StringUtils;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="global")
public class GlobalProperties {
    public static final String Global_PREFIX = "global";
    private String title = "HussarV8";
    private String defaultPassword = "123456";
    private String pwdComplexityRegular = "/^[\\S]{6,12}$/ ";
    private String unmatchedHint = "\u5bc6\u7801\u5fc5\u987b6\u523012\u4f4d\uff0c\u4e14\u4e0d\u80fd\u51fa\u73b0\u7a7a\u683c";
    private boolean forceChangePwd = true;
    private long passwordHist = 90L;
    private int pwdRepeatTime = 2;
    private int tryLoginTime = 3;
    private int lockTime = 1;
    private boolean sessionLimit = true;
    private boolean kickoutAfter = true;
    private String defaultTheme = "default";
    private boolean changeTheme = true;
    private boolean criticalOperationsAudit = false;
    private boolean organAudit = false;
    private boolean userAudit = false;
    private boolean roleAudit = false;
    private boolean struAudit = false;
    private boolean treeLazyLoad = true;
    private boolean userOnOneEmp = false;
    private boolean operateStaffWithUser = false;
    private boolean tabSwitchover = true;
    private String pwdRule = "8,16,1";
    private String pwdRuleMessage = "\u5bc6\u7801\u6700\u5c0f\u4e0d\u80fd\u5c0f\u4e8e%s\u4f4d\uff0c\u6700\u5927\u4e0d\u80fd\u5927\u4e8e%s\u4f4d\uff0c\u5f3a\u5ea6\u9700\u9ad8\u4e8e\u7ea7\u522b%s\u8981\u6c42!";
    private boolean pwdRuleCustom = false;
    private boolean first = true;
    private Boolean loginTimeLimit = false;
    private Boolean loginIpLimit = false;
    private Boolean createUserSendEmail = false;
    private String domain = "HUSSAR_V8";
    private Boolean createUserUseDefaultPass = true;
    private Long systemMaxSession = 1000000L;
    private Long antiReplayTimeout = -1L;
    private boolean encryptSignOpen = false;
    private boolean exceptionAlert = false;
    private String exceptionAlertEmail;
    private int securitylogCountAlert = -1;
    private String antiReplayScanPackage;
    private String xFrameOptions = "SAMEORIGIN";
    private String contentSecurityPolicy = "object-src 'none';";
    private String syncUrl;
    private String syncTokenKey;

    public Long getAntiReplayTimeout() {
        return this.antiReplayTimeout;
    }

    public void setAntiReplayTimeout(Long antiReplayTimeout) {
        this.antiReplayTimeout = antiReplayTimeout;
    }

    public boolean isFirst() {
        return this.first;
    }

    public void setFirst(boolean first) {
        this.first = first;
    }

    public int getLockTime() {
        return this.lockTime;
    }

    public void setLockTime(int lockTime) {
        this.lockTime = lockTime;
    }

    public boolean isSessionLimit() {
        return this.sessionLimit;
    }

    public void setSessionLimit(boolean sessionLimit) {
        this.sessionLimit = sessionLimit;
    }

    public int getTryLoginTime() {
        return this.tryLoginTime;
    }

    public void setTryLoginTime(int tryLoginTime) {
        this.tryLoginTime = tryLoginTime;
    }

    public boolean isKickoutAfter() {
        return this.kickoutAfter;
    }

    public void setKickoutAfter(boolean kickoutAfter) {
        this.kickoutAfter = kickoutAfter;
    }

    public int getPwdRepeatTime() {
        return this.pwdRepeatTime;
    }

    public void setPwdRepeatTime(int pwdRepeatTime) {
        this.pwdRepeatTime = pwdRepeatTime;
    }

    public long getPasswordHist() {
        return this.passwordHist;
    }

    public void setPasswordHist(long passwordHist) {
        this.passwordHist = passwordHist;
    }

    public String getDefaultPassword() {
        return this.defaultPassword;
    }

    public void setDefaultPassword(String defaultPassword) {
        this.defaultPassword = defaultPassword;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDefaultTheme() {
        return this.defaultTheme;
    }

    public void setDefaultTheme(String defaultTheme) {
        this.defaultTheme = defaultTheme;
    }

    public boolean isChangeTheme() {
        return this.changeTheme;
    }

    public void setChangeTheme(boolean changeTheme) {
        this.changeTheme = changeTheme;
    }

    public boolean isForceChangePwd() {
        return this.forceChangePwd;
    }

    public void setForceChangePwd(boolean forceChangePwd) {
        this.forceChangePwd = forceChangePwd;
    }

    public boolean isCriticalOperationsAudit() {
        return this.criticalOperationsAudit;
    }

    public void setCriticalOperationsAudit(boolean criticalOperationsAudit) {
        this.criticalOperationsAudit = criticalOperationsAudit;
    }

    public boolean isOrganAudit() {
        return this.organAudit;
    }

    public void setOrganAudit(boolean organAudit) {
        this.organAudit = organAudit;
    }

    public boolean isUserAudit() {
        return this.userAudit;
    }

    public void setUserAudit(boolean userAudit) {
        this.userAudit = userAudit;
    }

    public boolean isRoleAudit() {
        return this.roleAudit;
    }

    public void setRoleAudit(boolean roleAudit) {
        this.roleAudit = roleAudit;
    }

    public boolean isStruAudit() {
        return this.struAudit;
    }

    public void setStruAudit(boolean struAudit) {
        this.struAudit = struAudit;
    }

    public boolean isTreeLazyLoad() {
        return this.treeLazyLoad;
    }

    public void setTreeLazyLoad(boolean treeLazyLoad) {
        this.treeLazyLoad = treeLazyLoad;
    }

    public String getPwdComplexityRegular() {
        this.setRule();
        return this.pwdComplexityRegular;
    }

    public void setPwdComplexityRegular(String pwdComplexityRegular) {
        this.pwdComplexityRegular = pwdComplexityRegular;
    }

    public Boolean getLoginTimeLimit() {
        return this.loginTimeLimit;
    }

    public void setLoginTimeLimit(Boolean loginTimeLimit) {
        this.loginTimeLimit = loginTimeLimit;
    }

    public Boolean getLoginIpLimit() {
        return this.loginIpLimit;
    }

    public void setLoginIpLimit(Boolean loginIpLimit) {
        this.loginIpLimit = loginIpLimit;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public boolean isTabSwitchover() {
        return this.tabSwitchover;
    }

    public void setTabSwitchover(boolean tabSwitchover) {
        this.tabSwitchover = tabSwitchover;
    }

    public Boolean getCreateUserSendEmail() {
        return this.createUserSendEmail;
    }

    public void setCreateUserSendEmail(Boolean createUserSendEmail) {
        this.createUserSendEmail = createUserSendEmail;
    }

    public Boolean getCreateUserUseDefaultPass() {
        return this.createUserUseDefaultPass;
    }

    public void setCreateUserUseDefaultPass(Boolean createUserUseDefaultPass) {
        this.createUserUseDefaultPass = createUserUseDefaultPass;
    }

    public String getUnmatchedHint() {
        this.setRule();
        return this.unmatchedHint;
    }

    public void setUnmatchedHint(String unmatchedHint) {
        this.unmatchedHint = unmatchedHint;
    }

    public boolean isUserOnOneEmp() {
        return this.userOnOneEmp;
    }

    public void setUserOnOneEmp(boolean userOnOneEmp) {
        this.userOnOneEmp = userOnOneEmp;
    }

    public boolean isOperateStaffWithUser() {
        return this.operateStaffWithUser;
    }

    public void setOperateStaffWithUser(boolean operateStaffWithUser) {
        this.operateStaffWithUser = operateStaffWithUser;
    }

    public String getPwdRule() {
        this.setRule();
        return this.pwdRule;
    }

    public void setPwdRule(String pwdRule) {
        this.pwdRule = pwdRule;
    }

    private void setRule() {
        if (!this.isPwdRuleCustom() && this.first) {
            this.first = !this.first;
            Object[] regArray = this.pwdRule.split(",");
            if (regArray.length != 3) {
                this.pwdRule = "8,16,1";
                regArray = this.pwdRule.split(",");
            }
            String minLength = regArray[0];
            String maxLength = regArray[1];
            String level = regArray[2];
            int minInt = 4;
            int maxInt = 16;
            int levelInt = 1;
            if (StringUtils.isNumeric((String)minLength) && StringUtils.isNumeric((String)maxLength) && StringUtils.isNumeric((String)level)) {
                minInt = Integer.parseInt(minLength);
                maxInt = Integer.parseInt(maxLength);
                levelInt = Integer.parseInt(level);
            }
            String regex = "^[A-Z]{%d,%d}$|^[a-z]{%d,%d}$|^[0-9]{%d,%d}$|^[\\W_]{%d,%d}$";
            switch (levelInt) {
                case 1: {
                    regex = new StringBuffer("^[A-Z]{%d,%d}$|^[a-z]{%d,%d}$|^[0-9]{%d,%d}$|^[\\W_]{%d,%d}$").append("|").append("^(?!\\d+$)(?![\\W_]+$)[\\d\\W_]{%d,%d}$|^(?!\\d+$)(?![a-z]+$)[\\da-z]{%d,%d}$|^(?!\\d+$)(?![A-Z]+$)[\\dA-Z]{%d,%d}$|^(?![a-z]+$)(?![A-Z]+$)[a-zA-Z]{%d,%d}$|^(?![a-z]+$)(?![\\W_]+$)[a-z\\W]{%d,%d}$|^(?![A-Z]+$)(?![\\W_]+$)[A-Z\\W]{%d,%d}$").append("|").append("^(?=.*[0-9])(?=.*[a-z])(?=.*[\\W_]).{%d,%d}$|^(?=.*[0-9])(?=.*[A-Z])(?=.*[\\W_]).{%d,%d}$|^(?=.*[a-z])(?=.*[A-Z])(?=.*[\\W_]).{%d,%d}$|^(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9]).{%d,%d}$").toString();
                    this.pwdRuleMessage = new StringBuffer(this.pwdRuleMessage).append(" <br>\u7ea7\u522b1\uff1a\u5bc6\u7801\u53ea\u7531\u6570\u5b57\u3001\u5c0f\u5199\u5b57\u6bcd\u3001\u5927\u5199\u5b57\u6bcd\u6216\u5176\u5b83\u7279\u6b8a\u7b26\u53f7\u5f53\u4e2d\u7684\u4e00\u79cd\u7ec4\u6210\u3002").toString();
                    break;
                }
                case 2: {
                    regex = new StringBuffer("^(?!\\d+$)(?![\\W_]+$)[\\d\\W_]{%d,%d}$|^(?!\\d+$)(?![a-z]+$)[\\da-z]{%d,%d}$|^(?!\\d+$)(?![A-Z]+$)[\\dA-Z]{%d,%d}$|^(?![a-z]+$)(?![A-Z]+$)[a-zA-Z]{%d,%d}$|^(?![a-z]+$)(?![\\W_]+$)[a-z\\W]{%d,%d}$|^(?![A-Z]+$)(?![\\W_]+$)[A-Z\\W]{%d,%d}$").append("|").append("^(?=.*[0-9])(?=.*[a-z])(?=.*[\\W_]).{%d,%d}$|^(?=.*[0-9])(?=.*[A-Z])(?=.*[\\W_]).{%d,%d}$|^(?=.*[a-z])(?=.*[A-Z])(?=.*[\\W_]).{%d,%d}$|^(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9]).{%d,%d}$").toString();
                    this.pwdRuleMessage = new StringBuffer(this.pwdRuleMessage).append(" <br>\u7ea7\u522b2\uff1a\u5bc6\u7801\u7531\u6570\u5b57\u3001\u5c0f\u5199\u5b57\u6bcd\u3001\u5927\u5199\u5b57\u6bcd\u6216\u5176\u5b83\u7279\u6b8a\u7b26\u53f7\u5f53\u4e2d\u7684\u4e24\u79cd\u7ec4\u6210\u3002").toString();
                    break;
                }
                case 3: {
                    regex = "^(?=.*[0-9])(?=.*[a-z])(?=.*[\\W_]).{%d,%d}$|^(?=.*[0-9])(?=.*[A-Z])(?=.*[\\W_]).{%d,%d}$|^(?=.*[a-z])(?=.*[A-Z])(?=.*[\\W_]).{%d,%d}$|^(?=.*[a-z])(?=.*[A-Z])(?=.*[0-9]).{%d,%d}$";
                    this.pwdRuleMessage = new StringBuffer(this.pwdRuleMessage).append(" <br>\u7ea7\u522b3\uff1a\u5bc6\u7801\u7531\u6570\u5b57\u3001\u5c0f\u5199\u5b57\u6bcd\u3001\u5927\u5199\u5b57\u6bcd\u6216\u5176\u5b83\u7279\u6b8a\u7b26\u53f7\u5f53\u4e2d\u7684\u4e09\u79cd\u4ee5\u4e0a\u7ec4\u6210\u3002").toString();
                }
            }
            Object[] args = new Object[28];
            for (int i = 0; i < args.length; ++i) {
                args[i] = i % 2 == 0 ? Integer.valueOf(minInt) : Integer.valueOf(maxInt);
            }
            regex = String.format(regex, args);
            regex = new StringBuffer("/").append(regex).append("/").toString();
            String message = String.format(this.pwdRuleMessage, regArray);
            this.setPwdComplexityRegular(regex);
            this.setUnmatchedHint(message);
        }
    }

    public String getPwdRuleMessage() {
        this.setRule();
        return this.pwdRuleMessage;
    }

    public void setPwdRuleMessage(String pwdRuleMessage) {
        this.pwdRuleMessage = pwdRuleMessage;
    }

    public boolean isPwdRuleCustom() {
        return this.pwdRuleCustom;
    }

    public void setPwdRuleCustom(boolean pwdRuleCustom) {
        this.pwdRuleCustom = pwdRuleCustom;
    }

    public Long getSystemMaxSession() {
        return this.systemMaxSession;
    }

    public void setSystemMaxSession(Long systemMaxSession) {
        this.systemMaxSession = systemMaxSession;
    }

    public boolean isEncryptSignOpen() {
        return this.encryptSignOpen;
    }

    public void setEncryptSignOpen(boolean encryptSignOpen) {
        this.encryptSignOpen = encryptSignOpen;
    }

    public boolean isExceptionAlert() {
        return this.exceptionAlert;
    }

    public void setExceptionAlert(boolean exceptionAlert) {
        this.exceptionAlert = exceptionAlert;
    }

    public String getExceptionAlertEmail() {
        return this.exceptionAlertEmail;
    }

    public void setExceptionAlertEmail(String exceptionAlertEmail) {
        this.exceptionAlertEmail = exceptionAlertEmail;
    }

    public int getSecuritylogCountAlert() {
        return this.securitylogCountAlert;
    }

    public void setSecuritylogCountAlert(int securitylogCountAlert) {
        this.securitylogCountAlert = securitylogCountAlert;
    }

    public String getAntiReplayScanPackage() {
        return this.antiReplayScanPackage;
    }

    public void setAntiReplayScanPackage(String antiReplayScanPackage) {
        this.antiReplayScanPackage = antiReplayScanPackage;
    }

    public String getxFrameOptions() {
        return this.xFrameOptions;
    }

    public void setxFrameOptions(String xFrameOptions) {
        this.xFrameOptions = xFrameOptions;
    }

    public String getContentSecurityPolicy() {
        return this.contentSecurityPolicy;
    }

    public void setContentSecurityPolicy(String contentSecurityPolicy) {
        this.contentSecurityPolicy = contentSecurityPolicy;
    }

    public String getSyncUrl() {
        return this.syncUrl;
    }

    public void setSyncUrl(String syncUrl) {
        this.syncUrl = syncUrl;
    }

    public String getSyncTokenKey() {
        return this.syncTokenKey;
    }

    public void setSyncTokenKey(String syncTokenKey) {
        this.syncTokenKey = syncTokenKey;
    }
}

