/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.config.cas.util;

import com.jxdinfo.hussar.config.cas.util.CasShiroProvidedSessionStore;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.UnavailableSecurityManagerException;
import org.apache.shiro.session.Session;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.session.SessionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CasShiroSessionStore
implements SessionStore<J2EContext> {
    private static final Logger logger = LoggerFactory.getLogger(CasShiroSessionStore.class);

    protected Session getSession(boolean createSession) {
        return SecurityUtils.getSubject().getSession(createSession);
    }

    public String getOrCreateSessionId(J2EContext context) {
        Session session = this.getSession(false);
        if (session != null) {
            return session.getId().toString();
        }
        return null;
    }

    public Object get(J2EContext context, String key) {
        Session session = this.getSession(false);
        if (session != null) {
            return session.getAttribute((Object)key);
        }
        return null;
    }

    public void set(J2EContext context, String key, Object value) {
        Session session = this.getSession(true);
        if (session != null) {
            try {
                session.setAttribute((Object)key, value);
            }
            catch (UnavailableSecurityManagerException e) {
                logger.warn("Should happen just once at startup in some specific case of Shiro Spring configuration", (Throwable)e);
            }
        }
    }

    public boolean destroySession(J2EContext context) {
        try {
            this.getSession(true).stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public Object getTrackableSession(J2EContext context) {
        return this.getSession(true);
    }

    public SessionStore<J2EContext> buildFromTrackableSession(J2EContext context, Object trackableSession) {
        if (trackableSession != null) {
            return new CasShiroProvidedSessionStore((Session)trackableSession);
        }
        return null;
    }

    public boolean renewSession(J2EContext context) {
        return false;
    }
}

