/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.config;

import com.baomidou.mybatisplus.extension.plugins.OptimisticLockerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.PaginationInterceptor;
import com.jxdinfo.hussar.core.datascope.DataScopeInterceptor;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.annotation.EnableTransactionManagement;

@Configuration
@EnableTransactionManagement(order=2)
public class MybatisPlusConfig {
    @Bean
    public PaginationInterceptor paginationInterceptor(DataSource dataSource) throws SQLException {
        PaginationInterceptor inter = new PaginationInterceptor();
        Connection connection = dataSource.getConnection();
        String url = connection.getMetaData().getURL();
        String driverClassName = connection.getMetaData().getDriverName();
        connection.close();
        if (url.startsWith("jdbc:oscar")) {
            inter.setDialectClazz("com.baomidou.mybatisplus.extension.plugins.pagination.dialects.OracleDialect");
        }
        if (url.startsWith("jdbc:highgo")) {
            inter.setDialectClazz("com.jxdinfo.hussar.pagination.dialects.HighGoDialect");
        }
        return inter;
    }

    @Bean
    public DataScopeInterceptor dataScopeInterceptor() {
        return new DataScopeInterceptor();
    }

    @Bean
    public OptimisticLockerInterceptor optimisticLockerInterceptor() {
        return new OptimisticLockerInterceptor();
    }
}

