/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.organutil;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.bsp.organ.dao.SysOrganMapper;
import com.jxdinfo.hussar.bsp.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.bsp.organ.model.SysOrgan;
import com.jxdinfo.hussar.bsp.organ.model.SysOrganType;
import com.jxdinfo.hussar.bsp.organ.model.SysStru;
import com.jxdinfo.hussar.bsp.organ.model.SysStruRule;
import com.jxdinfo.hussar.bsp.organ.service.ISysOrganTypeService;
import com.jxdinfo.hussar.bsp.organ.service.ISysStruRuleService;
import com.jxdinfo.hussar.bsp.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.bsp.permit.service.ISysUsersService;
import com.jxdinfo.hussar.common.treemodel.JSTreeModel;
import com.jxdinfo.hussar.common.treemodel.ZTreeModel;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class OrganUtil {
    @Resource
    private ISysStruRuleService iSysStruRuleService;
    @Resource
    private SysStruMapper sysStruMapper;
    @Resource
    private SysOrganMapper sysOrganMapper;
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;
    @Resource
    private ISysUsersService sysUsersService;
    @Resource
    private ISysOrganTypeService sysOrganTypeService;
    private static final String ORG_TREE = "1";
    private static final String EMPLOYEE_TREE = "2";
    private static final String USER_TREE = "3";

    public List<Map<String, Object>> getOrganiseByOrganType(String organTypeId) {
        HashMap queryMap = new HashMap();
        List list = this.iSysStruRuleService.listByMap(queryMap);
        String[] organTypes = this.getOrganType(list, organTypeId);
        return this.iSysStruRuleService.getOrganByTypes(organTypes);
    }

    private String[] getOrganType(List<SysStruRule> list, String organTypeId) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put(organTypeId, "");
        this.computeOrganType(list, organTypeId, resultMap);
        String[] retStrs = new String[resultMap.size()];
        Iterator iterator = resultMap.entrySet().iterator();
        int i = 0;
        while (iterator.hasNext()) {
            retStrs[i++] = (String)iterator.next().getKey();
        }
        return retStrs;
    }

    private void computeOrganType(List<SysStruRule> list, String p_oraganTypeId, Map<String, String> resultMap) {
        for (int i = 0; i < list.size(); ++i) {
            SysStruRule sysStruRule;
            String organType;
            if (i > list.size()) {
                i = 0;
            }
            if (!p_oraganTypeId.equals(organType = (sysStruRule = list.get(i)).getOrganType())) continue;
            resultMap.put(sysStruRule.getSysOrganType(), "");
            list.remove((Object)sysStruRule);
            this.computeOrganType(list, sysStruRule.getSysOrganType(), resultMap);
        }
    }

    public List<JSTreeModel> getOrgTreeByTreeType(String treeType) {
        List<Object> list = new ArrayList();
        if (ToolUtil.equals((Object)ORG_TREE, (Object)treeType)) {
            list = this.sysStruMapper.getOrgTree(null);
        }
        if (ToolUtil.equals((Object)EMPLOYEE_TREE, (Object)treeType)) {
            list = this.sysStruMapper.getOrgTree(EMPLOYEE_TREE);
        }
        if (ToolUtil.equals((Object)USER_TREE, (Object)treeType)) {
            list = this.sysStruMapper.getUserTree();
        }
        return list;
    }

    public List<SysUsers> getUserByRoleId(String roleId) {
        return this.sysUserRoleMapper.getUsersByRoleId(roleId);
    }

    public List<SysUsers> getUserByStruId(String struId, boolean containSubordinate) {
        List usersList = new ArrayList();
        if (containSubordinate) {
            List<SysStru> sysStruList = this.getDepartmentByStruId(struId, true);
            ArrayList<String> struIdList = new ArrayList<String>();
            for (SysStru stru : sysStruList) {
                struIdList.add(stru.getStruId());
            }
            usersList = this.sysUsersService.list((Wrapper)((QueryWrapper)new QueryWrapper().in((Object)"DEPARTMENT_ID", struIdList)).ne((Object)"ACCOUNT_STATUS", (Object)EMPLOYEE_TREE));
        } else {
            usersList = this.sysUsersService.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"DEPARTMENT_ID", (Object)struId)).ne((Object)"ACCOUNT_STATUS", (Object)EMPLOYEE_TREE));
        }
        return usersList;
    }

    public List<SysStru> getStaffByStruId(String struId, boolean containSubordinate) {
        List staffList = new ArrayList();
        if (containSubordinate) {
            List<SysStru> sysStruList = this.getDepartmentByStruId(struId, true);
            ArrayList<String> struIdList = new ArrayList<String>();
            for (SysStru stru : sysStruList) {
                struIdList.add(stru.getStruId());
            }
            staffList = this.sysStruMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"STRU_TYPE", (Object)"9")).eq((Object)"IS_EMPLOYEE", (Object)ORG_TREE)).eq((Object)"IN_USE", (Object)ORG_TREE)).in((Object)"PARENT_ID", struIdList));
        } else {
            staffList = this.sysStruMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"STRU_TYPE", (Object)"9")).eq((Object)"IS_EMPLOYEE", (Object)ORG_TREE)).eq((Object)"IN_USE", (Object)ORG_TREE)).eq((Object)"PARENT_ID", (Object)struId));
        }
        return staffList;
    }

    public List<SysStru> getDepartmentByStruId(String struId, boolean allSubordinate) {
        List departmentList = new ArrayList();
        if (allSubordinate) {
            SysStru sysStru = (SysStru)((Object)this.sysStruMapper.selectById((Serializable)((Object)struId)));
            SysOrgan sysOrgan = (SysOrgan)((Object)this.sysOrganMapper.selectById((Serializable)((Object)sysStru.getOrganId())));
            List sysOrganList = this.sysOrganMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"IN_USE", (Object)ORG_TREE)).ne((Object)"ORGAN_TYPE", (Object)"9")).likeLeft((Object)"ORGAN_CODE", (Object)sysOrgan.getOrganCode()));
            ArrayList<String> organIdList = new ArrayList<String>();
            for (SysOrgan organ : sysOrganList) {
                organIdList.add(organ.getOrganId());
            }
            departmentList = this.sysStruMapper.selectList((Wrapper)new QueryWrapper().in((Object)"ORGAN_ID", organIdList));
        } else {
            departmentList = this.sysStruMapper.selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"IN_USE", (Object)ORG_TREE)).eq((Object)"PARENT_ID", (Object)struId)).ne((Object)"STRU_TYPE", (Object)"9"));
        }
        return departmentList;
    }

    public List<SysStru> getAllStruInfo() {
        return this.sysStruMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"IN_USE", (Object)ORG_TREE)).ne((Object)"STRU_TYPE", (Object)"9"));
    }

    public List<SysOrganType> getAllOrganType() {
        return this.sysOrganTypeService.list((Wrapper)new QueryWrapper());
    }

    public List<ZTreeModel> getZtreeToOrg(String parentId) {
        return this.sysStruMapper.getZtreeToOrg(parentId);
    }
}

