/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.firewall.xss;

import com.jxdinfo.hussar.common.firewall.xss.XssPattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class XssHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private String xssLevel;

    public XssHttpServletRequestWrapper(HttpServletRequest servletRequest, String xssLevel) {
        super(servletRequest);
        this.xssLevel = xssLevel;
    }

    public String[] getParameterValues(String parameter) {
        String[] values = super.getParameterValues(parameter);
        if (values == null) {
            return null;
        }
        int count = values.length;
        String[] encodedValues = new String[count];
        for (int i = 0; i < count; ++i) {
            encodedValues[i] = this.cleanXSS(values[i], this.xssLevel);
        }
        return encodedValues;
    }

    public String getParameter(String parameter) {
        String value = super.getParameter(parameter);
        if (value == null) {
            return null;
        }
        return this.cleanXSS(value, this.xssLevel);
    }

    public String getHeader(String name) {
        String value = super.getHeader(name);
        if (value == null) {
            return null;
        }
        return this.cleanXSS(value, this.xssLevel);
    }

    private String cleanXSS(String value, String xssLevel) {
        if (value != null) {
            value = "A".equals(xssLevel) ? this.levelA(value) : ("C".equals(xssLevel) ? this.levelC(value) : this.levelB(value));
        }
        return value;
    }

    private String levelA(String value) {
        value = value.replaceAll("eval\\((.*)\\)", "");
        value = value.replaceAll("[\\\"\\'][\\s]*javascript:(.*)[\\\"\\']", "\"\"");
        value = value.replaceAll("script", "");
        return value;
    }

    private String levelB(String value) {
        String rtnValue = this.levelA(value);
        rtnValue = XssPattern.checkAndReplace(rtnValue);
        return rtnValue;
    }

    private String levelC(String value) {
        value = XssPattern.XSSPATTERN.matcher(value).replaceAll("");
        return value;
    }
}

