/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.firewall.xss;

import com.jxdinfo.hussar.common.firewall.xss.XssPattern;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.servlet.handler.AbstractHandlerMapping;
import org.springframework.web.util.HtmlUtils;
import org.springframework.web.util.UrlPathHelper;

@Component
public class XssHandlerMappingPostProcessor
implements BeanPostProcessor {
    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof AbstractHandlerMapping) {
            AbstractHandlerMapping ahm = (AbstractHandlerMapping)bean;
            ahm.setUrlPathHelper((UrlPathHelper)new XssUrlPathHelper());
        }
        return bean;
    }

    static class XssUrlPathHelper
    extends UrlPathHelper {
        XssUrlPathHelper() {
        }

        public Map<String, String> decodePathVariables(HttpServletRequest request, Map<String, String> vars) {
            Map result = super.decodePathVariables(request, vars);
            if (!CollectionUtils.isEmpty(result.keySet())) {
                for (String key : result.keySet()) {
                    result.put(key, this.cleanXSS((String)result.get(key)));
                }
            }
            return result;
        }

        public MultiValueMap<String, String> decodeMatrixVariables(HttpServletRequest request, MultiValueMap<String, String> vars) {
            MultiValueMap mvm = super.decodeMatrixVariables(request, vars);
            if (!CollectionUtils.isEmpty((Collection)mvm.keySet())) {
                for (String key : mvm.keySet()) {
                    List value = (List)mvm.get((Object)key);
                    for (int i = 0; i < value.size(); ++i) {
                        value.set(i, this.cleanXSS((String)value.get(i)));
                    }
                }
            }
            return mvm;
        }

        private String cleanXSS(String value) {
            String rtnValue = value;
            rtnValue = XssPattern.checkAndReplace(rtnValue);
            return HtmlUtils.htmlEscape((String)rtnValue);
        }
    }
}

