/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.firewall.csrf;

import com.jxdinfo.hussar.core.filter.HussarPathMatcher;
import com.jxdinfo.hussar.core.filter.PatternMatcher;
import com.jxdinfo.hussar.otp.credential.AbstractOTPCredentialsMatcher;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CsrfFilter
implements Filter {
    private static Logger LOGGER = LoggerFactory.getLogger(CsrfFilter.class);
    private Boolean csrfcheck = true;
    private String refererWhitelist = "";
    private AbstractOTPCredentialsMatcher abstractOTPCredentialsMatcher;
    private Set<String> excludesPattern;
    protected String contextPath;
    protected PatternMatcher pathMatcher = HussarPathMatcher.getInstance();
    public static final String PARAM_NAME_EXCLUSIONS = "exclusions";

    public CsrfFilter(AbstractOTPCredentialsMatcher abstractOTPCredentialsMatcher) {
        this.abstractOTPCredentialsMatcher = abstractOTPCredentialsMatcher;
    }

    public void init(FilterConfig config) throws ServletException {
        String exclusions = config.getInitParameter(PARAM_NAME_EXCLUSIONS);
        if (exclusions != null && exclusions.trim().length() != 0) {
            this.excludesPattern = new HashSet<String>(Arrays.asList(exclusions.split("\\s*,\\s*")));
        }
        this.contextPath = this.getContextPath(config.getServletContext());
    }

    private String getContextPath(ServletContext servletContext) {
        String contextPath = servletContext.getContextPath();
        if (contextPath == null || contextPath.length() == 0) {
            contextPath = "/";
        }
        return contextPath;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String referer = httpRequest.getHeader("Referer");
        String requestUri = httpRequest.getRequestURI();
        if (!this.csrfcheck.booleanValue()) {
            LOGGER.error("\u5f53\u524dCSRF\u8fc7\u6ee4\u5668\u5df2\u7ecf\u5173\u95ed\uff0c\u4e0d\u8fdb\u884c\u4efb\u4f55\u5b89\u5168\u6821\u9a8c\uff0c\u5f53\u524d\u8bf7\u6c42URI\u4e3a: \t" + requestUri + "\nREFERER:\t" + referer);
            chain.doFilter(request, response);
            return;
        }
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.addHeader("X-Content-Type-Options", "nosniff");
        httpResponse.setHeader("X-XSS-Protection", "1;mode=block");
        String schme = httpRequest.getScheme();
        String serverName = httpRequest.getServerName();
        int serverPort = httpRequest.getServerPort();
        String realpath = schme + "://" + serverName + ("http".equals(schme) && serverPort == 80 || "https".equals(schme) && serverPort == 443 ? "" : ":" + serverPort);
        if (this.isExclusion(requestUri)) {
            chain.doFilter(request, response);
            return;
        }
        if (referer == null) {
            chain.doFilter(request, response);
        } else if (referer.trim().startsWith(realpath) || this.checkRefererWhite(referer)) {
            String csrfToken = httpRequest.getHeader("x-csrf-token");
            if (csrfToken != null) {
                this.abstractOTPCredentialsMatcher.getClass();
                if (!this.abstractOTPCredentialsMatcher.verify("FCUD3YLMJYG2F72L2NFDXYPL6UJBUUN24BGBK6JDEIKHUA4ZOD2A", csrfToken, 1)) {
                    this.abstractOTPCredentialsMatcher.getClass();
                    String code_s = this.abstractOTPCredentialsMatcher.generate("FCUD3YLMJYG2F72L2NFDXYPL6UJBUUN24BGBK6JDEIKHUA4ZOD2A");
                    LOGGER.error("\u68c0\u6d4b\u5230\u91cd\u653e\u8bf7\u6c42,token [" + csrfToken + "]\u5df2\u5931\u6548 , 403:  [" + code_s + "][" + csrfToken + "]\nURI:" + requestUri);
                    httpRequest.getRequestDispatcher("/exception/403").forward(request, response);
                    return;
                }
            }
            chain.doFilter(request, response);
        } else {
            boolean checked = this.checkRefererWhite(referer);
            if (checked) {
                chain.doFilter(request, response);
            } else if (requestUri.endsWith("/exception/403")) {
                chain.doFilter(request, response);
            } else {
                LOGGER.error("\u68c0\u6d4b\u5230\u8de8\u7ad9\u8bf7\u6c42\uff01403: \nURI:" + requestUri + "\nREFERER: " + referer);
                httpRequest.getRequestDispatcher("/exception/403").forward(request, response);
                return;
            }
        }
    }

    private boolean isExclusion(String requestURI) {
        if (this.excludesPattern == null || requestURI == null) {
            return false;
        }
        if (this.contextPath != null && requestURI.startsWith(this.contextPath) && !(requestURI = requestURI.substring(this.contextPath.length())).startsWith("/")) {
            requestURI = "/" + requestURI;
        }
        for (String pattern : this.excludesPattern) {
            if (!this.pathMatcher.matches(pattern, requestURI)) continue;
            return true;
        }
        return false;
    }

    private boolean checkRefererWhite(String referer) {
        String[] refererWhiteArray = this.refererWhitelist.split(",");
        boolean checked = false;
        for (String string : refererWhiteArray) {
            if (string.length() <= 0 || !referer.trim().startsWith(string)) continue;
            checked = true;
            break;
        }
        return checked;
    }

    public void destroy() {
    }

    public boolean isCsrfcheck() {
        return this.csrfcheck;
    }

    public void setCsrfcheck(boolean csrfcheck) {
        this.csrfcheck = csrfcheck;
    }

    public String getRefererWhitelist() {
        return this.refererWhitelist;
    }

    public void setRefererWhitelist(String refererWhitelist) {
        this.refererWhitelist = refererWhitelist;
    }
}

