/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.converter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.config.FastJsonConfig;
import com.alibaba.fastjson.support.spring.FastJsonContainer;
import com.alibaba.fastjson.support.spring.PropertyPreFilters;
import com.jxdinfo.hussar.common.exception.HussarUndeclaredThrowableException;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import com.jxdinfo.hussar.encrypt.util.SM2Util;
import com.jxdinfo.hussar.encrypt.util.SM3Util;
import com.jxdinfo.hussar.encrypt.util.SM4Util;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.AbstractHttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.stereotype.Component;
import org.springframework.util.StreamUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
public class JsonHttpMessageConverter
extends AbstractHttpMessageConverter<Object> {
    protected Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    public static String MEDIATYPE_SUBTYPE_ENCRYPT_JSON = "encryptjson";
    public static final MediaType APPLICATION_ENCRYPTJSON = new MediaType("application", MEDIATYPE_SUBTYPE_ENCRYPT_JSON);
    @Autowired
    private Environment env;
    @Autowired
    MessageSource messageSource;
    @Autowired
    private HussarCacheManager hussarCacheManager;
    @Autowired
    private GlobalProperties global;
    private FastJsonConfig fastJsonConfig = new FastJsonConfig();
    boolean isDevProfile = false;

    public FastJsonConfig getFastJsonConfig() {
        return this.fastJsonConfig;
    }

    public void setFastJsonConfig(FastJsonConfig fastJsonConfig) {
        this.fastJsonConfig = fastJsonConfig;
    }

    public JsonHttpMessageConverter() {
        this(APPLICATION_ENCRYPTJSON);
    }

    public JsonHttpMessageConverter(MediaType mediaType) {
        super(mediaType);
    }

    @PostConstruct
    public void init() {
        String profile = this.env.getProperty("spring.profiles.active");
        this.isDevProfile = "dev".equals(profile);
        String publicKey_backend = (String)this.hussarCacheManager.getObject("SM2BackEndPubKey", "SM2BackEndPubKey");
        String privateKey_backend = (String)this.hussarCacheManager.getObject("SM2BackEndPriKey", "SM2BackEndPriKey");
        String publicKey_fronend = (String)this.hussarCacheManager.getObject("SM2FronEndPubKey", "SM2FronEndPubKey");
        String privateKey_fronend = (String)this.hussarCacheManager.getObject("SM2FronEndPriKey", "SM2FronEndPriKey");
        if (publicKey_backend == null || privateKey_backend == null || publicKey_fronend == null || privateKey_fronend == null) {
            Map keyMapBackEnd = SM2Util.generateKeyPair();
            Map keyMapFronEnd = SM2Util.generateKeyPair();
            publicKey_backend = (String)keyMapFronEnd.get("pubKey");
            privateKey_backend = (String)keyMapBackEnd.get("priKey");
            publicKey_fronend = (String)keyMapBackEnd.get("pubKey");
            privateKey_fronend = (String)keyMapFronEnd.get("priKey");
            this.hussarCacheManager.setObject("SM2BackEndPubKey", "SM2BackEndPubKey", publicKey_backend);
            this.hussarCacheManager.setObject("SM2BackEndPriKey", "SM2BackEndPriKey", privateKey_backend);
            this.hussarCacheManager.setObject("SM2FronEndPubKey", "SM2FronEndPubKey", publicKey_fronend);
            this.hussarCacheManager.setObject("SM2FronEndPriKey", "SM2FronEndPriKey", privateKey_fronend);
        }
    }

    protected boolean supports(Class<?> clazz) {
        return true;
    }

    protected boolean canWrite(MediaType mediaType) {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
        String contentType = request.getHeader("Content-Type");
        return contentType != null && contentType.toLowerCase().lastIndexOf(MEDIATYPE_SUBTYPE_ENCRYPT_JSON) > -1;
    }

    protected boolean canRead(MediaType mediaType) {
        String subtype = mediaType.getSubtype();
        if (MEDIATYPE_SUBTYPE_ENCRYPT_JSON.equals(subtype)) {
            return super.canRead(mediaType);
        }
        return false;
    }

    protected Object readInternal(Class<? extends Object> clazz, HttpInputMessage inputMessage) throws IOException, HttpMessageNotReadableException {
        long start = System.nanoTime();
        String requestBody = StreamUtils.copyToString((InputStream)inputMessage.getBody(), (Charset)Charset.forName("UTF-8"));
        JSONObject json = JSONObject.parseObject((String)requestBody);
        String data = json.getString("data");
        String sign = json.getString("sign");
        String key = json.getString("key");
        String sign_check = "";
        if (this.global.isEncryptSignOpen()) {
            sign_check = SM3Util.digest((String)data);
        }
        if (sign_check.equalsIgnoreCase(sign)) {
            try {
                String privateKey_backend = (String)this.hussarCacheManager.getObject("SM2BackEndPriKey", "SM2BackEndPriKey");
                String realKey = SM2Util.decrypt((String)key, (String)privateKey_backend);
                String realBody = SM4Util.decrypt((String)data, (String)realKey);
                JSONObject.parseObject((String)realBody);
                this.logger.debug("requestBody:orign:{},real:{}", (Object)requestBody, (Object)realBody);
                HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
                request.setAttribute("realRequestBody", (Object)realBody);
                long end = System.nanoTime();
                long period = end - start;
                this.logger.debug(String.format("readInternal\uff1aperiod(nanoseconds) : %d ns, period(millseconds): %d ms", period, TimeUnit.NANOSECONDS.toMillis(period)));
                return JSONObject.parseObject((String)realBody, clazz);
            }
            catch (JSONException | NullPointerException e) {
                throw new HussarUndeclaredThrowableException();
            }
        }
        return null;
    }

    protected void writeInternal(Object resp, HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
        try (ByteArrayOutputStream outnew = new ByteArrayOutputStream();){
            HttpHeaders headers = outputMessage.getHeaders();
            this.fastJsonConfig.setSerializerFeatures(new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue, SerializerFeature.WriteEnumUsingToString, SerializerFeature.WriteDateUseDateFormat});
            long start = System.nanoTime();
            String publicKey_backend = (String)this.hussarCacheManager.getObject("SM2BackEndPubKey", "SM2BackEndPubKey");
            outputMessage.getHeaders().setContentType(APPLICATION_ENCRYPTJSON);
            ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getResponse().getStatus();
            SerializeFilter[] globalFilters = this.fastJsonConfig.getSerializeFilters();
            ArrayList<SerializeFilter> allFilters = new ArrayList<SerializeFilter>(Arrays.asList(globalFilters));
            Object value = this.strangeCodeForJackson(resp);
            if (value instanceof FastJsonContainer) {
                FastJsonContainer fastJsonContainer = (FastJsonContainer)value;
                PropertyPreFilters filters = fastJsonContainer.getFilters();
                allFilters.addAll(filters.getFilters());
                value = fastJsonContainer.getValue();
            }
            String data = JSONObject.toJSONString((Object)value, (SerializeFilter[])allFilters.toArray(new SerializeFilter[allFilters.size()]), (SerializerFeature[])this.fastJsonConfig.getSerializerFeatures());
            String sm4Key = SM4Util.getRandomKey();
            String encryptedData = SM4Util.encrypt((String)data, (String)sm4Key);
            String sign = "";
            if (this.global.isEncryptSignOpen()) {
                sign = SM3Util.digest((String)encryptedData);
            }
            String key = SM2Util.encrypt((String)sm4Key, (String)publicKey_backend);
            JSONObject json = new JSONObject();
            json.put("data", (Object)encryptedData);
            json.put("sign", (Object)sign);
            json.put("key", (Object)key);
            int len = JSON.writeJSONStringWithFastJsonConfig((OutputStream)outnew, (Charset)this.fastJsonConfig.getCharset(), (Object)json, (SerializeConfig)this.fastJsonConfig.getSerializeConfig(), (SerializeFilter[])allFilters.toArray(new SerializeFilter[allFilters.size()]), (String)this.fastJsonConfig.getDateFormat(), (int)JSON.DEFAULT_GENERATE_FEATURE, (SerializerFeature[])this.fastJsonConfig.getSerializerFeatures());
            HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.currentRequestAttributes()).getRequest();
            request.setAttribute("realResponseBody", (Object)JSONObject.toJSONString((Object)resp));
            this.logger.debug("{}:responseBody:{},real:{}", new Object[]{request.getRequestURI(), resp, JSONObject.toJSONString((Object)json)});
            long end = System.nanoTime();
            long period = end - start;
            this.logger.debug(String.format("writeInternal\uff1aperiod(nanoseconds): %d  ns, period(millseconds) ms: %d ms", period, TimeUnit.NANOSECONDS.toMillis(period)));
            if (this.fastJsonConfig.isWriteContentLength()) {
                headers.setContentLength((long)len);
            }
            outnew.writeTo(outputMessage.getBody());
        }
    }

    private Object strangeCodeForJackson(Object obj) {
        String className;
        if (obj != null && "com.fasterxml.jackson.databind.node.ObjectNode".equals(className = obj.getClass().getName())) {
            return obj.toString();
        }
        return obj;
    }
}

