/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.converter;

import com.jxdinfo.hussar.core.cache.HussarCacheManager;
import com.jxdinfo.hussar.encrypt.util.SM2Util;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

@Component
public class ConverterInitCommand
implements CommandLineRunner {
    protected static final Logger logger = LoggerFactory.getLogger(ConverterInitCommand.class);
    @Autowired
    private HussarCacheManager hussarCacheManager;

    public void run(String ... args) throws Exception {
        String publicKey_backend = (String)this.hussarCacheManager.getObject("SM2BackEndPubKey", "SM2BackEndPubKey");
        String privateKey_backend = (String)this.hussarCacheManager.getObject("SM2BackEndPriKey", "SM2BackEndPriKey");
        String publicKey_fronend = (String)this.hussarCacheManager.getObject("SM2FronEndPubKey", "SM2FronEndPubKey");
        String privateKey_fronend = (String)this.hussarCacheManager.getObject("SM2FronEndPriKey", "SM2FronEndPriKey");
        if (publicKey_backend == null || privateKey_backend == null || publicKey_fronend == null || privateKey_fronend == null) {
            Map keyMapBackEnd = SM2Util.generateKeyPair();
            Map keyMapFronEnd = SM2Util.generateKeyPair();
            publicKey_backend = (String)keyMapFronEnd.get("pubKey");
            privateKey_backend = (String)keyMapBackEnd.get("priKey");
            publicKey_fronend = (String)keyMapBackEnd.get("pubKey");
            privateKey_fronend = (String)keyMapFronEnd.get("priKey");
            this.hussarCacheManager.setObject("SM2BackEndPubKey", "SM2BackEndPubKey", publicKey_backend);
            this.hussarCacheManager.setObject("SM2BackEndPriKey", "SM2BackEndPriKey", privateKey_backend);
            this.hussarCacheManager.setObject("SM2FronEndPubKey", "SM2FronEndPubKey", publicKey_fronend);
            this.hussarCacheManager.setObject("SM2FronEndPriKey", "SM2FronEndPriKey", privateKey_fronend);
        } else {
            logger.debug("SM2\u5bc6\u94a5\u5df2\u521d\u59cb\u5316\u5b8c\u6210^-^");
        }
    }
}

