/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.constant.factory;

import com.jxdinfo.hussar.bsp.menu.dao.SysMenuMapper;
import com.jxdinfo.hussar.bsp.menu.model.SysMenu;
import com.jxdinfo.hussar.bsp.organ.dao.SysStruMapper;
import com.jxdinfo.hussar.bsp.organ.vo.SysOrganVo;
import com.jxdinfo.hussar.bsp.permit.dao.SysResourcesMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysRolesMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysStruRoleMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysUsersMapper;
import com.jxdinfo.hussar.bsp.permit.model.SysRoles;
import com.jxdinfo.hussar.bsp.permit.model.SysUsers;
import com.jxdinfo.hussar.common.constant.factory.IConstantFactory;
import com.jxdinfo.hussar.common.constant.state.ManagerStatus;
import com.jxdinfo.hussar.common.constant.state.MenuStatus;
import com.jxdinfo.hussar.core.log.LogObjectHolder;
import com.jxdinfo.hussar.core.shiro.ShiroUser;
import com.jxdinfo.hussar.core.support.StrKit;
import com.jxdinfo.hussar.core.util.Convert;
import com.jxdinfo.hussar.core.util.SpringContextHolder;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Component;

@Component
@DependsOn(value={"springContextHolder"})
public class ConstantFactory
implements IConstantFactory {
    private SysRolesMapper roleMapper = (SysRolesMapper)SpringContextHolder.getBean(SysRolesMapper.class);
    private SysStruMapper struMapper = (SysStruMapper)SpringContextHolder.getBean(SysStruMapper.class);
    private SysUsersMapper userMapper = (SysUsersMapper)SpringContextHolder.getBean(SysUsersMapper.class);
    private SysMenuMapper menuMapper = (SysMenuMapper)SpringContextHolder.getBean(SysMenuMapper.class);
    private SysUserRoleMapper userRoleMapper = (SysUserRoleMapper)SpringContextHolder.getBean(SysUserRoleMapper.class);
    private SysStruRoleMapper struRoleMapper = (SysStruRoleMapper)SpringContextHolder.getBean(SysStruRoleMapper.class);
    private SysRolesMapper RolesMapper = (SysRolesMapper)SpringContextHolder.getBean(SysRolesMapper.class);
    private SysResourcesMapper resourcesMapper = (SysResourcesMapper)SpringContextHolder.getBean(SysResourcesMapper.class);

    public static IConstantFactory me() {
        return (IConstantFactory)SpringContextHolder.getBean((String)"constantFactory");
    }

    @Override
    @Cacheable(value={"authorization_info"}, key="'shiro_authInfo:'+#shiroUser.id")
    public Map<String, List<String>> getAuthInfo(ShiroUser shiroUser) {
        List<String> permissionList = this.resourcesMapper.getResourceByUserId(shiroUser.getId());
        List<String> repeatAuthenticateList = this.resourcesMapper.getIsRepeatAuthenticateId(shiroUser.getId());
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("userPermission", permissionList);
        map.put("repeatAuthenticate", repeatAuthenticateList);
        return map;
    }

    @Override
    public List<String> getRolesIdByUserId(String userId) {
        List<String> rolesList = this.userRoleMapper.getRolesByUserId(userId);
        return rolesList;
    }

    @Override
    public List<String> getRolesIdByStruId(String struId) {
        List<String> roleList = this.struRoleMapper.getRolesByStruId(struId);
        return roleList;
    }

    @Override
    public String getRoleNameByRoleId(String roleId) {
        SysRoles sysRoles = (SysRoles)((Object)this.RolesMapper.selectById((Serializable)((Object)roleId)));
        if (ToolUtil.isNotEmpty((Object)((Object)sysRoles)) && ToolUtil.isNotEmpty((Object)sysRoles.getRoleName())) {
            return sysRoles.getRoleName();
        }
        return null;
    }

    @Override
    public String getUserNameById(Integer userId) {
        SysUsers user = (SysUsers)((Object)this.userMapper.selectById(userId));
        if (user != null) {
            return user.getUserName();
        }
        return "--";
    }

    @Override
    public String getUserAccountById(Integer userId) {
        SysUsers user = (SysUsers)((Object)this.userMapper.selectById(userId));
        if (user != null) {
            return user.getUserAccount();
        }
        return "--";
    }

    @Override
    @Cacheable(value={"CONSTANT"}, key="'roles_name_'+#roleIds")
    public String getRoleName(String roleIds) {
        Integer[] roles = Convert.toIntArray((String)roleIds);
        StringBuilder sb = new StringBuilder();
        Integer[] integerArray = roles;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int role = integerArray[i];
            SysRoles roleObj = (SysRoles)((Object)this.roleMapper.selectById(Integer.valueOf(role)));
            if (!ToolUtil.isNotEmpty((Object)((Object)roleObj)) || !ToolUtil.isNotEmpty((Object)roleObj.getRoleName())) continue;
            sb.append(roleObj.getRoleName()).append(",");
        }
        return StrKit.removeSuffix((String)sb.toString(), (String)",");
    }

    @Override
    @Cacheable(value={"CONSTANT"}, key="'single_role_name_'+#roleId")
    public String getSingleRoleName(Integer roleId) {
        if (0 == roleId) {
            return "--";
        }
        SysRoles roleObj = (SysRoles)((Object)this.roleMapper.selectById(roleId));
        if (ToolUtil.isNotEmpty((Object)((Object)roleObj)) && ToolUtil.isNotEmpty((Object)roleObj.getRoleName())) {
            return roleObj.getRoleName();
        }
        return "";
    }

    @Override
    @Cacheable(value={"CONSTANT"}, key="'single_role_tip_'+#roleId")
    public String getSingleRoleTip(String roleId) {
        SysRoles roleObj = (SysRoles)((Object)this.roleMapper.selectById((Serializable)((Object)roleId)));
        if (ToolUtil.isNotEmpty((Object)((Object)roleObj)) && ToolUtil.isNotEmpty((Object)roleObj.getRoleName())) {
            return roleObj.getRoleAlias();
        }
        return "";
    }

    @Override
    public String getDeptName(String deptId) {
        SysOrganVo dept = this.struMapper.getOrgInfoByOrgId(deptId);
        if (ToolUtil.isNotEmpty((Object)dept) && ToolUtil.isNotEmpty((Object)dept.getOrganName())) {
            return dept.getOrganName();
        }
        return "";
    }

    @Override
    public String getMenuNames(String menuIds) {
        Integer[] menus = Convert.toIntArray((String)menuIds);
        StringBuilder sb = new StringBuilder();
        Integer[] integerArray = menus;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int menu = integerArray[i];
            SysMenu menuObj = (SysMenu)((Object)this.menuMapper.selectById(Integer.valueOf(menu)));
            if (!ToolUtil.isNotEmpty((Object)((Object)menuObj)) || !ToolUtil.isNotEmpty((Object)menuObj.getText())) continue;
            sb.append(menuObj.getText()).append(",");
        }
        return StrKit.removeSuffix((String)sb.toString(), (String)",");
    }

    @Override
    public String getMenuName(Long menuId) {
        if (ToolUtil.isEmpty((Object)menuId)) {
            return "";
        }
        SysMenu menu = (SysMenu)((Object)this.menuMapper.selectById(menuId));
        if (menu == null) {
            return "";
        }
        return menu.getText();
    }

    @Override
    public String getMenuNameByCode(String code) {
        if (ToolUtil.isEmpty((Object)code)) {
            return "";
        }
        SysMenu menu = (SysMenu)((Object)this.menuMapper.selectById((Serializable)((Object)code)));
        if (menu == null) {
            return "";
        }
        return menu.getText();
    }

    @Override
    public String getStatusName(Integer status) {
        return ManagerStatus.valueOf(status);
    }

    @Override
    public String getMenuStatusName(Integer status) {
        return MenuStatus.valueOf(status);
    }

    @Override
    public String getCacheObject(String para) {
        return LogObjectHolder.me().get().toString();
    }

    @Override
    public List<String> getIsRepeatAuthenticateId(String userId) {
        List<String> list = this.resourcesMapper.getIsRepeatAuthenticateId(userId);
        return list;
    }
}

