/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.common.calendarutil;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.core.sys.model.SysCalendar;
import com.jxdinfo.hussar.core.sys.service.ISysCalendarService;
import com.jxdinfo.hussar.core.util.DateUtil;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Component;

@Component
public class WorkCalendarUtil {
    private static final String HOLIDAY = "holiday";
    private static final String WORK = "work";
    @Resource
    private ISysCalendarService sysCalendarService;

    public boolean isWorkDay(String date) {
        boolean flag = true;
        Date d = DateUtil.parse((String)date, (String)"yyyy-MM-dd");
        SysCalendar sysCalendar = (SysCalendar)((Object)this.sysCalendarService.getOne((Wrapper)new QueryWrapper().eq((Object)"START_TIME", (Object)d), false));
        if (ToolUtil.isEmpty((Object)((Object)sysCalendar))) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(d);
            int num = calendar.get(7);
            if (num == 1 || num == 7) {
                flag = false;
            }
        } else if (HOLIDAY.equals(sysCalendar.getClassName())) {
            flag = false;
        }
        return flag;
    }

    public int getWorkDayNum(String month) {
        int count = 0;
        int year = Integer.parseInt(month.substring(0, 4));
        int mon = Integer.parseInt(month.substring(5, 7));
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, mon - 1);
        cal.set(5, 1);
        while (cal.get(2) < mon) {
            int num = cal.get(7);
            if (num != 1 && num != 7) {
                ++count;
            }
            if (ToolUtil.equals((Object)mon, (Object)12) && ToolUtil.equals((Object)cal.get(5), (Object)31)) break;
            cal.add(5, 1);
        }
        cal.set(1, year);
        cal.set(2, mon - 1);
        cal.set(5, cal.getActualMinimum(5));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date start = cal.getTime();
        cal.set(5, cal.getActualMaximum(5));
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 59);
        Date end = cal.getTime();
        List<SysCalendar> list = this.sysCalendarService.getEventsBetweenDate(start, end);
        for (SysCalendar sysCalendar : list) {
            cal.setTime(sysCalendar.getStartTime());
            int num = cal.get(7);
            if (num != 1 && num != 7 && HOLIDAY.equals(sysCalendar.getClassName())) {
                --count;
            }
            if (num != 1 && num != 7 || !WORK.equals(sysCalendar.getClassName())) continue;
            ++count;
        }
        return count;
    }

    public int getHolidayNum(String month) {
        int count = 0;
        int year = Integer.parseInt(month.substring(0, 4));
        int mon = Integer.parseInt(month.substring(5, 7));
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, mon - 1);
        cal.set(5, 1);
        while (cal.get(2) < mon) {
            int num = cal.get(7);
            if (num == 1 || num == 7) {
                ++count;
            }
            if (ToolUtil.equals((Object)mon, (Object)12) && ToolUtil.equals((Object)cal.get(5), (Object)31)) break;
            cal.add(5, 1);
        }
        cal.set(1, year);
        cal.set(2, mon - 1);
        cal.set(5, cal.getActualMinimum(5));
        Date start = cal.getTime();
        cal.set(5, cal.getActualMaximum(5));
        Date end = cal.getTime();
        List<SysCalendar> list = this.sysCalendarService.getEventsBetweenDate(start, end);
        for (SysCalendar sysCalendar : list) {
            cal.setTime(sysCalendar.getStartTime());
            int num = cal.get(7);
            if (num != 1 && num != 7 && HOLIDAY.equals(sysCalendar.getClassName())) {
                ++count;
            }
            if (num != 1 && (num != 7 || !WORK.equals(sysCalendar.getClassName()))) continue;
            --count;
        }
        return count;
    }
}

