/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.welcome.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bsp.welcome.dao.SysWelcomeMapper;
import com.jxdinfo.hussar.bsp.welcome.model.SysWelcome;
import com.jxdinfo.hussar.bsp.welcome.service.ISysWelcomeService;
import com.jxdinfo.hussar.config.properties.HussarProperties;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class SysWelcomeServiceImpl
extends ServiceImpl<SysWelcomeMapper, SysWelcome>
implements ISysWelcomeService {
    @Resource
    private SysWelcomeMapper sysWelcomeMapper;
    @Resource
    private HussarProperties hussarProperties;

    @Override
    public Tip insertData(SysWelcome sysWelcome) {
        String userIds = sysWelcome.getUserId();
        String[] id = userIds.split(",");
        List<String> idList = Arrays.asList(userIds.split(","));
        String result = this.insertCheck(idList, "");
        if (!"".equals(result)) {
            return new ErrorTip(HttpCode.CONFLICT.value().intValue(), result);
        }
        String url = sysWelcome.getWelcomeUrl();
        ArrayList<SysWelcome> list = new ArrayList<SysWelcome>();
        for (String userId : id) {
            SysWelcome s = new SysWelcome();
            s.setUserId(userId);
            s.setWelcomeUrl(url);
            s.setTypes(sysWelcome.getTypes());
            list.add(s);
        }
        if (super.saveBatch(list, list.size())) {
            Tip tip = new Tip();
            tip.setCode(HttpCode.OK.value().intValue());
            tip.setMessage("\u4fdd\u5b58\u6210\u529f\uff01");
            return tip;
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    @Override
    public Tip insertRoleData(SysWelcome sysWelcome) {
        List<String> list = Arrays.asList(sysWelcome.getUserId().split(","));
        ArrayList<SysWelcome> listOfSysWelcome = new ArrayList<SysWelcome>();
        String result = this.insertCheck(list, "");
        if (!"".equals(result)) {
            return new ErrorTip(HttpCode.CONFLICT.value().intValue(), result);
        }
        for (String s : list) {
            SysWelcome sysWelcome1 = new SysWelcome();
            sysWelcome1.setUserId(s);
            sysWelcome1.setWelcomeUrl(sysWelcome.getWelcomeUrl());
            sysWelcome1.setTypes(sysWelcome.getTypes());
            listOfSysWelcome.add(sysWelcome1);
        }
        if (this.saveBatch(listOfSysWelcome, listOfSysWelcome.size())) {
            Tip tip = new Tip();
            tip.setCode(HttpCode.OK.value().intValue());
            tip.setMessage("\u4fdd\u5b58\u6210\u529f\uff01");
            return tip;
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    @Override
    public List<SysWelcome> list() {
        List<SysWelcome> list = this.sysWelcomeMapper.getWelcomeList();
        ArrayList<SysWelcome> newList = new ArrayList<SysWelcome>();
        ArrayList<SysWelcome> listZero = new ArrayList<SysWelcome>();
        ArrayList<SysWelcome> listOne = new ArrayList<SysWelcome>();
        for (SysWelcome s : list) {
            if ("1".equals(s.getTypes())) {
                listOne.add(s);
                continue;
            }
            listZero.add(s);
        }
        newList.addAll(this.returnMap(listZero));
        newList.addAll(this.returnMap(listOne));
        return newList;
    }

    @Override
    public void deleteByUrl(List list) {
        this.sysWelcomeMapper.deleteByUrl(list);
    }

    @Override
    public String getUserIndex(List<String> roleList) {
        if (!this.hussarProperties.isIndexConfig()) {
            return this.hussarProperties.getDefaultIndex();
        }
        List<SysWelcome> sysWelcomeList = this.sysWelcomeMapper.getUserIndex(roleList);
        if (ToolUtil.isNotEmpty(sysWelcomeList)) {
            for (SysWelcome sysWelcome : sysWelcomeList) {
                if (!"2".equals(sysWelcome.getTypes())) continue;
                return sysWelcome.getWelcomeUrl();
            }
            return sysWelcomeList.get(0).getWelcomeUrl();
        }
        return this.hussarProperties.getDefaultIndex();
    }

    @Override
    public SysWelcome selectByUrl(String sysWelcomeUrl, String types) {
        List<SysWelcome> list = this.sysWelcomeMapper.selectByUrl(sysWelcomeUrl, types);
        list = this.returnMap(list);
        return list.get(0);
    }

    @Override
    public Tip updateData(SysWelcome sysWelcome, String oldUrl) {
        String userIds = sysWelcome.getUserId();
        String[] id = userIds.split(",");
        List<String> idList = Arrays.asList(userIds.split(","));
        String result = this.insertCheck(idList, oldUrl);
        if (!"".equals(result)) {
            return new ErrorTip(HttpCode.CONFLICT.value().intValue(), result);
        }
        String url = sysWelcome.getWelcomeUrl();
        QueryWrapper ew = new QueryWrapper();
        ((QueryWrapper)ew.eq((Object)"types", (Object)sysWelcome.getTypes())).eq((Object)"welcome_url", (Object)oldUrl);
        this.remove((Wrapper)ew);
        this.sysWelcomeMapper.deleteBatchIds(idList);
        ArrayList<SysWelcome> list = new ArrayList<SysWelcome>();
        for (String userId : id) {
            SysWelcome s = new SysWelcome();
            s.setUserId(userId);
            s.setWelcomeUrl(url);
            s.setTypes(sysWelcome.getTypes());
            list.add(s);
        }
        if (super.saveBatch(list, list.size())) {
            Tip tip = new Tip();
            tip.setCode(HttpCode.OK.value().intValue());
            tip.setMessage("\u4fee\u6539\u6210\u529f\uff01");
            return tip;
        }
        return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "\u4fee\u6539\u5931\u8d25\uff01");
    }

    private List<SysWelcome> returnMap(List<SysWelcome> list) {
        HashMap<String, SysWelcome> map = new HashMap<String, SysWelcome>();
        for (SysWelcome sysWelcome : list) {
            if (map.get(sysWelcome.getWelcomeUrl()) != null) {
                String userId = ((SysWelcome)((Object)map.get(sysWelcome.getWelcomeUrl()))).getUserId();
                String userName = ((SysWelcome)((Object)map.get(sysWelcome.getWelcomeUrl()))).getUserName();
                String userIds = userId + "," + sysWelcome.getUserId();
                String userNames = userName + "," + sysWelcome.getUserName();
                sysWelcome.setUserId(userIds);
                sysWelcome.setUserName(userNames);
                map.put(sysWelcome.getWelcomeUrl(), sysWelcome);
                continue;
            }
            map.put(sysWelcome.getWelcomeUrl(), sysWelcome);
        }
        ArrayList<SysWelcome> newList = new ArrayList<SysWelcome>();
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            newList.add((SysWelcome)((Object)iterator.next().getValue()));
        }
        return newList;
    }

    private String insertCheck(List idList, String oldUrl) {
        List<SysWelcome> list = this.sysWelcomeMapper.insertCheck(idList, oldUrl);
        String result = "";
        if (list != null && list.size() > 0) {
            for (SysWelcome s : list) {
                if (!idList.contains(s.getUserId())) continue;
                result = result + s.getUserName() + ",";
            }
            return result.trim().substring(0, result.length() - 1) + "\u5df2\u914d\u7f6e\u5176\u4ed6\u6b22\u8fce\u9875";
        }
        return "";
    }
}

