/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.welcome.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.jxdinfo.hussar.bsp.welcome.model.SysWelcome;
import com.jxdinfo.hussar.bsp.welcome.service.ISysWelcomeService;
import com.jxdinfo.hussar.common.annotion.BussinessLog;
import com.jxdinfo.hussar.config.front.common.response.ApiResponse;
import com.jxdinfo.hussar.core.base.controller.BaseController;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/sysWelcome"})
public class SysWelcomeController
extends BaseController {
    private String PREFIX = "/bsp/welcome/";
    @Autowired
    private ISysWelcomeService sysWelcomeService;

    @RequestMapping(value={""})
    @RequiresPermissions(value={"sysWelcome:view"})
    @BussinessLog(key="/sysWelcome", type="04", value="\u6b22\u8fce\u9875\u914d\u7f6e\u9875\u9762")
    public String index(Model model) {
        return this.PREFIX + "sysWelcome.html";
    }

    @RequiresPermissions(value={"sysWelcome:sysWelcome_add"})
    @RequestMapping(value={"/sysWelcome_add"})
    public String sysWelcomeAdd() {
        return this.PREFIX + "sysWelcome_add.html";
    }

    @RequestMapping(value={"/list"})
    @ResponseBody
    @RequiresPermissions(value={"sysWelcome:list"})
    public Map<String, Object> list() {
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        List<SysWelcome> list = this.sysWelcomeService.list();
        int page = Integer.parseInt(super.getPara("page"));
        int limit = Integer.parseInt(super.getPara("limit"));
        result.put("count", list.size());
        result.put("data", list.stream().skip((page - 1) * limit).limit(limit).collect(Collectors.toList()));
        result.put("code", 0);
        result.put("msg", "success");
        return result;
    }

    @RequestMapping(value={"/listVue"})
    @ResponseBody
    @RequiresPermissions(value={"sysWelcome:list"})
    public ApiResponse<Map<String, Object>> list(@RequestBody Map<String, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        List<SysWelcome> list = this.sysWelcomeService.list();
        int page = Integer.parseInt(map.get("page").toString());
        int limit = Integer.parseInt(map.get("limit").toString());
        result.put("count", list.size());
        result.put("data", list.stream().skip((page - 1) * limit).limit(limit).collect(Collectors.toList()));
        result.put("code", 0);
        result.put("msg", "success");
        return ApiResponse.data(result);
    }

    @RequiresPermissions(value={"sysWelcome:sysWelcome_update"})
    @RequestMapping(value={"/sysWelcome_update"})
    @ResponseBody
    public SysWelcome sysWelcomeUpdate(String sysWelcomeUrl, String types) {
        return this.sysWelcomeService.selectByUrl(sysWelcomeUrl, types);
    }

    @RequiresPermissions(value={"sysWelcome:sysWelcome_update"})
    @RequestMapping(value={"/sysWelcome_updateVue"})
    @ResponseBody
    public ApiResponse<SysWelcome> sysWelcomeUpdate(@RequestBody Map<String, Object> map) {
        String sysWelcomeUrl = map.get("welcomeUrl").toString();
        String types = map.get("types").toString();
        return ApiResponse.data(this.sysWelcomeService.selectByUrl(sysWelcomeUrl, types));
    }

    @RequestMapping(value={"/update"})
    @ResponseBody
    @RequiresPermissions(value={"sysWelcome:update"})
    @BussinessLog(key="/sysWelcome/update", type="03", value="\u4fee\u6539\u6b22\u8fce\u9875")
    public Tip update(SysWelcome sysWelcome, String oldUrl) {
        return this.sysWelcomeService.updateData(sysWelcome, oldUrl);
    }

    @RequestMapping(value={"/updateVue"})
    @ResponseBody
    @RequiresPermissions(value={"sysWelcome:update"})
    @BussinessLog(key="/sysWelcome/update", type="03", value="\u4fee\u6539\u6b22\u8fce\u9875")
    public ApiResponse<Tip> update(@RequestBody Map<String, Object> map) {
        String userId = map.get("userId").toString();
        String types = map.get("types").toString();
        String welcomeUrl = map.get("welcomeUrl").toString();
        String oldUrl = map.get("oldUrl").toString();
        SysWelcome sysWelcome = new SysWelcome();
        sysWelcome.setUserId(userId);
        sysWelcome.setTypes(types);
        sysWelcome.setWelcomeUrl(welcomeUrl);
        return ApiResponse.data(this.sysWelcomeService.updateData(sysWelcome, oldUrl));
    }

    @RequestMapping(value={"/add"})
    @ResponseBody
    @RequiresPermissions(value={"sysWelcome:add"})
    @BussinessLog(key="/sysWelcome/add", type="01", value="\u65b0\u589e\u7528\u6237\u6b22\u8fce\u9875")
    public ApiResponse<Tip> add(SysWelcome sysWelcome) {
        return ApiResponse.data(this.sysWelcomeService.insertData(sysWelcome));
    }

    @RequestMapping(value={"/addRole"})
    @ResponseBody
    @RequiresPermissions(value={"sysWelcome:addRole"})
    @BussinessLog(key="/sysWelcome/addRole", type="01", value="\u65b0\u589e\u89d2\u8272\u6b22\u8fce\u9875")
    public Tip addRole(SysWelcome sysWelcome) {
        return this.sysWelcomeService.insertRoleData(sysWelcome);
    }

    @RequestMapping(value={"/addVue"})
    @ResponseBody
    @RequiresPermissions(value={"sysWelcome:addRole"})
    @BussinessLog(key="/sysWelcome/addRole", type="01", value="\u65b0\u589e\u89d2\u8272\u6b22\u8fce\u9875")
    public ApiResponse<Tip> addRole(@RequestBody Map<String, Object> map) {
        String userId = map.get("userId").toString();
        String types = map.get("types").toString();
        String welcomeUrl = map.get("welcomeUrl").toString();
        SysWelcome sysWelcome = new SysWelcome();
        sysWelcome.setUserId(userId);
        sysWelcome.setTypes(types);
        sysWelcome.setWelcomeUrl(welcomeUrl);
        Tip tip = this.sysWelcomeService.insertRoleData(sysWelcome);
        return ApiResponse.data(tip);
    }

    @RequestMapping(value={"/delete"})
    @ResponseBody
    @RequiresPermissions(value={"sysWelcome:delete"})
    @BussinessLog(key="/sysWelcome/delete", type="02", value="\u5220\u9664\u6b22\u8fce\u9875")
    public Tip delete(@RequestParam String userIds) {
        List<String> list = Arrays.asList(userIds.split(","));
        QueryWrapper ew = new QueryWrapper();
        ew.in(ToolUtil.isNotEmpty(list), (Object)"USER_ID", list);
        this.sysWelcomeService.remove((Wrapper)ew);
        return SUCCESS_TIP;
    }

    @RequestMapping(value={"/deleteVue"})
    @ResponseBody
    @RequiresPermissions(value={"sysWelcome:delete"})
    @BussinessLog(key="/sysWelcome/delete", type="02", value="\u5220\u9664\u6b22\u8fce\u9875")
    public ApiResponse<Tip> delete(@RequestBody Map<String, String> map) {
        String userIds = map.get("ids");
        List<String> list = Arrays.asList(userIds.split(","));
        QueryWrapper ew = new QueryWrapper();
        ew.in(ToolUtil.isNotEmpty(list), (Object)"USER_ID", list);
        this.sysWelcomeService.remove((Wrapper)ew);
        return ApiResponse.data(SUCCESS_TIP);
    }
}

