/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.sqlmonitor.controller;

import com.jxdinfo.hussar.bsp.sqlmonitor.service.ISqlMonitorService;
import com.jxdinfo.hussar.config.properties.ConnectionPoolProperties;
import java.util.HashMap;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/SqlMonitor"})
public class SqlMonitorController {
    @Autowired
    private ISqlMonitorService iSqlMonitorService;
    @Autowired
    private ConnectionPoolProperties connectionPoolProperties;

    @RequiresPermissions(value={"SqlMonitor:sql"})
    @RequestMapping(value={"/sql"})
    public String sql(Model model) {
        model.addAttribute("slowSqlMillis", (Object)this.connectionPoolProperties.getSlowSqlMillis());
        return "/bsp/sqlmonitor/sql.html";
    }

    @RequiresPermissions(value={"SqlMonitor:list"})
    @RequestMapping(value={"/list"})
    @ResponseBody
    public Object list(String orderBy, String orderType, String page, String perPageCount) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (null == orderBy) {
            orderBy = "MaxTimespan";
        }
        if (null == orderType) {
            orderType = "desc";
        }
        map.put("orderBy", orderBy);
        map.put("orderType", orderType);
        map.put("page", page);
        map.put("perPageCount", perPageCount);
        return this.iSqlMonitorService.getList(map);
    }
}

