/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bpm.messagepush.BpmAbstractPushMsgMatcher;
import com.jxdinfo.hussar.bsp.messagepush.AbstractPushMsgMatcher;
import com.jxdinfo.hussar.bsp.permit.dao.SysUserRoleMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysUserroleAuditMapper;
import com.jxdinfo.hussar.bsp.permit.model.SysUserRole;
import com.jxdinfo.hussar.bsp.permit.model.SysUserroleAudit;
import com.jxdinfo.hussar.bsp.permit.service.ISysRolesService;
import com.jxdinfo.hussar.bsp.permit.service.ISysUserroleAuditService;
import com.jxdinfo.hussar.bsp.permit.vo.SysUserRoleVo;
import com.jxdinfo.hussar.common.constant.state.UserRoleStatus;
import com.jxdinfo.hussar.common.constant.state.UserStatus;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysUserroleAuditServiceImpl
extends ServiceImpl<SysUserroleAuditMapper, SysUserroleAudit>
implements ISysUserroleAuditService {
    @Resource
    private SysUserroleAuditMapper sysUserroleAuditMapper;
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;
    @Resource
    private ISysRolesService iSysRolesService;
    private static final String ADD = "1";
    private static final String DELETE = "2";
    @Resource
    private AbstractPushMsgMatcher abstractPushMsgMatcher;
    @Resource
    private BpmAbstractPushMsgMatcher bpmAbstractPushMsgMatcher;

    @Override
    public Map<String, Object> getUserRoleReviewList(String page, String limit, String userAccount, String userName, String type) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        Page pages = new Page((long)Integer.valueOf(page).intValue(), (long)Integer.valueOf(limit).intValue());
        List<SysUserRoleVo> list = this.sysUserroleAuditMapper.getUserRoleReviewList((Page<Map<String, Object>>)pages, userName, userAccount, type);
        map.put("count", pages.getTotal());
        map.put("data", list);
        map.put("code", 0);
        return map;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void reviewSubmit(String userId, String roleId, String opsType) {
        String[] uids = userId.split(",");
        String[] rids = roleId.split(",");
        String[] oids = opsType.split(",");
        for (String uid : uids) {
            this.iSysRolesService.delRedisAuthInfo(uid);
        }
        SysUserroleAudit sysUserroleAudit = new SysUserroleAudit();
        sysUserroleAudit.setLastTime(new Date());
        sysUserroleAudit.setStatus(UserRoleStatus.OK.getCode());
        sysUserroleAudit.setLastEditor(ShiroKit.getUser().getAccount());
        if (uids.length == rids.length && uids.length == oids.length && rids.length == oids.length) {
            ArrayList<SysUserRole> addBpmList = new ArrayList<SysUserRole>();
            ArrayList<SysUserRole> deleteBpmList = new ArrayList<SysUserRole>();
            for (int i = 0; i < uids.length; ++i) {
                SysUserRole sysUserRole;
                List list = this.sysUserRoleMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_id", (Object)uids[i])).eq((Object)"granted_role", (Object)rids[i]));
                if (ToolUtil.isEmpty((Object)list)) {
                    sysUserRole = new SysUserRole();
                    sysUserRole.setCreateTime(new Date());
                    sysUserRole.setLastTime(new Date());
                    sysUserRole.setCreator(ShiroKit.getUser().getAccount());
                    sysUserRole.setLastEditor(ShiroKit.getUser().getAccount());
                    sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                    sysUserRole.setUserId(uids[i]);
                    sysUserRole.setGrantedRole(rids[i]);
                    if (ADD.equals(oids[i])) {
                        sysUserRole.setAdminOption(UserStatus.OK.getCode());
                    } else if (DELETE.equals(oids[i])) {
                        sysUserRole.setAdminOption(UserStatus.LOCKED.getCode());
                    }
                    this.sysUserRoleMapper.insert((Object)sysUserRole);
                    if (ADD.equals(oids[i])) {
                        addBpmList.add(sysUserRole);
                    } else if (DELETE.equals(oids[i])) {
                        deleteBpmList.add(sysUserRole);
                    }
                } else {
                    sysUserRole = new SysUserRole();
                    sysUserRole.setCreateTime(new Date());
                    sysUserRole.setLastTime(new Date());
                    sysUserRole.setCreator(ShiroKit.getUser().getAccount());
                    sysUserRole.setLastEditor(ShiroKit.getUser().getAccount());
                    sysUserRole.setAdminOption(UserRoleStatus.OK.getCode());
                    sysUserRole.setUserId(uids[i]);
                    sysUserRole.setGrantedRole(rids[i]);
                    if (ADD.equals(oids[i])) {
                        sysUserRole.setAdminOption(UserStatus.OK.getCode());
                    } else if (DELETE.equals(oids[i])) {
                        sysUserRole.setAdminOption(UserStatus.LOCKED.getCode());
                    }
                    this.sysUserRoleMapper.update((Object)sysUserRole, (Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"user_id", (Object)uids[i])).eq((Object)"granted_role", (Object)rids[i]));
                    if (ADD.equals(oids[i])) {
                        addBpmList.add(sysUserRole);
                    } else if (DELETE.equals(oids[i])) {
                        deleteBpmList.add(sysUserRole);
                    }
                }
                this.sysUserroleAuditMapper.update((Object)sysUserroleAudit, (Wrapper)((UpdateWrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"USER_ID", (Object)uids[i])).eq((Object)"role_id", (Object)rids[i])).eq((Object)"operation_type", (Object)oids[i]));
            }
            this.abstractPushMsgMatcher.insertOperation("userRole", "add", addBpmList, "");
            this.abstractPushMsgMatcher.insertOperation("userRole", "delete", deleteBpmList, "");
            this.bpmAbstractPushMsgMatcher.pushUserRole(addBpmList, "add");
            this.bpmAbstractPushMsgMatcher.pushUserRole(deleteBpmList, "delete");
        }
    }

    @Override
    public void refuseSubmit(String userId, String roleId, String opsType) {
        String[] uids = userId.split(",");
        String[] rids = roleId.split(",");
        String[] oids = opsType.split(",");
        SysUserroleAudit sysUserroleAudit = new SysUserroleAudit();
        sysUserroleAudit.setLastTime(new Date());
        sysUserroleAudit.setStatus(UserRoleStatus.REFUSE.getCode());
        sysUserroleAudit.setLastEditor(ShiroKit.getUser().getAccount());
        if (uids.length == rids.length && uids.length == oids.length && rids.length == oids.length) {
            for (int i = 0; i < uids.length; ++i) {
                this.sysUserroleAuditMapper.update((Object)sysUserroleAudit, (Wrapper)((UpdateWrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"user_id", (Object)uids[i])).eq((Object)"role_id", (Object)rids[i])).eq((Object)"operation_type", (Object)oids[i]));
            }
        }
    }

    @Override
    public int isDelete(String id) {
        return this.sysUserroleAuditMapper.isDelete(id);
    }
}

