/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bpm.messagepush.BpmAbstractPushMsgMatcher;
import com.jxdinfo.hussar.bsp.messagepush.AbstractPushMsgMatcher;
import com.jxdinfo.hussar.bsp.permit.dao.SysStruRoleMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysStruroleAuditMapper;
import com.jxdinfo.hussar.bsp.permit.model.SysStruRole;
import com.jxdinfo.hussar.bsp.permit.model.SysStruroleAudit;
import com.jxdinfo.hussar.bsp.permit.service.ISysRolesService;
import com.jxdinfo.hussar.bsp.permit.service.ISysStruroleAuditService;
import com.jxdinfo.hussar.bsp.permit.vo.SysStruRoleVo;
import com.jxdinfo.hussar.common.constant.state.StruRoleStatus;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysStruroleAuditServiceImpl
extends ServiceImpl<SysStruroleAuditMapper, SysStruroleAudit>
implements ISysStruroleAuditService {
    @Resource
    private SysStruroleAuditMapper sysStruroleAuditMapper;
    @Resource
    private SysStruRoleMapper sysStruRoleMapper;
    @Autowired
    private ISysRolesService iSysRolesService;
    private static final String ADD = "1";
    private static final String DELETE = "2";
    @Resource
    private AbstractPushMsgMatcher abstractPushMsgMatcher;
    @Resource
    private BpmAbstractPushMsgMatcher bpmAbstractPushMsgMatcher;

    @Override
    public Map<String, Object> getStruRoleReviewList(String page, String limit, String organName, String type) {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        Page pages = new Page((long)Integer.valueOf(page).intValue(), (long)Integer.valueOf(limit).intValue());
        List<SysStruRoleVo> list = this.sysStruroleAuditMapper.getStruRoleReviewList((Page<Map<String, Object>>)pages, organName, type);
        map.put("count", pages.getTotal());
        map.put("data", list);
        map.put("code", 0);
        return map;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void reviewSubmit(String struId, String roleId, String opsType) {
        String[] sids = struId.split(",");
        String[] rids = roleId.split(",");
        String[] oids = opsType.split(",");
        for (String sid : sids) {
            this.iSysRolesService.delRedisAuthInfo1(sid);
        }
        SysStruroleAudit sysStruroleAudit = new SysStruroleAudit();
        sysStruroleAudit.setLastTime(new Date());
        sysStruroleAudit.setStatus(StruRoleStatus.OK.getCode());
        sysStruroleAudit.setLastEditor(ShiroKit.getUser().getId());
        if (sids.length == rids.length && sids.length == oids.length && rids.length == oids.length) {
            ArrayList<SysStruRole> addBpmList = new ArrayList<SysStruRole>();
            ArrayList<SysStruRole> deleteBpmList = new ArrayList<SysStruRole>();
            for (int i = 0; i < sids.length; ++i) {
                SysStruRole sysStruRole;
                List list = this.sysStruRoleMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"stru_id", (Object)sids[i])).eq((Object)"granted_role", (Object)rids[i]));
                if (ToolUtil.isEmpty((Object)list)) {
                    sysStruRole = new SysStruRole();
                    sysStruRole.setCreateTime(new Date());
                    sysStruRole.setLastTime(new Date());
                    sysStruRole.setCreator(ShiroKit.getUser().getId());
                    sysStruRole.setLastEditor(ShiroKit.getUser().getId());
                    sysStruRole.setStruId(sids[i]);
                    sysStruRole.setGrantedRole(rids[i]);
                    if (ADD.equals(oids[i])) {
                        this.sysStruRoleMapper.insert((Object)sysStruRole);
                    }
                    if (ADD.equals(oids[i])) {
                        addBpmList.add(sysStruRole);
                    } else if (DELETE.equals(oids[i])) {
                        deleteBpmList.add(sysStruRole);
                    }
                } else {
                    sysStruRole = new SysStruRole();
                    sysStruRole.setCreateTime(new Date());
                    sysStruRole.setLastTime(new Date());
                    sysStruRole.setCreator(ShiroKit.getUser().getId());
                    sysStruRole.setLastEditor(ShiroKit.getUser().getId());
                    sysStruRole.setStruId(sids[i]);
                    sysStruRole.setGrantedRole(rids[i]);
                    if (ADD.equals(oids[i])) {
                        this.sysStruRoleMapper.update((Object)sysStruRole, (Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"stru_id", (Object)sids[i])).eq((Object)"granted_role", (Object)rids[i]));
                    } else if (DELETE.equals(oids[i])) {
                        this.sysStruRoleMapper.delete((Wrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"stru_id", (Object)sids[i])).eq((Object)"granted_role", (Object)rids[i]));
                    }
                    if (ADD.equals(oids[i])) {
                        addBpmList.add(sysStruRole);
                    } else if (DELETE.equals(oids[i])) {
                        deleteBpmList.add(sysStruRole);
                    }
                }
                this.sysStruroleAuditMapper.update((Object)sysStruroleAudit, (Wrapper)((UpdateWrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"STRU_ID", (Object)sids[i])).eq((Object)"role_id", (Object)rids[i])).eq((Object)"operation_type", (Object)oids[i]));
            }
            this.abstractPushMsgMatcher.insertOperation("struRole", "add", addBpmList, "");
            this.abstractPushMsgMatcher.insertOperation("struRole", "delete", deleteBpmList, "");
        }
    }

    @Override
    public void refuseSubmit(String struId, String roleId, String opsType) {
        String[] sids = struId.split(",");
        String[] rids = roleId.split(",");
        String[] oids = opsType.split(",");
        SysStruroleAudit sysStruroleAudit = new SysStruroleAudit();
        sysStruroleAudit.setLastTime(new Date());
        sysStruroleAudit.setStatus(StruRoleStatus.REFUSE.getCode());
        if (sids.length == rids.length && sids.length == oids.length && rids.length == oids.length) {
            for (int i = 0; i < sids.length; ++i) {
                this.sysStruroleAuditMapper.update((Object)sysStruroleAudit, (Wrapper)((UpdateWrapper)((UpdateWrapper)new UpdateWrapper().eq((Object)"stru_id", (Object)sids[i])).eq((Object)"role_id", (Object)rids[i])).eq((Object)"operation_type", (Object)oids[i]));
            }
        }
    }

    @Override
    public int isDelete(String id) {
        return this.sysStruroleAuditMapper.isDelete(id);
    }
}

