/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.bsp.permit.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jxdinfo.hussar.bpm.messagepush.BpmAbstractPushMsgMatcher;
import com.jxdinfo.hussar.bsp.organ.vo.RoleOrgStruVo;
import com.jxdinfo.hussar.bsp.permit.dao.SysStruRoleMapper;
import com.jxdinfo.hussar.bsp.permit.dao.SysStruroleAuditMapper;
import com.jxdinfo.hussar.bsp.permit.model.SysStruRole;
import com.jxdinfo.hussar.bsp.permit.model.SysStruroleAudit;
import com.jxdinfo.hussar.bsp.permit.service.ISysRolesService;
import com.jxdinfo.hussar.bsp.permit.service.ISysStruRoleService;
import com.jxdinfo.hussar.bsp.permit.service.ISysStruroleAuditService;
import com.jxdinfo.hussar.common.constant.state.StruRoleStatus;
import com.jxdinfo.hussar.config.properties.GlobalProperties;
import com.jxdinfo.hussar.core.base.tips.ErrorTip;
import com.jxdinfo.hussar.core.base.tips.Tip;
import com.jxdinfo.hussar.core.constant.HttpCode;
import com.jxdinfo.hussar.core.shiro.ShiroKit;
import com.jxdinfo.hussar.core.util.ToolUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysStruRoleServiceImpl
extends ServiceImpl<SysStruRoleMapper, SysStruRole>
implements ISysStruRoleService {
    @Resource
    private SysStruRoleMapper sysStruRoleMapper;
    @Autowired
    private ISysRolesService sysRolesService;
    @Resource
    private GlobalProperties globalProperties;
    @Resource
    private SysStruroleAuditMapper sysStruroleAuditMapper;
    @Autowired
    private ISysStruroleAuditService sysStruroleAuditService;
    private static final String ADD = "1";
    private static final String DELETE = "2";
    @Resource
    private BpmAbstractPushMsgMatcher bpmAbstractPushMsgMatcher;

    @Override
    public void deleteNotPublicRole(String struId) {
        this.sysStruRoleMapper.deleteNotPublicRole(struId);
    }

    @Override
    public void addRecord(SysStruRole sysStruRole) {
        this.sysStruRoleMapper.insert((Object)sysStruRole);
    }

    @Override
    public List<String> selectStruIdByRoleId(String roleId) {
        return this.sysStruRoleMapper.selectStruIdByRoleId(roleId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Tip addOrDelUserRole(List<RoleOrgStruVo> adds, List<RoleOrgStruVo> dels, String roleId) {
        if (ToolUtil.isNotEmpty((Object)roleId)) {
            return new ErrorTip(HttpCode.INTERNAL_SERVER_ERROR.value().intValue(), "");
        }
        ArrayList<String> hasDel = new ArrayList<String>();
        for (RoleOrgStruVo roleOrgStruVo : dels) {
            hasDel.add(roleOrgStruVo.getId());
        }
        ArrayList<String> addIds = new ArrayList<String>();
        for (RoleOrgStruVo roleOrgStruVo : adds) {
            addIds.add(roleOrgStruVo.getId());
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq((Object)"GRANTED_ROLE", (Object)roleId)).eq((Object)"ADMIN_OPTION", (Object)ADD);
        List se = this.sysStruRoleMapper.selectList((Wrapper)queryWrapper);
        for (Object sysStruRole : se) {
            for (int i = 0; i < addIds.size(); ++i) {
                if (!((String)addIds.get(i)).equals(((SysStruRole)((Object)sysStruRole)).getStruId())) continue;
                addIds.remove(addIds.get(i));
                --i;
            }
        }
        ArrayList<String> delNew = new ArrayList<String>();
        for (SysStruRole sysStruRole : se) {
            for (String string : hasDel) {
                if (!string.equals(sysStruRole.getStruId())) continue;
                delNew.add(string);
            }
        }
        List auditList = this.sysStruroleAuditMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"ROlE_ID", (Object)roleId));
        String currentUser = ShiroKit.getUser().getId();
        Date currentDate = new Date();
        if (this.globalProperties.isRoleAudit()) {
            Object sysStruroleAudit;
            boolean exist;
            if (ToolUtil.isNotEmpty(addIds)) {
                for (String struId : addIds) {
                    exist = false;
                    for (SysStruroleAudit audit : auditList) {
                        if (!struId.equals(audit.getStruId())) continue;
                        exist = true;
                        audit.setOperationType(ADD);
                        audit.setStatus(StruRoleStatus.LOCKED.getCode());
                        audit.setLastTime(currentDate);
                        audit.setLastEditor(currentUser);
                        this.sysStruroleAuditService.update((Object)audit, (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"STRU_ID", (Object)struId)).eq((Object)"ROLE_ID", (Object)audit.getRoleId()));
                    }
                    if (exist) continue;
                    sysStruroleAudit = new SysStruroleAudit();
                    ((SysStruroleAudit)((Object)sysStruroleAudit)).setStruId(struId);
                    ((SysStruroleAudit)((Object)sysStruroleAudit)).setRoleId(roleId);
                    ((SysStruroleAudit)((Object)sysStruroleAudit)).setStatus(StruRoleStatus.LOCKED.getCode());
                    ((SysStruroleAudit)((Object)sysStruroleAudit)).setOperationType(ADD);
                    ((SysStruroleAudit)((Object)sysStruroleAudit)).setCreateTime(currentDate);
                    ((SysStruroleAudit)((Object)sysStruroleAudit)).setLastTime(currentDate);
                    ((SysStruroleAudit)((Object)sysStruroleAudit)).setCreator(currentUser);
                    ((SysStruroleAudit)((Object)sysStruroleAudit)).setLastEditor(currentUser);
                    this.sysStruroleAuditService.save(sysStruroleAudit);
                }
            }
            if (ToolUtil.isNotEmpty(delNew)) {
                for (String struId : delNew) {
                    exist = false;
                    for (SysStruroleAudit audit : auditList) {
                        if (!struId.equals(audit.getStruId())) continue;
                        exist = true;
                        audit.setOperationType(DELETE);
                        audit.setStatus(StruRoleStatus.LOCKED.getCode());
                        audit.setLastTime(currentDate);
                        audit.setLastEditor(currentUser);
                        this.sysStruroleAuditService.update((Object)audit, (Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"STRU_ID", (Object)struId)).eq((Object)"ROLE_ID", (Object)audit.getRoleId()));
                    }
                    if (exist) continue;
                    sysStruroleAudit = new SysStruroleAudit();
                    ((SysStruroleAudit)((Object)sysStruroleAudit)).setStruId(struId);
                    ((SysStruroleAudit)((Object)sysStruroleAudit)).setRoleId(roleId);
                    ((SysStruroleAudit)((Object)sysStruroleAudit)).setStatus(StruRoleStatus.LOCKED.getCode());
                    ((SysStruroleAudit)((Object)sysStruroleAudit)).setOperationType(DELETE);
                    ((SysStruroleAudit)((Object)sysStruroleAudit)).setCreateTime(currentDate);
                    ((SysStruroleAudit)((Object)sysStruroleAudit)).setLastTime(currentDate);
                    ((SysStruroleAudit)((Object)sysStruroleAudit)).setCreator(currentUser);
                    ((SysStruroleAudit)((Object)sysStruroleAudit)).setLastEditor(currentUser);
                    this.sysStruroleAuditService.save(sysStruroleAudit);
                }
            }
            if (addIds.size() > 0 || delNew.size() > 0) {
                return new ErrorTip(HttpCode.OK.value().intValue(), "\u63d0\u4ea4\u6210\u529f\uff01\u5ba1\u6838\u901a\u8fc7\u540e\u751f\u6548\uff01");
            }
        } else {
            if (ToolUtil.isNotEmpty(delNew)) {
                this.sysStruRoleMapper.delete((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"GRANTED_ROLE", (Object)roleId)).in((Object)"USER_ID", delNew));
            }
            ArrayList<SysStruRole> arrayList = new ArrayList<SysStruRole>();
            for (String struId : addIds) {
                SysStruRole sysStruRole = new SysStruRole();
                sysStruRole.setStruId(struId);
                sysStruRole.setGrantedRole(roleId);
                sysStruRole.setCreateTime(currentDate);
                sysStruRole.setLastTime(currentDate);
                sysStruRole.setCreator(currentUser);
                sysStruRole.setLastEditor(currentUser);
                arrayList.add(sysStruRole);
                this.sysRolesService.delRedisAuthInfo(struId);
            }
        }
        return new ErrorTip(HttpCode.OK.value().intValue(), "\u4fdd\u5b58\u6210\u529f\uff01");
    }
}

